/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.internal.core.parser.ContextException;
import org.eclipse.cdt.internal.core.parser.IScannerContext;
import org.eclipse.cdt.internal.core.parser.ScannerContext;

public class ContextStack {
    private final IParserLogService log;
    private IScannerContext currentContext;
    private IScannerContext topContext;
    private Stack contextStack = new Stack();
    private LinkedList undoStack = new LinkedList();
    private Set inclusions = new HashSet();
    private Set defines = new HashSet();

    public ContextStack(IParserLogService l) {
        this.log = l;
    }

    public void updateContext(Reader reader, String filename, int type, IASTInclusion inclusion, ISourceElementRequestor requestor) throws ContextException {
        this.updateContext(reader, filename, type, inclusion, requestor, -1, -1);
    }

    public void updateContext(Reader reader, String filename, int type, IASTInclusion inclusion, ISourceElementRequestor requestor, int macroOffset, int macroLength) throws ContextException {
        int startLine = 1;
        if (type == 3) {
            if (this.currentContext.getKind() == 3) {
                macroOffset = this.currentContext.getMacroOffset();
                macroLength = this.currentContext.getMacroLength();
            }
            startLine = this.currentContext.getLine();
        }
        this.undoStack.clear();
        IScannerContext context = new ScannerContext().initialize(reader, filename, type, null, macroOffset, macroLength, startLine);
        context.setExtension(inclusion);
        this.push(context, requestor);
    }

    protected void push(IScannerContext context, ISourceElementRequestor requestor) throws ContextException {
        if (context.getKind() == 2) {
            if (!this.inclusions.add(context.getFilename())) {
                throw new ContextException(0x200000B);
            }
            context.getExtension().enterScope(requestor);
        } else if (context.getKind() == 3 && !this.defines.add(context.getFilename())) {
            throw new ContextException(0x2000005);
        }
        if (this.currentContext != null) {
            this.contextStack.push(this.currentContext);
        }
        this.currentContext = context;
        if (context.getKind() == 1) {
            this.topContext = context;
        }
    }

    public boolean rollbackContext(ISourceElementRequestor requestor) {
        try {
            this.currentContext.getReader().close();
        }
        catch (IOException iOException) {
            this.log.traceLog("ContextStack : Error closing reader ");
        }
        if (this.currentContext.getKind() == 2) {
            this.inclusions.remove(this.currentContext.getFilename());
            this.currentContext.getExtension().exitScope(requestor);
        } else if (this.currentContext.getKind() == 3) {
            this.defines.remove(this.currentContext.getFilename());
        }
        this.undoStack.addFirst(this.currentContext);
        if (this.contextStack.isEmpty()) {
            this.currentContext = null;
            return false;
        }
        this.currentContext = (ScannerContext)this.contextStack.pop();
        return true;
    }

    public void undoRollback(IScannerContext undoTo, ISourceElementRequestor requestor) throws ContextException {
        if (this.currentContext == undoTo) {
            return;
        }
        int size = this.undoStack.size();
        if (size > 0) {
            int i = size;
            while (i > 0) {
                this.push((IScannerContext)this.undoStack.removeFirst(), requestor);
                if (this.currentContext == undoTo) break;
                --i;
            }
        }
    }

    protected boolean shouldExpandDefinition(String symbol) {
        return !this.defines.contains(symbol);
    }

    public IScannerContext getCurrentContext() {
        return this.currentContext;
    }

    public IScannerContext getTopContext() {
        return this.topContext;
    }

    public IScannerContext getMostRelevantFileContext() {
        if (this.currentContext != null) {
            if (this.currentContext.getKind() == 1) {
                return this.currentContext;
            }
            if (this.currentContext.getKind() == 2) {
                return this.currentContext;
            }
        }
        IScannerContext context = null;
        int i = this.contextStack.size() - 1;
        while (i >= 0) {
            context = (IScannerContext)this.contextStack.get(i);
            if (context.getKind() == 2 || context.getKind() == 1) break;
            if (i == 0) {
                context = null;
            }
            --i;
        }
        return context;
    }

    public int getCurrentLineNumber() {
        return this.getMostRelevantFileContext() != null ? this.getMostRelevantFileContext().getLine() : -1;
    }

    public int getTopFileLineNumber() {
        return this.topContext.getLine();
    }
}

