/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.Map;
import org.eclipse.cdt.core.parser.IProblem;

public class Problem
implements IProblem {
    private final Map arguments;
    private final int id;
    private final int sourceStart;
    private final int sourceEnd;
    private final int lineNumber;
    private final boolean isError;
    private final boolean isWarning;
    private final char[] originatingFileName;
    private final String message;

    public Problem(int id, int start, int end, int line, char[] file, String message, Map arguments, boolean warn, boolean error) {
        this.id = id;
        this.sourceStart = start;
        this.sourceEnd = end;
        this.lineNumber = line;
        this.originatingFileName = file;
        this.message = message;
        this.arguments = arguments;
        this.isWarning = warn;
        this.isError = error;
    }

    public int getID() {
        return this.id;
    }

    public char[] getOriginatingFileName() {
        return this.originatingFileName;
    }

    public int getSourceEnd() {
        return this.sourceEnd;
    }

    public int getSourceLineNumber() {
        return this.lineNumber;
    }

    public int getSourceStart() {
        return this.sourceStart;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean checkCategory(int bitmask) {
        return (this.id & bitmask) != 0;
    }

    public Map getArguments() {
        return this.arguments;
    }
}

