/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.internal.core.parser.ast.Offsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTAnonymousDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTReferenceStore;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;

public class ASTUsingDirective
extends ASTAnonymousDeclaration
implements IASTUsingDirective {
    private final IASTNamespaceDefinition namespace;
    private Offsets offsets = new Offsets();
    private final ASTReferenceStore referenceDelegate;

    public ASTUsingDirective(IContainerSymbol ownerSymbol, IASTNamespaceDefinition namespaceDefinition, int startingOffset, int endingOffset, List references) {
        super(ownerSymbol);
        this.namespace = namespaceDefinition;
        this.setStartingOffset(startingOffset);
        this.setEndingOffset(endingOffset);
        this.referenceDelegate = new ASTReferenceStore(references);
    }

    public String getNamespaceName() {
        String[] fqn = this.namespace.getFullyQualifiedName();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < fqn.length) {
            buffer.append(fqn[i]);
            if (i + 1 != fqn.length) {
                buffer.append("::");
            }
            ++i;
        }
        return buffer.toString();
    }

    public void setStartingOffset(int o) {
        this.offsets.setStartingOffset(o);
    }

    public void setEndingOffset(int o) {
        this.offsets.setEndingOffset(o);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            requestor.acceptUsingDirective(this);
        }
        catch (Exception exception) {}
        this.referenceDelegate.processReferences(requestor);
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public IASTNamespaceDefinition getNamespaceDefinition() throws ASTNotImplementedException {
        return this.namespace;
    }

    public IASTNode.LookupResult lookup(String prefix, IASTNode.LookupKind kind) {
        return null;
    }
}

