/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupFactory;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLocator;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.internal.ui.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.Separator;
import org.eclipse.cdt.debug.internal.ui.wizards.AddSourceLocationWizard;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceListDialogField;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceLookupLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SourceLookupBlock
implements Observer {
    private Composite fControl = null;
    private Shell fShell = null;
    private CheckedListDialogField fGeneratedSourceListField = this.createGeneratedSourceListField();
    private SourceListDialogField fAddedSourceListField = this.createAddedSourceListField();
    private SelectionButtonDialogField fSearchForDuplicateFiles = this.createSearchForDuplicateFilesButton();
    private ILaunchConfigurationDialog fLaunchConfigurationDialog = null;
    private boolean fIsDirty = false;
    private IProject fProject = null;
    static /* synthetic */ Class class$0;

    public void createControl(Composite parent) {
        this.fShell = parent.getShell();
        this.fControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fControl.setLayout((Layout)layout);
        this.fControl.setLayoutData((Object)new GridData(1808));
        this.fControl.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)this.fControl);
        this.fGeneratedSourceListField.doFillIntoGrid(this.fControl, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fGeneratedSourceListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fGeneratedSourceListField.getLabelControl(null), converter.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fGeneratedSourceListField.getListControl(null));
        ((CheckboxTableViewer)this.fGeneratedSourceListField.getTableViewer()).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof IProjectSourceLocation) {
                    SourceLookupBlock.this.doCheckStateChanged();
                }
            }
        });
        new Separator().doFillIntoGrid(this.fControl, 3, converter.convertHeightInCharsToPixels(1));
        this.fAddedSourceListField.doFillIntoGrid(this.fControl, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fAddedSourceListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fAddedSourceListField.getLabelControl(null), converter.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fAddedSourceListField.getListControl(null));
        this.fSearchForDuplicateFiles.doFillIntoGrid(this.fControl, 3);
    }

    public Control getControl() {
        return this.fControl;
    }

    public void initialize(ILaunchConfiguration configuration) {
        block7: {
            IProject project = this.getProjectFromLaunchConfiguration(configuration);
            if (project != null) {
                IProject oldProject = this.getProject();
                this.setProject(project);
                if (project.equals((Object)oldProject)) {
                    try {
                        String id = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "");
                        if (!this.isEmpty(id) && !CDebugUIPlugin.getDefaultSourceLocatorID().equals(id) && !CDebugUIPlugin.getDefaultSourceLocatorOldID().equals(id)) break block7;
                        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, "");
                        if (!this.isEmpty(memento)) {
                            this.initializeFromMemento(memento);
                            break block7;
                        }
                        this.initializeDefaults();
                    }
                    catch (CoreException coreException) {
                        this.initializeDefaults();
                    }
                } else {
                    this.initializeDefaults();
                }
            } else {
                this.initializeGeneratedLocations(null, new ICSourceLocation[0]);
                this.resetAdditionalLocations(CDebugCorePlugin.getDefault().getCommonSourceLocations());
                this.fSearchForDuplicateFiles.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_SEARCH_DUPLICATE_FILES));
            }
        }
    }

    private void initializeFromMemento(String memento) throws CoreException {
        IPersistableSourceLocator locator = CDebugUIPlugin.createDefaultSourceLocator();
        locator.initializeFromMemento(memento);
        if (locator instanceof IAdaptable) {
            ICSourceLocator clocator;
            IAdaptable iAdaptable = (IAdaptable)locator;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clocator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz)) != null) {
                this.initializeFromLocator(clocator);
            }
        }
    }

    private void initializeDefaults() {
        this.initializeGeneratedLocations(this.getProject(), new ICSourceLocation[]{SourceLookupFactory.createProjectSourceLocation((IProject)this.getProject())});
        this.resetAdditionalLocations(CDebugCorePlugin.getDefault().getCommonSourceLocations());
        this.fSearchForDuplicateFiles.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_SEARCH_DUPLICATE_FILES));
    }

    private void initializeFromLocator(ICSourceLocator locator) {
        ICSourceLocation[] locations = locator.getSourceLocations();
        this.initializeGeneratedLocations(locator.getProject(), locations);
        this.resetAdditionalLocations(locations);
        this.fSearchForDuplicateFiles.setSelection(locator.searchForDuplicateFiles());
    }

    private void initializeGeneratedLocations(IProject project, ICSourceLocation[] locations) {
        boolean checked;
        this.fGeneratedSourceListField.removeAllElements();
        if (project == null || !project.exists() || !project.isOpen()) {
            return;
        }
        List list = CDebugUtils.getReferencedProjects((IProject)project);
        IProject[] refs = list.toArray(new IProject[list.size()]);
        ICSourceLocation loc = this.getLocationForProject(project, locations);
        boolean bl = checked = loc != null && ((IProjectSourceLocation)loc).isGeneric();
        if (loc == null) {
            loc = SourceLookupFactory.createProjectSourceLocation((IProject)project, (boolean)true);
        }
        this.fGeneratedSourceListField.addElement(loc);
        this.fGeneratedSourceListField.setChecked(loc, checked);
        int i = 0;
        while (i < refs.length) {
            loc = this.getLocationForProject(refs[i], locations);
            boolean bl2 = checked = loc != null;
            if (loc == null) {
                loc = SourceLookupFactory.createProjectSourceLocation((IProject)refs[i], (boolean)true);
            }
            this.fGeneratedSourceListField.addElement(loc);
            this.fGeneratedSourceListField.setChecked(loc, checked);
            ++i;
        }
    }

    private void resetGeneratedLocations(ICSourceLocation[] locations) {
        this.fGeneratedSourceListField.checkAll(false);
        int i = 0;
        while (i < locations.length) {
            if (locations[i] instanceof IProjectSourceLocation && ((IProjectSourceLocation)locations[i]).isGeneric()) {
                this.fGeneratedSourceListField.setChecked(locations[i], true);
            }
            ++i;
        }
    }

    private void resetAdditionalLocations(ICSourceLocation[] locations) {
        this.fAddedSourceListField.removeAllElements();
        int i = 0;
        while (i < locations.length) {
            if (!(locations[i] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)locations[i]).isGeneric()) {
                this.fAddedSourceListField.addElement(locations[i]);
            }
            ++i;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        IPersistableSourceLocator locator = CDebugUIPlugin.createDefaultSourceLocator();
        try {
            locator.initializeDefaults((ILaunchConfiguration)configuration);
            if (locator instanceof IAdaptable) {
                ICSourceLocator clocator;
                IAdaptable iAdaptable = (IAdaptable)locator;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("[Lorg.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((clocator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz)) != null) {
                    clocator.setSourceLocations(this.getSourceLocations());
                    clocator.setSearchForDuplicateFiles(this.searchForDuplicateFiles());
                }
            }
            configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, locator.getMemento());
        }
        catch (CoreException coreException) {}
    }

    protected void doCheckStateChanged() {
        this.fIsDirty = true;
        this.updateLaunchConfigurationDialog();
    }

    protected void doGeneratedSourceButtonPressed(int index) {
        switch (index) {
            case 0: 
            case 1: {
                this.fIsDirty = true;
            }
        }
        if (this.isDirty()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void doGeneratedSourceSelectionChanged() {
    }

    protected void doAddedSourceButtonPressed(int index) {
        switch (index) {
            case 0: {
                if (!this.addSourceLocation()) break;
                this.fIsDirty = true;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.fIsDirty = true;
            }
        }
        if (this.isDirty()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    public ICSourceLocation[] getSourceLocations() {
        ArrayList<IProjectSourceLocation> list = new ArrayList<IProjectSourceLocation>(this.getGeneratedSourceListField().getElements().size() + this.getAddedSourceListField().getElements().size());
        Iterator it = this.getGeneratedSourceListField().getElements().iterator();
        while (it.hasNext()) {
            IProjectSourceLocation location = (IProjectSourceLocation)it.next();
            if (!this.getGeneratedSourceListField().isChecked(location)) continue;
            list.add(location);
        }
        list.addAll(this.getAddedSourceListField().getElements());
        return list.toArray(new ICSourceLocation[list.size()]);
    }

    private boolean addSourceLocation() {
        AddSourceLocationWizard wizard = new AddSourceLocationWizard(this.getSourceLocations());
        WizardDialog dialog = new WizardDialog(this.fControl.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            this.fAddedSourceListField.addElement(wizard.getSourceLocation());
            return true;
        }
        return false;
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.getLaunchConfigurationDialog() != null) {
            this.getLaunchConfigurationDialog().updateMessage();
            this.getLaunchConfigurationDialog().updateButtons();
            this.fIsDirty = false;
        }
    }

    public ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.fLaunchConfigurationDialog;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog launchConfigurationDialog) {
        this.fLaunchConfigurationDialog = launchConfigurationDialog;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    protected Object getSelection() {
        List list = this.fAddedSourceListField.getSelectedElements();
        return list.size() > 0 ? list.get(0) : null;
    }

    protected void restoreDefaults() {
        ICSourceLocation[] locations = new ICSourceLocation[]{};
        if (this.getProject() != null) {
            locations = CSourceLocator.getDefaultSourceLocations((IProject)this.getProject());
        }
        this.resetGeneratedLocations(locations);
        this.resetAdditionalLocations(locations);
        this.fSearchForDuplicateFiles.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_SEARCH_DUPLICATE_FILES));
    }

    public IProject getProject() {
        return this.fProject;
    }

    private void setProject(IProject project) {
        this.fProject = project;
    }

    public SourceListDialogField getAddedSourceListField() {
        return this.fAddedSourceListField;
    }

    public CheckedListDialogField getGeneratedSourceListField() {
        return this.fGeneratedSourceListField;
    }

    private ICSourceLocation getLocationForProject(IProject project, ICSourceLocation[] locations) {
        int i = 0;
        while (i < locations.length) {
            if (locations[i] instanceof IProjectSourceLocation && project.equals((Object)((IProjectSourceLocation)locations[i]).getProject())) {
                return locations[i];
            }
            ++i;
        }
        return null;
    }

    public boolean searchForDuplicateFiles() {
        return this.fSearchForDuplicateFiles != null ? this.fSearchForDuplicateFiles.isSelected() : false;
    }

    private CheckedListDialogField createGeneratedSourceListField() {
        String[] generatedSourceButtonLabels = new String[]{"Select All", "Deselect All"};
        IListAdapter generatedSourceAdapter = new IListAdapter(){

            public void customButtonPressed(DialogField field, int index) {
                SourceLookupBlock.this.doGeneratedSourceButtonPressed(index);
            }

            public void selectionChanged(DialogField field) {
                SourceLookupBlock.this.doGeneratedSourceSelectionChanged();
            }
        };
        CheckedListDialogField field = new CheckedListDialogField(generatedSourceAdapter, generatedSourceButtonLabels, (ILabelProvider)new SourceLookupLabelProvider());
        field.setLabelText("Generic Source Locations");
        field.setCheckAllButtonIndex(0);
        field.setUncheckAllButtonIndex(1);
        field.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                SourceLookupBlock.this.doCheckStateChanged();
            }
        });
        return field;
    }

    private SourceListDialogField createAddedSourceListField() {
        SourceListDialogField field = new SourceListDialogField("Additional Source Locations", new IListAdapter(){

            public void customButtonPressed(DialogField field, int index) {
                SourceLookupBlock.this.doAddedSourceButtonPressed(index);
            }

            public void selectionChanged(DialogField field) {
            }
        });
        field.addObserver(this);
        return field;
    }

    private SelectionButtonDialogField createSearchForDuplicateFilesButton() {
        SelectionButtonDialogField button = new SelectionButtonDialogField(32);
        button.setLabelText("Search for duplicate source files");
        button.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                SourceLookupBlock.this.doCheckStateChanged();
            }
        });
        return button;
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof Integer && (Integer)arg == 0) {
            if (this.addSourceLocation()) {
                this.fIsDirty = true;
            }
        } else {
            this.fIsDirty = true;
        }
        if (this.fIsDirty) {
            this.updateLaunchConfigurationDialog();
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public void dispose() {
        if (this.getAddedSourceListField() != null) {
            this.getAddedSourceListField().deleteObserver(this);
            this.getAddedSourceListField().dispose();
        }
    }

    private IProject getProjectFromLaunchConfiguration(ILaunchConfiguration configuration) {
        try {
            IProject project;
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (!this.isEmpty(projectName) && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && project.exists() && project.isOpen()) {
                return project;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }
}

