/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.cdt.internal.corext.template.Template;
import org.eclipse.cdt.internal.corext.template.TemplateMessages;
import org.eclipse.cdt.internal.corext.template.TemplateTranslator;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.template.TemplateVariableProcessor;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class EditTemplateDialog
extends StatusDialog {
    private final Template fTemplate;
    protected Text fNameText;
    private Text fDescriptionText;
    protected Combo fContextCombo;
    protected SourceViewer fPatternEditor;
    private Button fInsertVariableButton;
    protected TemplateTranslator fTranslator = new TemplateTranslator();
    protected boolean fSuppressError = true;
    private Map fGlobalActions = new HashMap(10);
    private List fSelectionActions = new ArrayList(3);
    private Vector fContextTypes = new Vector();
    protected final TemplateVariableProcessor fProcessor = new TemplateVariableProcessor();

    public EditTemplateDialog(Shell parent, Template template, boolean edit) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String title = edit ? TemplateMessages.getString("EditTemplateDialog.title.edit") : TemplateMessages.getString("EditTemplateDialog.title.new");
        this.setTitle(title);
        this.fTemplate = template;
        ContextTypeRegistry registry = ContextTypeRegistry.getInstance();
        Iterator iterator = registry.iterator();
        while (iterator.hasNext()) {
            this.fContextTypes.add(iterator.next());
        }
        if (this.fContextTypes.size() > 0) {
            this.fProcessor.setContextType(ContextTypeRegistry.getInstance().getContextType((String)this.fContextTypes.get(0)));
        }
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        EditTemplateDialog.createLabel(parent, TemplateMessages.getString("EditTemplateDialog.name"));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fNameText = EditTemplateDialog.createText(composite);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (EditTemplateDialog.this.fSuppressError && EditTemplateDialog.this.fNameText.getText().trim().length() != 0) {
                    EditTemplateDialog.this.fSuppressError = false;
                }
                EditTemplateDialog.this.updateButtons();
            }
        });
        EditTemplateDialog.createLabel(composite, TemplateMessages.getString("EditTemplateDialog.context"));
        this.fContextCombo = new Combo(composite, 8);
        Iterator iterator = ((AbstractList)this.fContextTypes).iterator();
        while (iterator.hasNext()) {
            this.fContextCombo.add((String)iterator.next());
        }
        this.fContextCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = EditTemplateDialog.this.fContextCombo.getText();
                EditTemplateDialog.this.fProcessor.setContextType(ContextTypeRegistry.getInstance().getContextType(name));
            }
        });
        EditTemplateDialog.createLabel(parent, TemplateMessages.getString("EditTemplateDialog.description"));
        this.fDescriptionText = EditTemplateDialog.createText(parent);
        composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1040));
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        EditTemplateDialog.createLabel(composite, TemplateMessages.getString("EditTemplateDialog.pattern"));
        this.fPatternEditor = this.createEditor(parent);
        Label filler = new Label(composite, 0);
        filler.setLayoutData((Object)new GridData(1040));
        this.fInsertVariableButton = new Button(composite, 0);
        this.fInsertVariableButton.setLayoutData((Object)EditTemplateDialog.getButtonGridData(this.fInsertVariableButton));
        this.fInsertVariableButton.setText(TemplateMessages.getString("EditTemplateDialog.insert.variable"));
        this.fInsertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.fPatternEditor.getTextWidget().setFocus();
                EditTemplateDialog.this.fPatternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fNameText.setText(this.fTemplate.getName());
        this.fDescriptionText.setText(this.fTemplate.getDescription());
        this.fContextCombo.select(this.getIndex(this.fTemplate.getContextTypeName()));
        this.initializeActions();
        return composite;
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        data.heightHint = SWTUtil.getButtonHeigthHint(button);
        return data;
    }

    private static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private SourceViewer createEditor(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, 2816);
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        viewer.configure((SourceViewerConfiguration)new SimpleCSourceViewerConfiguration(tools, null, this.fProcessor));
        viewer.setEditable(true);
        viewer.setDocument((IDocument)new Document(this.fTemplate.getPattern()));
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
        viewer.getTextWidget().setFont(font);
        Control control = viewer.getControl();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        data.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                try {
                    EditTemplateDialog.this.fTranslator.translate(event.getDocumentEvent().getDocument().get());
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e);
                }
                EditTemplateDialog.this.updateUndoAction();
                EditTemplateDialog.this.updateButtons();
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditTemplateDialog.this.updateSelectionDependentActions();
            }
        });
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).prependVerifyKeyListener(new VerifyKeyListener(){

                public void verifyKey(VerifyEvent event) {
                    EditTemplateDialog.this.handleVerifyKeyPressed(event);
                }
            });
        } else {
            viewer.getTextWidget().addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    EditTemplateDialog.this.handleKeyPressed(e);
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        }
        return viewer;
    }

    protected void handleKeyPressed(KeyEvent event) {
        if (event.stateMask != 262144) {
            return;
        }
        switch (event.character) {
            case ' ': {
                this.fPatternEditor.doOperation(13);
                break;
            }
            case '\u001a': {
                this.fPatternEditor.doOperation(1);
            }
        }
    }

    protected void handleVerifyKeyPressed(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.stateMask != 262144) {
            return;
        }
        switch (event.character) {
            case ' ': {
                this.fPatternEditor.doOperation(13);
                event.doit = false;
                break;
            }
            case '\u001a': {
                this.fPatternEditor.doOperation(1);
                event.doit = false;
            }
        }
    }

    private void initializeActions() {
        TextViewerAction action = new TextViewerAction((ITextViewer)this.fPatternEditor, 1);
        action.setText(TemplateMessages.getString("EditTemplateDialog.undo"));
        this.fGlobalActions.put(ITextEditorActionConstants.UNDO, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 3);
        action.setText(TemplateMessages.getString("EditTemplateDialog.cut"));
        this.fGlobalActions.put(ITextEditorActionConstants.CUT, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 4);
        action.setText(TemplateMessages.getString("EditTemplateDialog.copy"));
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 5);
        action.setText(TemplateMessages.getString("EditTemplateDialog.paste"));
        this.fGlobalActions.put(ITextEditorActionConstants.PASTE, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 7);
        action.setText(TemplateMessages.getString("EditTemplateDialog.select.all"));
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 13);
        action.setText(TemplateMessages.getString("EditTemplateDialog.content.assist"));
        this.fGlobalActions.put("ContentAssistProposal", action);
        this.fSelectionActions.add(ITextEditorActionConstants.CUT);
        this.fSelectionActions.add(ITextEditorActionConstants.COPY);
        this.fSelectionActions.add(ITextEditorActionConstants.PASTE);
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EditTemplateDialog.this.fillContextMenu(mgr);
            }
        });
        StyledText text = this.fPatternEditor.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.PASTE));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.appendToGroup("group.generate", (IAction)this.fGlobalActions.get("ContentAssistProposal"));
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateUndoAction() {
        IAction action = (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void updateAction(String actionId) {
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private int getIndex(String context) {
        ContextTypeRegistry registry = ContextTypeRegistry.getInstance();
        registry.getContextType(context);
        if (context == null) {
            return -1;
        }
        return this.fContextTypes.indexOf(context);
    }

    protected void okPressed() {
        this.fTemplate.setName(this.fNameText.getText());
        this.fTemplate.setDescription(this.fDescriptionText.getText());
        this.fTemplate.setContext(this.fContextCombo.getText());
        this.fTemplate.setPattern(this.fPatternEditor.getTextWidget().getText());
        super.okPressed();
    }

    protected void updateButtons() {
        boolean valid = this.fNameText.getText().trim().length() != 0;
        StatusInfo status = new StatusInfo();
        if (!valid) {
            if (this.fSuppressError) {
                status.setError("");
            } else {
                status.setError(TemplateMessages.getString("EditTemplateDialog.error.noname"));
            }
        } else if (this.fTranslator.getErrorMessage() != null) {
            status.setError(this.fTranslator.getErrorMessage());
        }
        this.updateStatus(status);
    }

    private static class SimpleCSourceViewerConfiguration
    extends CSourceViewerConfiguration {
        private final IContentAssistProcessor fProcessor;

        SimpleCSourceViewerConfiguration(CTextTools tools, CEditor editor, IContentAssistProcessor processor) {
            super(tools, editor);
            this.fProcessor = processor;
        }

        public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
            IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
            ContentAssistant assistant = new ContentAssistant();
            assistant.setContentAssistProcessor(this.fProcessor, "__dftl_partition_content_type");
            assistant.enableAutoActivation(store.getBoolean("content_assist_autoactivation"));
            assistant.setAutoActivationDelay(store.getInt("content_assist_autoactivation_delay"));
            assistant.setProposalPopupOrientation(10);
            assistant.setContextInformationPopupOrientation(20);
            Display display = sourceViewer.getTextWidget().getDisplay();
            Color background = this.createColor(store, "content_assist_proposals_background", display);
            assistant.setContextInformationPopupBackground(background);
            assistant.setContextSelectorBackground(background);
            assistant.setProposalSelectorBackground(background);
            Color foreground = this.createColor(store, "content_assist_proposals_foreground", display);
            assistant.setContextInformationPopupForeground(foreground);
            assistant.setContextSelectorForeground(foreground);
            assistant.setProposalSelectorForeground(foreground);
            return assistant;
        }

        private Color createColor(IPreferenceStore store, String key, Display display) {
            RGB rgb = null;
            if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
                return new Color((Device)display, rgb);
            }
            return null;
        }
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer viewer, int operationCode) {
            this.fOperationCode = operationCode;
            this.fOperationTarget = viewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

