/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.util.Iterator;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.actions.NewProjectAction;

public abstract class AbstractOpenWizardAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private Class[] fActivatedOnTypes;
    private boolean fAcceptEmptySelection;
    private boolean fNoChecking;

    public AbstractOpenWizardAction(String label, boolean acceptEmptySelection) {
        this(label, null, acceptEmptySelection);
    }

    public AbstractOpenWizardAction(String label, Class[] activatedOnTypes, boolean acceptEmptySelection) {
        super(label);
        this.fActivatedOnTypes = activatedOnTypes;
        this.fAcceptEmptySelection = acceptEmptySelection;
        this.fNoChecking = false;
    }

    protected AbstractOpenWizardAction() {
        this.fActivatedOnTypes = null;
        this.fAcceptEmptySelection = true;
        this.fNoChecking = true;
    }

    protected IWorkbench getWorkbench() {
        return CUIPlugin.getDefault().getWorkbench();
    }

    private boolean isOfAcceptedType(Object obj) {
        if (this.fActivatedOnTypes != null) {
            int i = 0;
            while (i < this.fActivatedOnTypes.length) {
                if (this.fActivatedOnTypes[i].isInstance(obj)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private boolean isEnabled(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (this.isOfAcceptedType(obj) && this.shouldAcceptElement(obj)) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldAcceptElement(Object obj) {
        return true;
    }

    protected abstract Wizard createWizard() throws CoreException;

    protected IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchWindow window = CUIPlugin.getDefault().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public void run() {
        Shell shell = CUIPlugin.getDefault().getActiveWorkbenchShell();
        try {
            Wizard wizard = this.createWizard();
            if (wizard instanceof IWorkbenchWizard) {
                ((IWorkbenchWizard)wizard).init(this.getWorkbench(), this.getCurrentSelection());
            }
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            PixelConverter converter = new PixelConverter((Control)CUIPlugin.getDefault().getActiveWorkbenchShell());
            dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
            dialog.create();
            dialog.open();
        }
        catch (CoreException e) {
            String title = NewWizardMessages.getString("AbstractOpenWizardAction.createerror.title");
            String message = NewWizardMessages.getString("AbstractOpenWizardAction.createerror.message");
            ExceptionHandler.handle(e, shell, title, message);
        }
    }

    public boolean canActionBeAdded() {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null || selection.isEmpty()) {
            return this.fAcceptEmptySelection;
        }
        return this.isEnabled(selection);
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected boolean checkWorkspaceNotEmpty() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().getProjects().length == 0) {
            String message;
            String title;
            Shell shell = CUIPlugin.getDefault().getActiveWorkbenchShell();
            if (MessageDialog.openQuestion((Shell)shell, (String)(title = NewWizardMessages.getString("AbstractOpenWizardAction.noproject.title")), (String)(message = NewWizardMessages.getString("AbstractOpenWizardAction.noproject.message")))) {
                IWorkbenchWindow window = CUIPlugin.getDefault().getActiveWorkbenchWindow();
                new NewProjectAction(window).run();
                return workspace.getRoot().getProjects().length != 0;
            }
            return false;
        }
        return true;
    }
}

