/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICMemoryManager;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.preferences.ICDebugPreferenceConstants;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryPresentation;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryText;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MemoryControlArea
extends Composite
implements ITextOperationTarget {
    private MemoryView fMemoryView;
    private MemoryPresentation fPresentation;
    private int fIndex = 0;
    private ICMemoryManager fMemoryManager = null;
    private Text fAddressText;
    private Button fEvaluateButton;
    private MemoryText fMemoryText;
    private int fFormat = 0;
    private int fWordSize = 1;
    private int fNumberOfRows = 40;
    private int fNumberOfColumns = 16;
    private char fPaddingChar = (char)46;
    static /* synthetic */ Class class$0;

    public MemoryControlArea(Composite parent, int style, int index, MemoryView view) {
        super(parent, style);
        this.fMemoryView = view;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData gridData = new GridData(1808);
        this.setLayout((Layout)layout);
        this.setLayoutData(gridData);
        this.setIndex(index);
        this.fPresentation = this.createPresentation();
        this.fAddressText = this.createAddressText(this);
        this.fMemoryText = this.createMemoryText(this, style, this.fPresentation);
        this.setDefaultPreferences();
        this.updateToolTipText();
    }

    private void setDefaultPreferences() {
        char[] paddingCharStr = CDebugUIPlugin.getDefault().getPreferenceStore().getString("Memory.PaddingChar").toCharArray();
        this.setPaddingChar(paddingCharStr.length > 0 ? paddingCharStr[0] : (char)'.');
        this.fPresentation.setDisplayAscii(CDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(ICDebugPreferenceConstants.PREF_MEMORY_SHOW_ASCII));
    }

    private MemoryPresentation createPresentation() {
        return new MemoryPresentation();
    }

    public MemoryPresentation getPresentation() {
        return this.fPresentation;
    }

    private Text createAddressText(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 131072);
        label.setText("Address: ");
        label.pack();
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 && e.stateMask == 0) {
                    e.doit = false;
                    MemoryControlArea.this.handleAddressEnter();
                }
            }
        });
        text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }

            public void focusLost(FocusEvent e) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MemoryControlArea.this.handleAddressModification();
            }
        });
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }

            public void keyReleased(KeyEvent e) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }
        });
        text.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }

            public void mouseDown(MouseEvent e) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }

            public void mouseUp(MouseEvent e) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }
        });
        this.fEvaluateButton = new Button(composite, 8);
        this.fEvaluateButton.setText("Evaluate");
        this.fEvaluateButton.setToolTipText("Evaluate expression to address");
        this.fEvaluateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemoryControlArea.this.evaluateAddressExpression();
            }
        });
        return text;
    }

    private MemoryText createMemoryText(Composite parent, int styles, MemoryPresentation presentation) {
        return new MemoryText(parent, 35584, presentation);
    }

    protected void handleAddressEnter() {
        if (this.getMemoryManager() != null) {
            String address = this.fAddressText.getText().trim();
            try {
                this.removeBlock();
                if (address.length() > 0) {
                    this.createBlock(address);
                }
            }
            catch (DebugException e) {
                CDebugUIPlugin.errorDialog("Unable to get memory block.", e.getStatus());
            }
            this.refresh();
            this.getMemoryView().updateObjects();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("Memory.background.RGB")) {
            this.fMemoryText.setBackgroundColor();
        } else if (event.getProperty().equals("Memory.Foreground.RGB")) {
            this.fMemoryText.setForegroundColor();
        } else if (event.getProperty().equals("Memory.font")) {
            this.fMemoryText.changeFont();
        } else if (event.getProperty().equals("Memory.Address.RGB")) {
            this.fMemoryText.setAddressColor();
        } else if (event.getProperty().equals("Memory.Changed.RGB")) {
            this.fMemoryText.setChangedColor();
        } else if (event.getProperty().equals("Memory.Dirty.RGB")) {
            this.fMemoryText.setDirtyColor();
        } else if (event.getProperty().equals("Memory.PaddingChar")) {
            String paddingCharString = (String)event.getNewValue();
            this.setPaddingChar(paddingCharString.length() > 0 ? paddingCharString.charAt(0) : (char)'.');
            this.refresh();
        }
    }

    public void setInput(Object input) {
        this.setMemoryManager(input instanceof ICMemoryManager ? (ICMemoryManager)input : null);
        this.getPresentation().setMemoryBlock(this.getMemoryBlock());
        this.setState();
        this.refresh();
    }

    protected void refresh() {
        this.fAddressText.setText(this.getPresentation() != null ? this.getPresentation().getAddressExpression() : "");
        this.fMemoryText.refresh();
        this.getMemoryView().updateObjects();
        this.updateToolTipText();
    }

    protected void setMemoryManager(ICMemoryManager mm) {
        this.fMemoryManager = mm;
    }

    protected ICMemoryManager getMemoryManager() {
        return this.fMemoryManager;
    }

    protected IFormattedMemoryBlock getMemoryBlock() {
        return this.getMemoryManager() != null ? this.getMemoryManager().getBlock(this.getIndex()) : null;
    }

    protected int getIndex() {
        return this.fIndex;
    }

    protected void setIndex(int index) {
        this.fIndex = index;
    }

    private void createBlock(String address) throws DebugException {
        if (this.getMemoryManager() != null) {
            ICMemoryManager iCMemoryManager = this.getMemoryManager();
            int n = this.getIndex();
            ICMemoryManager iCMemoryManager2 = this.getMemoryManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.debug.core.model.IDebugTarget;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iCMemoryManager.setBlockAt(n, CDebugModel.createFormattedMemoryBlock((IDebugTarget)((IDebugTarget)iCMemoryManager2.getAdapter((Class)clazz)), (String)address, (int)this.getFormat(), (int)this.getWordSize(), (int)this.getNumberOfRows(), (int)this.getNumberOfColumns(), (char)this.getPaddingChar()));
            this.getMemoryBlock().setFrozen(!CDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(ICDebugPreferenceConstants.PREF_MEMORY_AUTO_REFRESH));
            this.getPresentation().setMemoryBlock(this.getMemoryBlock());
        }
        this.setMemoryTextState();
        this.updateToolTipText();
    }

    private void removeBlock() throws DebugException {
        if (this.getMemoryManager() != null) {
            this.getMemoryManager().removeBlock(this.getIndex());
            this.getPresentation().setMemoryBlock(null);
        }
        this.setMemoryTextState();
        this.updateToolTipText();
    }

    public int getFormat() {
        return this.fFormat;
    }

    public int getNumberOfColumns() {
        return this.fNumberOfColumns;
    }

    public int getNumberOfRows() {
        return this.fNumberOfRows;
    }

    public char getPaddingChar() {
        return this.fPaddingChar;
    }

    public int getWordSize() {
        return this.fWordSize;
    }

    public void setFormat(int format) {
        this.fFormat = format;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.fNumberOfColumns = numberOfColumns;
    }

    public void setNumberOfRows(int numberOfRows) {
        this.fNumberOfRows = numberOfRows;
    }

    public void setPaddingChar(char paddingChar) {
        this.fPaddingChar = paddingChar;
        if (this.getMemoryBlock() != null) {
            try {
                this.getMemoryBlock().reformat(this.getMemoryBlock().getFormat(), this.getMemoryBlock().getWordSize(), this.getMemoryBlock().getNumberOfRows(), this.getMemoryBlock().getNumberOfColumns(), this.fPaddingChar);
            }
            catch (DebugException debugException) {}
        }
    }

    public void setWordSize(int wordSize) {
        this.fWordSize = wordSize;
    }

    private void enableAddressText(boolean enable) {
        this.fAddressText.setEnabled(enable);
    }

    protected void setState() {
        this.enableAddressText(this.getMemoryManager() != null);
        this.setMemoryTextState();
    }

    private void setMemoryTextState() {
        this.fMemoryText.setEditable(this.getMemoryManager() != null && this.getMemoryBlock() != null);
    }

    protected MemoryText getMemoryText() {
        return this.fMemoryText;
    }

    protected void clear() {
        this.fAddressText.setText("");
        this.handleAddressEnter();
        this.updateToolTipText();
    }

    public void dispose() {
        if (this.getPresentation() != null) {
            this.getPresentation().dispose();
        }
        super.dispose();
    }

    protected String getTitle() {
        if (this.getParent() instanceof CTabFolder) {
            CTabItem[] tabItems = ((CTabFolder)this.getParent()).getItems();
            return tabItems[this.fIndex].getText();
        }
        return "";
    }

    protected void setTitle(String title) {
        if (this.getParent() instanceof CTabFolder) {
            CTabItem[] tabItems = ((CTabFolder)this.getParent()).getItems();
            tabItems[this.fIndex].setText(title);
        }
    }

    protected void setTabItemToolTipText(String text) {
        String newText = this.replaceMnemonicCharacters(text);
        if (this.getParent() instanceof CTabFolder) {
            CTabItem[] tabItems = ((CTabFolder)this.getParent()).getItems();
            tabItems[this.fIndex].setToolTipText("Memory View " + (this.fIndex + 1) + (newText.length() > 0 ? ": " + newText : ""));
        }
    }

    protected void refreshMemoryBlock() {
        if (this.getMemoryBlock() != null) {
            try {
                this.getMemoryBlock().refresh();
            }
            catch (DebugException e) {
                CDebugUIPlugin.errorDialog("Unable to refresh memory.", e.getStatus());
            }
        }
    }

    private void updateToolTipText() {
        this.setTabItemToolTipText(this.fAddressText.getText().trim());
    }

    private String replaceMnemonicCharacters(String text) {
        StringBuffer sb = new StringBuffer(text.length());
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            sb.append(ch);
            if (ch == '&') {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    protected void handleAddressModification() {
        this.fEvaluateButton.setEnabled(this.fAddressText.getText().trim().length() > 0);
    }

    protected void evaluateAddressExpression() {
        if (this.getMemoryManager() != null) {
            if (this.getMemoryBlock() == null) {
                String expression = this.fAddressText.getText().trim();
                try {
                    this.removeBlock();
                    if (expression.length() > 0) {
                        this.createBlock(expression);
                    }
                }
                catch (DebugException e) {
                    CDebugUIPlugin.errorDialog("Unable to get memory block.", e.getStatus());
                }
            }
            if (this.getMemoryBlock() != null) {
                this.fAddressText.setText(CDebugUIUtils.toHexAddressString(this.getMemoryBlock().getStartAddress()));
                this.handleAddressEnter();
            }
        }
    }

    public boolean canDoOperation(int operation) {
        switch (operation) {
            case 3: 
            case 4: {
                return this.fAddressText != null && this.fAddressText.isFocusControl() && this.fAddressText.isEnabled() && this.fAddressText.getSelectionCount() > 0;
            }
            case 5: 
            case 7: {
                return this.fAddressText != null && this.fAddressText.isFocusControl() && this.fAddressText.isEnabled();
            }
        }
        return false;
    }

    public void doOperation(int operation) {
        switch (operation) {
            case 3: {
                this.fAddressText.cut();
                break;
            }
            case 4: {
                this.fAddressText.copy();
                break;
            }
            case 5: {
                this.fAddressText.paste();
                break;
            }
            case 7: {
                this.fAddressText.selectAll();
            }
        }
    }

    protected MemoryView getMemoryView() {
        return this.fMemoryView;
    }
}

