/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.cview.FiltersContentProvider;
import org.eclipse.cdt.internal.ui.util.StringMatcher;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class CPatternFilter
extends ViewerFilter {
    private String[] patterns;
    private StringMatcher[] matchers;
    static String COMMA_SEPARATOR = ",";
    static String FILTERS_TAG = "CElementFilters";
    static /* synthetic */ Class class$0;

    private void initializeFromPreferences() {
        CUIPlugin plugin = CUIPlugin.getDefault();
        String storedPatterns = plugin.getPreferenceStore().getString(FILTERS_TAG);
        if (storedPatterns.length() == 0) {
            List defaultFilters = FiltersContentProvider.getDefaultFilters();
            String[] patterns = new String[defaultFilters.size()];
            defaultFilters.toArray(patterns);
            this.setPatterns(patterns);
            return;
        }
        List definedFilters = FiltersContentProvider.getDefinedFilters();
        StringTokenizer entries = new StringTokenizer(storedPatterns, COMMA_SEPARATOR);
        Vector<String> patterns = new Vector<String>();
        while (entries.hasMoreElements()) {
            String nextToken = entries.nextToken();
            if (definedFilters.indexOf(nextToken) <= -1) continue;
            patterns.addElement(nextToken);
        }
        String[] patternArray = new String[patterns.size()];
        patterns.toArray(patternArray);
        this.setPatterns(patternArray);
    }

    public String[] getPatterns() {
        if (this.patterns == null) {
            this.initializeFromPreferences();
        }
        return this.patterns;
    }

    public void setPatterns(String[] newPatterns) {
        this.patterns = newPatterns;
        this.matchers = new StringMatcher[newPatterns.length];
        int i = 0;
        while (i < newPatterns.length) {
            this.matchers[i] = new StringMatcher(newPatterns[i], true, false);
            ++i;
        }
    }

    private StringMatcher[] getMatchers() {
        if (this.matchers == null) {
            this.initializeFromPreferences();
        }
        return this.matchers;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)adaptable.getAdapter((Class)clazz);
        }
        if ((parentElement instanceof ICProject || parentElement instanceof ICContainer) && resource != null) {
            String name = resource.getName();
            StringMatcher[] testMatchers = this.getMatchers();
            int i = 0;
            while (i < testMatchers.length) {
                if (testMatchers[i].match(name)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

