/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractBinaryParserPage
extends AbstractCOptionPage {
    protected ICOptionPage fCurrentBinaryParserPage;
    protected Map fParserPageMap = null;
    protected Composite fCompositeParent;

    public AbstractBinaryParserPage() {
    }

    public AbstractBinaryParserPage(String title) {
        super(title);
    }

    public AbstractBinaryParserPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Composite getCompositeParent() {
        return this.fCompositeParent;
    }

    protected void setCompositeParent(Composite parent) {
        this.fCompositeParent = parent;
    }

    protected void setCurrentBinaryParserPage(ICOptionPage current) {
        this.fCurrentBinaryParserPage = current;
    }

    protected ICOptionPage getCurrentBinaryParserPage() {
        return this.fCurrentBinaryParserPage;
    }

    protected void handleBinaryParserChanged() {
        this.loadDynamicBinaryParserArea();
    }

    protected void loadDynamicBinaryParserArea() {
        Control[] children = this.getCompositeParent().getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        String parserID = this.getCurrentBinaryParserID();
        ICOptionPage page = this.getBinaryParserPage(parserID);
        if (page != null) {
            Composite parent = this.getCompositeParent();
            page.setContainer(this.getContainer());
            page.createControl(parent);
            page.getControl().setVisible(true);
            parent.layout(true);
        }
        this.setCurrentBinaryParserPage(page);
    }

    public void setContainer(ICOptionContainer container) {
        super.setContainer(container);
        this.initializeParserPageMap();
        ICOptionPage page = this.getCurrentBinaryParserPage();
        if (page != null) {
            page.setContainer(container);
        }
    }

    public ICOptionPage getBinaryParserPage(String parserID) {
        if (this.fParserPageMap == null) {
            this.initializeParserPageMap();
        }
        IConfigurationElement configElement = (IConfigurationElement)this.fParserPageMap.get(parserID);
        ICOptionPage page = null;
        if (configElement != null) {
            try {
                page = (ICOptionPage)configElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {}
        }
        return page;
    }

    protected void initializeParserPageMap() {
        this.fParserPageMap = new HashMap(5);
        IPluginDescriptor descriptor = CUIPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("BinaryParserPage");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            String id = infos[i].getAttribute("parserID");
            this.fParserPageMap.put(id, infos[i]);
            ++i;
        }
    }

    protected abstract String getCurrentBinaryParserID();

    public abstract void createControl(Composite var1);

    public void performApply(IProgressMonitor monitor) throws CoreException {
        ICOptionPage page = this.getCurrentBinaryParserPage();
        if (page != null) {
            page.performApply(monitor);
        }
    }

    public void performDefaults() {
        ICOptionPage page = this.getCurrentBinaryParserPage();
        if (page != null) {
            page.performDefaults();
        }
    }
}

