/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.core.model.ICastToArray;
import org.eclipse.cdt.debug.core.model.ICastToType;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CType;
import org.eclipse.cdt.debug.internal.core.model.CValue;
import org.eclipse.cdt.debug.internal.core.model.CValueFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public abstract class CVariable
extends CDebugElement
implements ICVariable,
ICDIEventListener,
ICastToType,
ICastToArray {
    private CDebugElement fParent;
    private InternalVariable fOriginal;
    private InternalVariable fShadow = null;
    protected ICValue fValue;
    private String fName = null;
    protected boolean fChanged = false;
    protected int fFormat = 0;
    private boolean fIsEnabled = true;
    private static IValue fDisabledValue = new IValue(){

        public String getReferenceTypeName() throws DebugException {
            return null;
        }

        public String getValueString() throws DebugException {
            return null;
        }

        public boolean isAllocated() throws DebugException {
            return false;
        }

        public IVariable[] getVariables() throws DebugException {
            return null;
        }

        public boolean hasVariables() throws DebugException {
            return false;
        }

        public String getModelIdentifier() {
            return CDebugCorePlugin.getUniqueIdentifier();
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public ILaunch getLaunch() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public CVariable(CDebugElement parent, ICDIVariableObject cdiVariableObject) {
        super((CDebugTarget)parent.getDebugTarget());
        this.fParent = parent;
        this.fIsEnabled = !this.enableVariableBookkeeping();
        this.fOriginal = this.createOriginal(cdiVariableObject);
        this.fShadow = null;
        if (cdiVariableObject instanceof ErrorVariable) {
            this.setStatus(2, MessageFormat.format("not available: {0}", ((ErrorVariable)cdiVariableObject).getException().getMessage()));
        }
        this.fFormat = CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    private InternalVariable createOriginal(ICDIVariableObject varObject) {
        return new InternalVariable(varObject);
    }

    public IValue getValue() throws DebugException {
        if (!this.isEnabled()) {
            return fDisabledValue;
        }
        if (this.fValue == null) {
            if (this.getType() != null && this.getType().isArray()) {
                ICDIVariable var = null;
                try {
                    var = this.getInternalVariable().getCDIVariable();
                }
                catch (CDIException e) {
                    this.requestFailed("", e);
                }
                int[] dims = this.getType().getArrayDimensions();
                if (dims.length > 0 && dims[0] > 0) {
                    this.fValue = CValueFactory.createArrayValue(this, var, 0, dims[0] - 1);
                }
            } else {
                ICDIValue cdiValue = this.getCurrentValue();
                if (cdiValue != null) {
                    this.fValue = CValueFactory.createValue(this, cdiValue);
                }
            }
        }
        return this.fValue;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.fChanged;
    }

    public void setValue(String expression) throws DebugException {
        this.notSupported("Variable does not support value modification.");
    }

    public void setValue(IValue value) throws DebugException {
        this.notSupported("Variable does not support value modification.");
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.cdt.debug.core.model.ICastToType;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.debug.core.model.IVariable;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Lorg.eclipse.cdt.debug.core.model.ICVariable;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz3)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected final ICDIValue getCurrentValue() throws DebugException {
        try {
            return this.retrieveValue();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
            return null;
        }
    }

    protected ICDIValue getLastKnownValue() {
        return this.fValue instanceof CValue ? ((CValue)this.fValue).getUnderlyingValue() : null;
    }

    protected void dispose() {
        if (this.fValue != null) {
            this.fValue.dispose();
        }
        this.getCDISession().getEventManager().removeEventListener(this);
        if (this.getShadow() != null) {
            this.getShadow().dispose();
        }
    }

    protected synchronized void setChanged(boolean changed) throws DebugException {
        if (this.getValue() != null && this.getValue() instanceof CValue) {
            this.fChanged = changed;
            ((CValue)this.getValue()).setChanged(changed);
        }
    }

    public void handleDebugEvent(ICDIEvent event) {
        ICDIObject source = event.getSource();
        if (source == null) {
            return;
        }
        if (source.getTarget().equals(this.getCDITarget())) {
            if (event instanceof ICDIChangedEvent) {
                if (source instanceof ICDIVariable && this.isSameVariable((ICDIVariable)source)) {
                    this.handleChangedEvent((ICDIChangedEvent)event);
                }
            } else if (event instanceof ICDIDestroyedEvent) {
                if (source instanceof ICDIVariable && this.isSameVariable((ICDIVariable)source)) {
                    this.handleDestroyedEvent((ICDIDestroyedEvent)event);
                }
            } else if (event instanceof ICDIResumedEvent) {
                this.handleResumedEvent((ICDIResumedEvent)event);
            }
        }
    }

    private void handleResumedEvent(ICDIResumedEvent event) {
        try {
            if (this.getCDIVariable() instanceof ErrorVariable) {
                this.getInternalVariable().invalidate();
                this.setStatus(0, null);
            }
        }
        catch (CDIException cDIException) {}
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
        try {
            this.setChanged(true);
            this.fireChangeEvent(256);
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
    }

    private void handleDestroyedEvent(ICDIDestroyedEvent event) {
        if (this.fOriginal != null) {
            this.fOriginal.invalidate();
        }
        if (this.getShadow() != null) {
            this.getShadow().invalidate();
        }
        this.invalidateValue();
    }

    protected CDebugElement getParent() {
        return this.fParent;
    }

    protected ICDIVariable getCDIVariable() throws CDIException {
        if (this.getShadow() != null) {
            return this.getShadow().getCDIVariable();
        }
        return this.getOriginalCDIVariable();
    }

    protected ICDIValue retrieveValue() throws DebugException, CDIException {
        return this.getParent().getDebugTarget().isSuspended() && this.getCDIVariable() != null ? this.getCDIVariable().getValue() : this.getLastKnownValue();
    }

    public String getName() throws DebugException {
        if (this.fName == null) {
            this.fName = this.fOriginal != null ? this.fOriginal.getCDIVariableObject().getName() : null;
        }
        return this.fName;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getType() != null ? this.getType().getName() : null;
    }

    protected void updateParentVariable(CValue parentValue) throws DebugException {
        parentValue.getParentVariable().setChanged(true);
        parentValue.getParentVariable().fireChangeEvent(256);
    }

    public int getFormat() {
        return this.fFormat;
    }

    public void setFormat(int format) throws DebugException {
        this.doSetFormat(format);
        this.reset();
    }

    protected void doSetFormat(int format) {
        this.fFormat = format;
    }

    protected void reset() throws DebugException {
        ((CValue)this.getValue()).reset();
        this.fireChangeEvent(256);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cast(String type) throws DebugException {
        try {
            try {
                InternalVariable newVar = this.createShadow(this.getOriginalCDIVariable().getStackFrame(), type);
                if (this.getShadow() != null) {
                    this.getShadow().dispose();
                }
                this.setShadow(newVar);
            }
            catch (CDIException e) {
                this.targetRequestFailed(e.getMessage(), null);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.invalidateValue();
            this.fireChangeEvent(256);
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.invalidateValue();
            this.fireChangeEvent(256);
            return;
        }
    }

    public String getCurrentType() {
        try {
            return this.getReferenceTypeName();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return "";
        }
    }

    public void restoreDefault() throws DebugException {
        InternalVariable oldVar = this.getShadow();
        this.setShadow(null);
        if (oldVar != null) {
            oldVar.dispose();
        }
        this.invalidateValue();
        this.fireChangeEvent(256);
    }

    public boolean supportsCasting() {
        CDebugTarget target;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("[Lorg.eclipse.cdt.debug.internal.core.model.CDebugTarget;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (target = (CDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null && this.isEditable();
    }

    protected ICDIVariable getOriginalCDIVariable() throws CDIException {
        return this.fOriginal != null ? this.fOriginal.getCDIVariable() : null;
    }

    private InternalVariable getShadow() {
        return this.fShadow;
    }

    private void setShadow(InternalVariable shadow) {
        this.fShadow = shadow;
    }

    private InternalVariable createShadow(ICDIStackFrame cdiFrame, String type) throws DebugException {
        try {
            return new InternalVariable(this.getCDISession().getVariableManager().getVariableObjectAsType(this.getOriginalCDIVariable(), type));
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
            return null;
        }
    }

    private InternalVariable createShadow(ICDIStackFrame cdiFrame, int start, int length) throws DebugException {
        try {
            return new InternalVariable(this.getCDISession().getVariableManager().getVariableObjectAsArray(this.getCDIVariable(), start, length));
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
            return null;
        }
    }

    public boolean isCasted() {
        return this.getShadow() != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void castToArray(int startIndex, int length) throws DebugException {
        try {
            try {
                InternalVariable newVar = this.createShadow(this.getOriginalCDIVariable().getStackFrame(), startIndex, length);
                if (this.getShadow() != null) {
                    this.getShadow().dispose();
                }
                this.setShadow(newVar);
            }
            catch (CDIException e) {
                this.targetRequestFailed(e.getMessage(), null);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.invalidateValue();
            this.fireChangeEvent(256);
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.invalidateValue();
            this.fireChangeEvent(256);
            return;
        }
    }

    public boolean supportsCastToArray() {
        CDebugTarget target;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("[Lorg.eclipse.cdt.debug.internal.core.model.CDebugTarget;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (target = (CDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null && this.isEditable() && this.hasChildren();
    }

    public boolean hasChildren() {
        if (!this.isEnabled()) {
            return false;
        }
        boolean result = false;
        try {
            InternalVariable var = this.getInternalVariable();
            if (var != null) {
                result = var.hasChildren();
            }
        }
        catch (CDIException e) {
            this.logError(e);
        }
        return result;
    }

    public boolean isEditable() {
        if (!this.isEnabled()) {
            return false;
        }
        boolean result = false;
        try {
            InternalVariable var = this.getInternalVariable();
            if (var != null) {
                result = var.isEditable();
            }
        }
        catch (CDIException e) {
            this.logError(e);
        }
        return result;
    }

    protected String getQualifiedName() throws DebugException {
        String result = null;
        try {
            result = this.getInternalVariable().getQualifiedName();
        }
        catch (CDIException e) {
            this.requestFailed("Qualified name is not available.", e);
        }
        return result;
    }

    public ICType getType() throws DebugException {
        ICType type = null;
        if (this.isEnabled()) {
            try {
                InternalVariable iv = this.getInternalVariable();
                if (iv != null) {
                    type = iv.getType();
                }
            }
            catch (CDIException e) {
                this.requestFailed("Type is not available.", e);
            }
        }
        return type;
    }

    public boolean isEnabled() {
        return this.canEnableDisable() ? this.fIsEnabled : true;
    }

    public void setEnabled(boolean enabled) throws DebugException {
        this.setEnabled0(enabled);
        this.fireChangeEvent(256);
    }

    private synchronized void setEnabled0(boolean enabled) {
        if (this.fOriginal != null) {
            this.fOriginal.invalidate();
        }
        if (this.getShadow() != null) {
            this.getShadow().invalidate();
        }
        this.fIsEnabled = enabled;
        this.invalidateValue();
    }

    private void invalidateValue() {
        if (this.fValue != null) {
            this.fValue.dispose();
            this.fValue = null;
        }
    }

    public boolean isArgument() {
        return this.fOriginal != null ? this.fOriginal.getCDIVariableObject() instanceof ICDIArgumentObject : false;
    }

    protected boolean sameVariableObject(ICDIVariableObject object) {
        return object != null && this.fOriginal != null ? object.equals(this.fOriginal.getCDIVariableObject()) : false;
    }

    private boolean enableVariableBookkeeping() {
        boolean result = false;
        try {
            result = this.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", false);
        }
        catch (CoreException coreException) {}
        return result;
    }

    public boolean canEnableDisable() {
        return this.getParent() instanceof CStackFrame;
    }

    protected boolean isSameVariable(ICDIVariable cdiVar) {
        return this.getShadow() != null && this.getShadow().isSameVariable(cdiVar) || this.fOriginal != null && this.fOriginal.isSameVariable(cdiVar);
    }

    private InternalVariable getInternalVariable() {
        return this.getShadow() != null ? this.getShadow() : this.fOriginal;
    }

    protected int sizeof() {
        return this.getInternalVariable().sizeof();
    }

    public static class ErrorVariable
    implements ICDIVariable {
        private ICDIVariableObject fVariableObject;
        private Exception fException;

        public ErrorVariable(ICDIVariableObject varObject, Exception e) {
            this.fVariableObject = varObject;
            this.fException = e;
        }

        public ICDIStackFrame getStackFrame() throws CDIException {
            return null;
        }

        public String getName() {
            return this.fVariableObject != null ? this.fVariableObject.getName() : "";
        }

        public String getTypeName() throws CDIException {
            return this.fVariableObject != null ? this.fVariableObject.getTypeName() : "";
        }

        public ICDIType getType() throws CDIException {
            return this.fVariableObject != null ? this.fVariableObject.getType() : null;
        }

        public ICDIValue getValue() throws CDIException {
            return null;
        }

        public boolean isEditable() throws CDIException {
            return false;
        }

        public void setValue(String expression) throws CDIException {
        }

        public void setValue(ICDIValue value) throws CDIException {
        }

        public void setFormat(int format) throws CDIException {
        }

        public ICDITarget getTarget() {
            return this.fVariableObject != null ? this.fVariableObject.getTarget() : null;
        }

        public Exception getException() {
            return this.fException;
        }

        public int sizeof() throws CDIException {
            return 0;
        }

        public String getQualifiedName() throws CDIException {
            return this.fVariableObject != null ? this.fVariableObject.getQualifiedName() : null;
        }

        public boolean equals(ICDIVariableObject varObject) {
            return this.fVariableObject != null ? this.fVariableObject.equals(varObject) : false;
        }
    }

    class InternalVariable {
        private ICDIVariableObject fCDIVariableObject;
        private ICDIVariable fCDIVariable;
        private Boolean fEditable = null;
        private ICType fType = null;
        private String fQualifiedName = null;

        public InternalVariable(ICDIVariableObject varObject) {
            this.setCDIVariableObject(varObject);
            this.setCDIVariable(varObject instanceof ICDIVariable ? (ICDIVariable)varObject : null);
        }

        protected synchronized ICDIVariable getCDIVariable() throws CDIException {
            if (this.fCDIVariable == null) {
                try {
                    if (this.getCDIVariableObject() instanceof ICDIArgumentObject) {
                        this.fCDIVariable = CVariable.this.getCDISession().getVariableManager().createArgument((ICDIArgumentObject)this.getCDIVariableObject());
                    } else if (this.getCDIVariableObject() instanceof ICDIVariableObject) {
                        this.fCDIVariable = CVariable.this.getCDISession().getVariableManager().createVariable(this.getCDIVariableObject());
                    }
                }
                catch (CDIException e) {
                    this.fCDIVariable = new ErrorVariable(this.getCDIVariableObject(), e);
                    CVariable.this.setStatus(2, MessageFormat.format("not available: {0}", e.getMessage()));
                }
            }
            return this.fCDIVariable;
        }

        protected ICDIVariableObject getCDIVariableObject() {
            return this.fCDIVariableObject;
        }

        protected ICType getType() throws CDIException {
            ICDIVariableObject varObject;
            if (this.fType == null && (varObject = this.getCDIVariableObject()) != null) {
                this.fType = new CType(varObject.getType());
            }
            return this.fType;
        }

        protected boolean isEditable() throws CDIException {
            ICDIVariableObject varObject;
            if (this.fEditable == null && (varObject = this.getCDIVariableObject()) != null && !(varObject instanceof ErrorVariable)) {
                this.fEditable = new Boolean(varObject.isEditable());
            }
            return this.fEditable != null ? this.fEditable : false;
        }

        protected boolean hasChildren() throws CDIException {
            CType type = (CType)this.getType();
            return type != null ? type.hasChildren() : false;
        }

        private void setCDIVariable(ICDIVariable variable) {
            this.fCDIVariable = variable;
        }

        private void setCDIVariableObject(ICDIVariableObject object) {
            this.fCDIVariableObject = object;
        }

        protected synchronized void invalidate() {
            try {
                if (this.fCDIVariable != null && !(this.fCDIVariable instanceof ErrorVariable)) {
                    CVariable.this.getCDISession().getVariableManager().destroyVariable(this.fCDIVariable);
                }
            }
            catch (CDIException e) {
                CVariable.this.logError(e.getMessage());
            }
            this.setCDIVariable(null);
            if (this.fType != null) {
                this.fType.dispose();
            }
            this.fType = null;
            this.fEditable = null;
        }

        protected void dispose() {
            this.invalidate();
            this.setCDIVariableObject(null);
        }

        protected boolean isSameVariable(ICDIVariable cdiVar) {
            return this.fCDIVariable != null ? this.fCDIVariable.equals(cdiVar) : false;
        }

        protected int sizeof() {
            if (this.getCDIVariableObject() != null) {
                try {
                    return this.getCDIVariableObject().sizeof();
                }
                catch (CDIException cDIException) {}
            }
            return 0;
        }

        protected String getQualifiedName() throws CDIException {
            if (this.fQualifiedName == null) {
                this.fQualifiedName = this.fCDIVariableObject != null ? this.fCDIVariableObject.getQualifiedName() : null;
            }
            return this.fQualifiedName;
        }
    }
}

