/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryException;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableElement;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifierOwner;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.Enumeration;
import org.eclipse.cdt.internal.core.model.Enumerator;
import org.eclipse.cdt.internal.core.model.Field;
import org.eclipse.cdt.internal.core.model.Function;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.internal.core.model.FunctionTemplate;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.cdt.internal.core.model.Include;
import org.eclipse.cdt.internal.core.model.Macro;
import org.eclipse.cdt.internal.core.model.Method;
import org.eclipse.cdt.internal.core.model.MethodDeclaration;
import org.eclipse.cdt.internal.core.model.MethodTemplate;
import org.eclipse.cdt.internal.core.model.Namespace;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.Structure;
import org.eclipse.cdt.internal.core.model.StructureTemplate;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.TypeDef;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.model.Variable;
import org.eclipse.cdt.internal.core.model.VariableDeclaration;
import org.eclipse.cdt.internal.core.model.VariableTemplate;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.cdt.internal.core.parser.util.ASTUtil;
import org.eclipse.core.resources.IProject;

public class CModelBuilder {
    private TranslationUnit translationUnit;
    private Map newElements;
    private IQuickParseCallback quickParseCallback;
    private IASTCompilationUnit compilationUnit;

    public CModelBuilder(TranslationUnit tu) {
        this.translationUnit = tu;
        this.newElements = new HashMap();
    }

    private IASTCompilationUnit parse(String code, boolean hasCppNature, boolean quick, boolean throwExceptionOnError) throws ParserException {
        ParserMode mode = quick ? ParserMode.QUICK_PARSE : ParserMode.COMPLETE_PARSE;
        this.quickParseCallback = ParserFactory.createQuickParseCallback();
        ParserLanguage language = hasCppNature ? ParserLanguage.CPP : ParserLanguage.C;
        IParser parser = null;
        try {
            parser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((Reader)new StringReader(code), (String)"code", (IScannerInfo)new ScannerInfo(), (ParserMode)mode, (ParserLanguage)language, (ISourceElementRequestor)this.quickParseCallback, (IParserLogService)ParserUtil.getParserLogService()), (ISourceElementRequestor)this.quickParseCallback, (ParserMode)mode, (ParserLanguage)language, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryException parserFactoryException) {
            throw new ParserException("Parser/Scanner construction failure.");
        }
        if (!parser.parse() && throwExceptionOnError) {
            throw new ParserException("Parse failure");
        }
        return this.quickParseCallback.getCompilationUnit();
    }

    private IASTCompilationUnit parse(String code, boolean hasCppNature) throws ParserException {
        return this.parse(code, hasCppNature, true, true);
    }

    public Map parse() throws Exception {
        IProject currentProject = null;
        boolean hasCppNature = true;
        if (this.translationUnit != null && this.translationUnit.getCProject() != null) {
            this.translationUnit.getCProject().getOptions(true);
            currentProject = this.translationUnit.getCProject().getProject();
        }
        if (currentProject != null) {
            hasCppNature = CoreModel.getDefault().hasCCNature(currentProject);
        }
        try {
            this.compilationUnit = this.parse(this.translationUnit.getBuffer().getContents(), hasCppNature);
        }
        catch (ParserException parserException) {
            Util.debugLog("Parse Exception in CModelBuilder", IDebugLogConstants.MODEL);
        }
        long startTime = System.currentTimeMillis();
        try {
            this.generateModelElements();
        }
        catch (NullPointerException nullPointerException) {
            Util.debugLog("NullPointer exception in CModelBuilder", IDebugLogConstants.MODEL);
        }
        Util.debugLog("CModel build: " + (System.currentTimeMillis() - startTime) + "ms", IDebugLogConstants.MODEL);
        return this.newElements;
    }

    private void generateModelElements() {
        Iterator i = this.quickParseCallback.iterateOffsetableElements();
        while (i.hasNext()) {
            IASTOffsetableElement offsetable = (IASTOffsetableElement)i.next();
            if (offsetable instanceof IASTInclusion) {
                this.createInclusion(this.translationUnit, (IASTInclusion)offsetable);
                continue;
            }
            if (offsetable instanceof IASTMacro) {
                this.createMacro(this.translationUnit, (IASTMacro)offsetable);
                continue;
            }
            if (!(offsetable instanceof IASTDeclaration)) continue;
            try {
                this.generateModelElements((Parent)this.translationUnit, (IASTDeclaration)offsetable);
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {}
        }
    }

    private void generateModelElements(Parent parent, IASTDeclaration declaration) throws ASTNotImplementedException {
        if (declaration instanceof IASTNamespaceDefinition) {
            this.generateModelElements(parent, (IASTNamespaceDefinition)declaration);
        }
        if (declaration instanceof IASTAbstractTypeSpecifierDeclaration) {
            this.generateModelElements(parent, (IASTAbstractTypeSpecifierDeclaration)declaration);
        }
        if (declaration instanceof IASTTemplateDeclaration) {
            this.generateModelElements(parent, (IASTTemplateDeclaration)declaration);
        }
        if (declaration instanceof IASTTypedefDeclaration) {
            this.generateModelElements(parent, (IASTTypedefDeclaration)declaration);
        }
        this.createSimpleElement(parent, declaration, false);
    }

    private void generateModelElements(Parent parent, IASTNamespaceDefinition declaration) throws ASTNotImplementedException {
        Namespace namespace = this.createNamespace(parent, declaration);
        Iterator nsDecls = declaration.getDeclarations();
        while (nsDecls.hasNext()) {
            IASTDeclaration subNsDeclaration = (IASTDeclaration)nsDecls.next();
            this.generateModelElements((Parent)namespace, subNsDeclaration);
        }
    }

    private void generateModelElements(Parent parent, IASTAbstractTypeSpecifierDeclaration abstractDeclaration) throws ASTNotImplementedException {
        this.createAbstractElement(parent, (IASTTypeSpecifierOwner)abstractDeclaration, false);
    }

    private void generateModelElements(Parent parent, IASTTemplateDeclaration templateDeclaration) throws ASTNotImplementedException {
        String[] parameterTypes;
        IASTAbstractTypeSpecifierDeclaration abstractDeclaration;
        CElement element;
        IASTDeclaration declaration = templateDeclaration.getOwnedDeclaration();
        if (declaration instanceof IASTAbstractTypeSpecifierDeclaration && (element = this.createAbstractElement(parent, (IASTTypeSpecifierOwner)(abstractDeclaration = (IASTAbstractTypeSpecifierDeclaration)declaration), true)) != null) {
            element.setPos(templateDeclaration.getStartingOffset(), templateDeclaration.getEndingOffset() - templateDeclaration.getStartingOffset());
            parameterTypes = ASTUtil.getTemplateParameters((IASTTemplateDeclaration)templateDeclaration);
            ITemplate classTemplate = (ITemplate)((Object)element);
            classTemplate.setTemplateParameterTypes(parameterTypes);
        }
        ITemplate template = null;
        template = (ITemplate)((Object)this.createSimpleElement(parent, declaration, true));
        if (template != null) {
            element = (CElement)((Object)template);
            element.setPos(templateDeclaration.getStartingOffset(), templateDeclaration.getEndingOffset() - templateDeclaration.getStartingOffset());
            parameterTypes = ASTUtil.getTemplateParameters((IASTTemplateDeclaration)templateDeclaration);
            template.setTemplateParameterTypes(parameterTypes);
        }
    }

    private void generateModelElements(Parent parent, IASTTypedefDeclaration declaration) throws ASTNotImplementedException {
        this.createTypeDef(parent, declaration);
        IASTAbstractDeclaration abstractDeclaration = declaration.getAbstractDeclarator();
        this.createAbstractElement(parent, (IASTTypeSpecifierOwner)abstractDeclaration, false);
    }

    private CElement createAbstractElement(Parent parent, IASTTypeSpecifierOwner abstractDeclaration, boolean isTemplate) throws ASTNotImplementedException {
        CElement element = null;
        if (abstractDeclaration != null) {
            IASTTypeSpecifier typeSpec = abstractDeclaration.getTypeSpecifier();
            if (typeSpec instanceof IASTEnumerationSpecifier) {
                IASTEnumerationSpecifier enumSpecifier = (IASTEnumerationSpecifier)typeSpec;
                Enumeration enumElement = this.createEnumeration(parent, enumSpecifier);
                element = enumElement;
            } else if (typeSpec instanceof IASTClassSpecifier) {
                IASTClassSpecifier classSpecifier = (IASTClassSpecifier)typeSpec;
                Structure classElement = this.createClass(parent, classSpecifier, isTemplate);
                element = classElement;
                Iterator j = classSpecifier.getDeclarations();
                while (j.hasNext()) {
                    IASTDeclaration subDeclaration = (IASTDeclaration)j.next();
                    this.generateModelElements((Parent)classElement, subDeclaration);
                }
            } else {
                boolean cfr_ignored_0 = typeSpec instanceof IASTElaboratedTypeSpecifier;
            }
        }
        return element;
    }

    private CElement createSimpleElement(Parent parent, IASTDeclaration declaration, boolean isTemplate) throws ASTNotImplementedException {
        SourceManipulation element = null;
        if (declaration instanceof IASTVariable) {
            element = this.createVariableSpecification(parent, (IASTVariable)declaration, isTemplate);
        } else if (declaration instanceof IASTFunction) {
            element = this.createFunctionSpecification(parent, (IASTFunction)declaration, isTemplate);
        }
        return element;
    }

    private Include createInclusion(Parent parent, IASTInclusion inclusion) {
        Include element = new Include((ICElement)parent, inclusion.getName(), !inclusion.isLocal());
        element.setFullPathName(inclusion.getFullFileName());
        parent.addChild(element);
        element.setIdPos(inclusion.getNameOffset(), inclusion.getNameEndOffset() - inclusion.getNameOffset());
        element.setPos(inclusion.getStartingOffset(), inclusion.getEndingOffset() - inclusion.getStartingOffset());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private Macro createMacro(Parent parent, IASTMacro macro) {
        Macro element = new Macro(parent, macro.getName());
        parent.addChild(element);
        element.setIdPos(macro.getNameOffset(), macro.getNameEndOffset() - macro.getNameOffset());
        element.setPos(macro.getStartingOffset(), macro.getEndingOffset() - macro.getStartingOffset());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private Namespace createNamespace(Parent parent, IASTNamespaceDefinition nsDef) {
        String type = "namespace";
        String nsName = nsDef.getName() == null ? "" : nsDef.getName().toString();
        Namespace element = new Namespace(parent, nsName);
        parent.addChild(element);
        element.setIdPos(nsDef.getNameOffset(), nsName.length() == 0 ? type.length() : nsDef.getNameEndOffset() - nsDef.getNameOffset());
        element.setPos(nsDef.getStartingOffset(), nsDef.getEndingOffset() - nsDef.getStartingOffset());
        element.setTypeName(type);
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private Enumeration createEnumeration(Parent parent, IASTEnumerationSpecifier enumSpecifier) {
        String type = "enum";
        String enumName = enumSpecifier.getName() == null ? "" : enumSpecifier.getName().toString();
        Enumeration element = new Enumeration(parent, enumName);
        parent.addChild(element);
        Iterator i = enumSpecifier.getEnumerators();
        while (i.hasNext()) {
            IASTEnumerator enumDef = (IASTEnumerator)i.next();
            this.createEnumerator(element, enumDef);
        }
        element.setIdPos(enumSpecifier.getNameOffset(), enumName.length() == 0 ? type.length() : enumSpecifier.getNameEndOffset() - enumSpecifier.getNameOffset());
        element.setPos(enumSpecifier.getStartingOffset(), enumSpecifier.getEndingOffset() - enumSpecifier.getStartingOffset());
        element.setTypeName(type);
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private Enumerator createEnumerator(Parent parent, IASTEnumerator enumDef) {
        Enumerator element = new Enumerator(parent, enumDef.getName().toString());
        parent.addChild(element);
        element.setIdPos(enumDef.getStartingOffset(), enumDef.getNameEndOffset() - enumDef.getNameOffset());
        element.setPos(enumDef.getStartingOffset(), enumDef.getEndingOffset() - enumDef.getStartingOffset());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private Structure createClass(Parent parent, IASTClassSpecifier classSpecifier, boolean isTemplate) {
        Structure element;
        String className = "";
        String type = "";
        int kind = 64;
        ASTClassKind classkind = classSpecifier.getClassKind();
        if (classkind == ASTClassKind.CLASS) {
            kind = !isTemplate ? 64 : 73;
            type = "class";
            String string = className = classSpecifier.getName() == null ? "" : classSpecifier.getName().toString();
        }
        if (classkind == ASTClassKind.STRUCT) {
            kind = !isTemplate ? 65 : 82;
            type = "struct";
            String string = className = classSpecifier.getName() == null ? "" : classSpecifier.getName().toString();
        }
        if (classkind == ASTClassKind.UNION) {
            kind = !isTemplate ? 66 : 83;
            type = "union";
            String string = className = classSpecifier.getName() == null ? "" : classSpecifier.getName().toString();
        }
        if (!isTemplate) {
            Structure classElement;
            element = classElement = new Structure((ICElement)parent, kind, className);
        } else {
            StructureTemplate classTemplate = new StructureTemplate((ICElement)parent, kind, className);
            element = classTemplate;
        }
        Iterator baseClauses = classSpecifier.getBaseClauses();
        while (baseClauses.hasNext()) {
            IASTBaseSpecifier baseSpec = (IASTBaseSpecifier)baseClauses.next();
            element.addSuperClass(baseSpec.getParentClassName(), baseSpec.getAccess());
        }
        parent.addChild(element);
        element.setIdPos(classSpecifier.getNameOffset(), className.length() == 0 ? type.length() : classSpecifier.getNameEndOffset() - classSpecifier.getNameOffset());
        element.setTypeName(type);
        if (!isTemplate) {
            element.setPos(classSpecifier.getStartingOffset(), classSpecifier.getEndingOffset() - classSpecifier.getStartingOffset());
        }
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private TypeDef createTypeDef(Parent parent, IASTTypedefDeclaration typeDefDeclaration) {
        String name = typeDefDeclaration.getName();
        TypeDef element = new TypeDef(parent, name);
        StringBuffer typeName = new StringBuffer(ASTUtil.getType((IASTAbstractDeclaration)typeDefDeclaration.getAbstractDeclarator()));
        element.setTypeName(typeName.toString());
        parent.addChild(element);
        element.setIdPos(typeDefDeclaration.getNameOffset(), typeDefDeclaration.getNameEndOffset() - typeDefDeclaration.getNameOffset());
        element.setPos(typeDefDeclaration.getStartingOffset(), typeDefDeclaration.getEndingOffset() - typeDefDeclaration.getStartingOffset());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private VariableDeclaration createVariableSpecification(Parent parent, IASTVariable varDeclaration, boolean isTemplate) throws ASTNotImplementedException {
        String variableName = varDeclaration.getName();
        if (variableName == null || variableName.length() <= 0) {
            return null;
        }
        IASTAbstractDeclaration abstractDeclaration = varDeclaration.getAbstractDeclaration();
        this.createAbstractElement(parent, (IASTTypeSpecifierOwner)abstractDeclaration, isTemplate);
        VariableDeclaration element = null;
        if (varDeclaration instanceof IASTField) {
            IASTField fieldDeclaration = (IASTField)varDeclaration;
            Field newElement = new Field(parent, variableName);
            newElement.setMutable(fieldDeclaration.isMutable());
            newElement.setVisibility(fieldDeclaration.getVisiblity());
            element = newElement;
        } else if (isTemplate) {
            VariableTemplate newElement = new VariableTemplate(parent, variableName);
            element = newElement;
        } else if (varDeclaration.isExtern()) {
            VariableDeclaration newElement;
            element = newElement = new VariableDeclaration(parent, variableName);
        } else {
            Variable newElement = new Variable(parent, variableName);
            element = newElement;
        }
        element.setTypeName(ASTUtil.getType((IASTAbstractDeclaration)varDeclaration.getAbstractDeclaration()));
        element.setConst(varDeclaration.getAbstractDeclaration().isConst());
        element.setVolatile(varDeclaration.getAbstractDeclaration().isVolatile());
        element.setStatic(varDeclaration.isStatic());
        parent.addChild(element);
        element.setIdPos(varDeclaration.getNameOffset(), varDeclaration.getNameEndOffset() - varDeclaration.getNameOffset());
        if (!isTemplate) {
            element.setPos(varDeclaration.getStartingOffset(), varDeclaration.getEndingOffset() - varDeclaration.getStartingOffset());
        }
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private FunctionDeclaration createFunctionSpecification(Parent parent, IASTFunction functionDeclaration, boolean isTemplate) {
        String name = functionDeclaration.getName();
        if (name == null || name.length() <= 0) {
            return null;
        }
        String[] parameterTypes = ASTUtil.getFunctionParameterTypes((IASTFunction)functionDeclaration);
        FunctionDeclaration element = null;
        if (functionDeclaration instanceof IASTMethod) {
            IASTMethod methodDeclaration = (IASTMethod)functionDeclaration;
            MethodDeclaration methodElement = null;
            if (methodDeclaration.hasFunctionBody()) {
                if (!isTemplate) {
                    Method newElement = new Method(parent, name);
                    methodElement = newElement;
                } else {
                    MethodTemplate newElement = new MethodTemplate(parent, name);
                    methodElement = newElement;
                }
            } else if (!isTemplate) {
                MethodDeclaration newElement;
                methodElement = newElement = new MethodDeclaration(parent, name);
            } else {
                MethodTemplate newElement = new MethodTemplate(parent, name);
                methodElement = newElement;
            }
            methodElement.setParameterTypes(parameterTypes);
            methodElement.setReturnType(ASTUtil.getType((IASTAbstractDeclaration)functionDeclaration.getReturnType()));
            methodElement.setStatic(functionDeclaration.isStatic());
            methodElement.setVisibility(methodDeclaration.getVisiblity());
            methodElement.setVolatile(methodDeclaration.isVolatile());
            methodElement.setConst(methodDeclaration.isConst());
            methodElement.setVirtual(methodDeclaration.isVirtual());
            methodElement.setPureVirtual(methodDeclaration.isPureVirtual());
            methodElement.setInline(methodDeclaration.isInline());
            methodElement.setFriend(methodDeclaration.isFriend());
            methodElement.setConstructor(methodDeclaration.isConstructor());
            methodElement.setDestructor(methodDeclaration.isDestructor());
            element = methodElement;
        } else {
            FunctionDeclaration functionElement = null;
            if (functionDeclaration.hasFunctionBody()) {
                if (!isTemplate) {
                    Function newElement = new Function(parent, name);
                    functionElement = newElement;
                } else {
                    FunctionTemplate newElement = new FunctionTemplate(parent, name);
                    functionElement = newElement;
                }
            } else if (!isTemplate) {
                FunctionDeclaration newElement;
                functionElement = newElement = new FunctionDeclaration(parent, name);
            } else {
                FunctionTemplate newElement = new FunctionTemplate(parent, name);
                functionElement = newElement;
            }
            functionElement.setParameterTypes(parameterTypes);
            functionElement.setReturnType(ASTUtil.getType((IASTAbstractDeclaration)functionDeclaration.getReturnType()));
            functionElement.setStatic(functionDeclaration.isStatic());
            element = functionElement;
        }
        parent.addChild(element);
        element.setIdPos(functionDeclaration.getNameOffset(), functionDeclaration.getNameEndOffset() - functionDeclaration.getNameOffset());
        if (!isTemplate) {
            element.setPos(functionDeclaration.getStartingOffset(), functionDeclaration.getEndingOffset() - functionDeclaration.getStartingOffset());
        }
        this.newElements.put(element, element.getElementInfo());
        return element;
    }
}

