/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICPathEntry;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SetCPathEntriesOperation
extends CModelOperation {
    ICPathEntry[] oldEntries;
    ICPathEntry[] newEntries;
    CProject project;

    public SetCPathEntriesOperation(CProject project, ICPathEntry[] oldEntries, ICPathEntry[] newEntries) {
        this.oldEntries = oldEntries;
        this.newEntries = newEntries;
        this.project = project;
    }

    protected void executeOperation() throws CModelException {
        this.updateProjectReferencesIfNecessary();
        try {
            ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.project.getProject());
            Element rootElement = descriptor.getProjectData(CProject.PATH_ENTRY_ID);
            Node child = rootElement.getFirstChild();
            while (child != null) {
                rootElement.removeChild(child);
                child = rootElement.getFirstChild();
            }
            if (this.newEntries != null && this.newEntries.length > 0) {
                Document doc = rootElement.getOwnerDocument();
                this.project.encodeCPathEntries(doc, rootElement, this.newEntries);
                descriptor.saveProjectData();
            }
            this.generateCPathEntryDeltas();
            this.done();
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    protected void updateProjectReferencesIfNecessary() throws CModelException {
        String[] oldRequired = this.project.projectPrerequisites(this.oldEntries);
        String[] newRequired = this.project.projectPrerequisites(this.newEntries);
        try {
            int newSize;
            HashSet newReferences;
            IProjectDescription description;
            IProject projectResource;
            block10: {
                String projectName;
                projectResource = this.project.getProject();
                description = projectResource.getDescription();
                IProject[] projectReferences = description.getReferencedProjects();
                HashSet<String> oldReferences = new HashSet<String>(projectReferences.length);
                int i = 0;
                while (i < projectReferences.length) {
                    String projectName2 = projectReferences[i].getName();
                    oldReferences.add(projectName2);
                    ++i;
                }
                newReferences = (HashSet)oldReferences.clone();
                int i2 = 0;
                while (i2 < oldRequired.length) {
                    projectName = oldRequired[i2];
                    newReferences.remove(projectName);
                    ++i2;
                }
                i2 = 0;
                while (i2 < newRequired.length) {
                    projectName = newRequired[i2];
                    newReferences.add(projectName);
                    ++i2;
                }
                newSize = newReferences.size();
                if (oldReferences.size() == newSize) {
                    Iterator iter = newReferences.iterator();
                    while (iter.hasNext()) {
                        if (oldReferences.contains(iter.next())) {
                            continue;
                        }
                        break block10;
                    }
                    return;
                }
            }
            Object[] requiredProjectNames = new String[newSize];
            int index = 0;
            Iterator iter = newReferences.iterator();
            while (iter.hasNext()) {
                requiredProjectNames[index++] = (String)iter.next();
            }
            Arrays.sort(requiredProjectNames);
            IProject[] requiredProjectArray = new IProject[newSize];
            IWorkspaceRoot wksRoot = projectResource.getWorkspace().getRoot();
            int i = 0;
            while (i < newSize) {
                requiredProjectArray[i] = wksRoot.getProject((String)requiredProjectNames[i]);
                ++i;
            }
            description.setReferencedProjects(requiredProjectArray);
            projectResource.setDescription(description, this.fMonitor);
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    private void generateCPathEntryDeltas() {
        int j;
        boolean found;
        CModelManager.getDefault();
        CElementDelta delta = new CElementDelta(this.getCModel());
        int i = 0;
        while (i < this.oldEntries.length) {
            found = false;
            j = 0;
            while (j < this.newEntries.length) {
                if (this.oldEntries[i].equals(this.newEntries[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.addCPathEntryDeltas(this.oldEntries[i], 128, delta);
            }
            ++i;
        }
        i = 0;
        while (i < this.newEntries.length) {
            found = false;
            j = 0;
            while (j < this.oldEntries.length) {
                if (this.newEntries[i].equals(this.oldEntries[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.addCPathEntryDeltas(this.newEntries[i], 64, delta);
            }
            ++i;
        }
    }

    protected void addCPathEntryDeltas(ICPathEntry entry, int flag, CElementDelta delta) {
        int kind = entry.getEntryKind();
        ICElement celement = null;
        if (kind == 3) {
            ISourceEntry source = (ISourceEntry)entry;
            IPath path = source.getSourcePath();
            celement = CoreModel.getDefault().create(path);
        } else if (kind == 1) {
            celement = this.project;
        } else if (kind == 2) {
            celement = this.project;
        } else if (kind == 5) {
            IIncludeEntry include = (IIncludeEntry)entry;
            IPath path = include.getResourcePath();
            celement = CoreModel.getDefault().create(path);
        } else if (kind == 7) {
            IMacroEntry macro = (IMacroEntry)entry;
            IPath path = macro.getResourcePath();
            celement = CoreModel.getDefault().create(path);
        } else if (kind == 6) {
            IContainerEntry cfr_ignored_0 = (IContainerEntry)entry;
            celement = this.project;
        }
        if (celement != null) {
            delta.changed(celement, flag);
        }
    }
}

