/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.eclipse.cdt.utils.spawner.SpawnerInputStream;
import org.eclipse.cdt.utils.spawner.SpawnerOutputStream;

public class Spawner
extends Process {
    public int NOOP = 0;
    public int HUP = 1;
    public int INT = 2;
    public int KILL = 9;
    public int TERM = 15;
    int pid = 0;
    int status;
    int[] channels = new int[3];
    boolean isDone;
    OutputStream out;
    InputStream in;
    InputStream err;

    static {
        System.loadLibrary("spawner");
    }

    public Spawner(String command, boolean bNoRedirect) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(command);
        String[] cmdarray = new String[tokenizer.countTokens()];
        int n = 0;
        while (tokenizer.hasMoreTokens()) {
            cmdarray[n] = tokenizer.nextToken();
            ++n;
        }
        if (bNoRedirect) {
            this.exec_detached(cmdarray, new String[0], ".");
        } else {
            this.exec(cmdarray, new String[0], ".");
        }
    }

    protected Spawner(String[] cmdarray, String[] envp, File dir) throws IOException {
        String dirpath = ".";
        if (dir != null) {
            dirpath = dir.getAbsolutePath();
        }
        this.exec(cmdarray, envp, dirpath);
    }

    protected Spawner(String command) throws IOException {
        this(command, null);
    }

    protected Spawner(String[] cmdarray) throws IOException {
        this(cmdarray, null);
    }

    protected Spawner(String[] cmdarray, String[] envp) throws IOException {
        this(cmdarray, envp, null);
    }

    protected Spawner(String cmd, String[] envp) throws IOException {
        this(cmd, envp, null);
    }

    protected Spawner(String command, String[] envp, File dir) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(command);
        String[] cmdarray = new String[tokenizer.countTokens()];
        int n = 0;
        while (tokenizer.hasMoreTokens()) {
            cmdarray[n] = tokenizer.nextToken();
            ++n;
        }
        String dirpath = ".";
        if (dir != null) {
            dirpath = dir.getAbsolutePath();
        }
        this.exec(cmdarray, envp, dirpath);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getErrorStream() {
        return this.err;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (!this.isDone) {
            this.wait();
        }
        try {
            ((SpawnerInputStream)this.getErrorStream()).close();
            ((SpawnerInputStream)this.getInputStream()).close();
            ((SpawnerOutputStream)this.getOutputStream()).close();
        }
        catch (IOException iOException) {}
        return this.status;
    }

    public synchronized int exitValue() {
        if (!this.isDone) {
            throw new IllegalThreadStateException("Process not Terminated");
        }
        return this.status;
    }

    public synchronized void destroy() {
        this.terminate();
        try {
            ((SpawnerInputStream)this.getErrorStream()).close();
            ((SpawnerInputStream)this.getInputStream()).close();
            ((SpawnerOutputStream)this.getOutputStream()).close();
        }
        catch (IOException iOException) {}
        if (!this.isDone) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.isDone) {
            this.kill();
        }
    }

    public int interrupt() {
        return this.raise(this.pid, this.INT);
    }

    public int hangup() {
        return this.raise(this.pid, this.HUP);
    }

    public int kill() {
        return this.raise(this.pid, this.KILL);
    }

    public int terminate() {
        return this.raise(this.pid, this.TERM);
    }

    public boolean isRunning() {
        return this.raise(this.pid, this.NOOP) == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exec(String[] cmdarray, String[] envp, String dirpath) throws IOException {
        String command = cmdarray[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(command);
        }
        if (envp == null) {
            envp = new String[]{};
        }
        Reaper reaper = new Reaper(cmdarray, envp, dirpath);
        reaper.setDaemon(true);
        reaper.start();
        Spawner spawner = this;
        synchronized (spawner) {
            while (this.pid == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.pid == -1) {
            throw new IOException("Exec error:" + reaper.getErrorMessage());
        }
        this.in = new SpawnerInputStream(this.channels[1]);
        this.err = new SpawnerInputStream(this.channels[2]);
        this.out = new SpawnerOutputStream(this.channels[0]);
    }

    public void exec_detached(String[] cmdarray, String[] envp, String dirpath) throws IOException {
        String command = cmdarray[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(command);
        }
        if (envp == null) {
            envp = new String[]{};
        }
        this.pid = this.exec1(cmdarray, envp, dirpath);
        if (this.pid == -1) {
            throw new IOException("Exec error");
        }
    }

    native int exec0(String[] var1, String[] var2, String var3, int[] var4) throws IOException;

    native int exec1(String[] var1, String[] var2, String var3) throws IOException;

    public native int raise(int var1, int var2);

    native int waitFor(int var1);

    class Reaper
    extends Thread {
        String[] cmdarray;
        String[] envp;
        String dirpath;
        String errMesg;

        public Reaper(String[] array, String[] env, String dir) {
            super("Spawner Reaper");
            this.cmdarray = array;
            this.envp = env;
            this.dirpath = dir;
            this.errMesg = new String("Cannot run " + this.cmdarray[0]);
        }

        public void run() {
            try {
                Spawner.this.pid = Spawner.this.exec0(this.cmdarray, this.envp, this.dirpath, Spawner.this.channels);
            }
            catch (IOException e) {
                Spawner.this.pid = -1;
                this.errMesg = e.getMessage();
            }
            Spawner spawner = Spawner.this;
            synchronized (spawner) {
                Spawner.this.notifyAll();
            }
            if (Spawner.this.pid != -1) {
                Spawner.this.status = Spawner.this.waitFor(Spawner.this.pid);
                spawner = Spawner.this;
                synchronized (spawner) {
                    Spawner.this.isDone = true;
                    Spawner.this.notifyAll();
                }
            }
        }

        public String getErrorMessage() {
            return this.errMesg;
        }
    }
}

