/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.internal.ui.editor.IMakefileDocumentProvider;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefilePartitionScanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class MakefileDocumentProvider
extends FileDocumentProvider
implements IMakefileDocumentProvider {
    private static MakefilePartitionScanner scanner = null;

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            IDocumentPartitioner partitioner = this.createPartitioner();
            partitioner.connect(document);
            document.setDocumentPartitioner(partitioner);
        }
        return document;
    }

    private IDocumentPartitioner createPartitioner() {
        return new DefaultPartitioner((IPartitionTokenScanner)this.getPartitionScanner(), MakefilePartitionScanner.TYPES);
    }

    private MakefilePartitionScanner getPartitionScanner() {
        if (scanner == null) {
            scanner = new MakefilePartitionScanner();
        }
        return scanner;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            IMakefile makefile = this.createMakefile(input.getFile());
            if (makefile == null) {
                return super.createElementInfo(element);
            }
            try {
                this.refreshFile(input.getFile());
            }
            catch (CoreException x) {
                this.handleCoreException(x, "FileDocumentProvider.createElementInfo");
            }
            IDocument d = null;
            IStatus s = null;
            try {
                d = this.createDocument(element);
            }
            catch (CoreException x) {
                s = x.getStatus();
                d = this.createEmptyDocument();
            }
            IAnnotationModel m = this.createAnnotationModel(element);
            FileDocumentProvider.FileSynchronizer f = new FileDocumentProvider.FileSynchronizer((FileDocumentProvider)this, input);
            f.install();
            MakefileInfo info = new MakefileInfo(d, m, f, makefile);
            info.fModificationStamp = this.computeModificationStamp((IResource)input.getFile());
            ((AbstractDocumentProvider.ElementInfo)info).fStatus = s;
            ((StorageDocumentProvider.StorageInfo)info).fEncoding = this.getPersistedEncoding(input);
            return info;
        }
        return super.createElementInfo(element);
    }

    private IMakefile createMakefile(IFile file) {
        return MakeCorePlugin.getDefault().createMakefile(file);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo instanceof MakefileInfo) {
            MakefileInfo info = (MakefileInfo)elementInfo;
            String content = document.get();
            StringReader reader = new StringReader(content);
            try {
                info.fCopy.parse((Reader)reader);
            }
            catch (IOException iOException) {}
        }
        super.doSaveDocument(monitor, element, document, overwrite);
    }

    public void shutdown() {
        Iterator e = this.getConnectedElements();
        while (e.hasNext()) {
            this.disconnect(e.next());
        }
    }

    public IMakefile getWorkingCopy(Object element) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo instanceof MakefileInfo) {
            MakefileInfo info = (MakefileInfo)elementInfo;
            return info.fCopy;
        }
        return null;
    }

    protected class MakefileInfo
    extends FileDocumentProvider.FileInfo {
        IMakefile fCopy;

        public MakefileInfo(IDocument document, IAnnotationModel model, FileDocumentProvider.FileSynchronizer fileSynchronizer, IMakefile copy) {
            super((FileDocumentProvider)MakefileDocumentProvider.this, document, model, fileSynchronizer);
            this.fCopy = copy;
        }

        public void setModificationStamp(long timeStamp) {
            this.fModificationStamp = timeStamp;
        }
    }
}

