/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.internal.core.parser.IScannerContext;

public class ScannerContext
implements IScannerContext {
    private Reader reader;
    private String filename;
    private int macroOffset = -1;
    private int macroLength = -1;
    private int line = 1;
    private int offset;
    private Stack undo = new Stack();
    private int kind;
    private IASTInclusion inc = null;

    public IScannerContext initialize(Reader r, String f, int k, IASTInclusion i, int mO, int mL, int l) {
        this.reader = r;
        this.filename = f;
        this.offset = 0;
        this.kind = k;
        this.inc = i;
        this.macroOffset = mO;
        this.macroLength = mL;
        this.line = l;
        return this;
    }

    public IScannerContext initialize(Reader r, String f, int k, IASTInclusion i) {
        return this.initialize(r, f, k, i, -1, -1, 1);
    }

    public int read() throws IOException {
        ++this.offset;
        int c = this.reader.read();
        if ((char)c == '\n') {
            ++this.line;
        }
        return c;
    }

    public final String getFilename() {
        return this.filename;
    }

    public final int getMacroOffset() {
        return this.macroOffset;
    }

    public final int getMacroLength() {
        return this.macroLength;
    }

    public final int getOffset() {
        return this.macroOffset < 0 ? this.offset : this.macroOffset;
    }

    public final int getRelativeOffset() {
        return this.offset;
    }

    public final int getLine() {
        return this.line;
    }

    public final Reader getReader() {
        return this.reader;
    }

    public final int undoStackSize() {
        return this.undo.size();
    }

    public final int popUndo() {
        int c = (Integer)this.undo.pop();
        if ((char)c == '\n') {
            ++this.line;
        }
        return c;
    }

    public void pushUndo(int undo) {
        if ((char)undo == '\n') {
            --this.line;
        }
        this.undo.push(new Integer(undo));
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public IASTInclusion getExtension() {
        return this.inc;
    }

    public void setExtension(IASTInclusion ext) {
        this.inc = ext;
    }
}

