/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.TemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class BasicSymbol
implements Cloneable,
ISymbol {
    private final ParserSymbolTable _table;
    private String _name;
    private ISymbolASTExtension _object;
    private TypeInfo _typeInfo;
    private IContainerSymbol _containingScope;
    private int _depth;
    private boolean _isTemplateMember = false;
    private TemplateInstance _templateInstance;

    public BasicSymbol(ParserSymbolTable table, String name) {
        this._table = table;
        this._name = name;
        this._typeInfo = new TypeInfo();
    }

    public BasicSymbol(ParserSymbolTable table, String name, ISymbolASTExtension obj) {
        this._table = table;
        this._name = name;
        this._object = obj;
        this._typeInfo = new TypeInfo();
    }

    public BasicSymbol(ParserSymbolTable table, String name, TypeInfo.eType typeInfo) {
        this._table = table;
        this._name = name;
        this._typeInfo = new TypeInfo(typeInfo, 0, null);
    }

    public ParserSymbolTable getSymbolTable() {
        return this._table;
    }

    public Object clone() {
        BasicSymbol copy = null;
        try {
            copy = (BasicSymbol)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        copy._object = null;
        return copy;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public ISymbolASTExtension getASTExtension() {
        return this._object;
    }

    public void setASTExtension(ISymbolASTExtension obj) {
        this._object = obj;
    }

    public IContainerSymbol getContainingSymbol() {
        return this._containingScope;
    }

    public void setContainingSymbol(IContainerSymbol scope) {
        this._containingScope = scope;
        this._depth = scope.getDepth() + 1;
    }

    public void setType(TypeInfo.eType t) {
        this.getTypeInfo().setType(t);
    }

    public TypeInfo.eType getType() {
        return this.getTypeInfo().getType();
    }

    public boolean isType(TypeInfo.eType type) {
        return this.getTypeInfo().isType(type, TypeInfo.t_undef);
    }

    public boolean isType(TypeInfo.eType type, TypeInfo.eType upperType) {
        return this.getTypeInfo().isType(type, upperType);
    }

    public ISymbol getTypeSymbol() {
        ISymbol symbol = this.getTypeInfo().getTypeSymbol();
        if (symbol != null && symbol.getTypeInfo().isForwardDeclaration() && symbol.getTypeSymbol() != null) {
            return symbol.getTypeSymbol();
        }
        return symbol;
    }

    public void setTypeSymbol(ISymbol type) {
        this.getTypeInfo().setTypeSymbol(type);
    }

    public TypeInfo getTypeInfo() {
        return this._typeInfo;
    }

    public void setTypeInfo(TypeInfo info) {
        this._typeInfo = info;
    }

    public boolean isForwardDeclaration() {
        return this.getTypeInfo().isForwardDeclaration();
    }

    public void setIsForwardDeclaration(boolean forward) {
        this.getTypeInfo().setIsForwardDeclaration(forward);
    }

    public int compareCVQualifiersTo(ISymbol symbol) {
        int size2;
        int size = symbol.getTypeInfo().hasPtrOperators() ? symbol.getTypeInfo().getPtrOperators().size() : 0;
        int n = size2 = this.getTypeInfo().hasPtrOperators() ? this.getTypeInfo().getPtrOperators().size() : 0;
        if (size != size2) {
            return size2 - size;
        }
        if (size == 0) {
            return 0;
        }
        Iterator iter1 = symbol.getTypeInfo().getPtrOperators().iterator();
        Iterator iter2 = this.getTypeInfo().getPtrOperators().iterator();
        TypeInfo.PtrOp op1 = null;
        TypeInfo.PtrOp op2 = null;
        int i = size;
        while (i > 0) {
            op1 = (TypeInfo.PtrOp)iter1.next();
            if (op1.compareCVTo(op2 = (TypeInfo.PtrOp)iter2.next()) != 0) {
                return -1;
            }
            --i;
        }
        return 0;
    }

    public List getPtrOperators() {
        return this.getTypeInfo().getPtrOperators();
    }

    public void addPtrOperator(TypeInfo.PtrOp ptrOp) {
        this.getTypeInfo().addPtrOperator(ptrOp);
    }

    public int getDepth() {
        return this._depth;
    }

    public boolean isTemplateMember() {
        return this._isTemplateMember;
    }

    public void setIsTemplateMember(boolean isMember) {
        this._isTemplateMember = isMember;
    }

    public ISymbol getTemplateInstance() {
        return this._templateInstance;
    }

    public void setTemplateInstance(TemplateInstance instance) {
        this._templateInstance = instance;
    }

    public Map getArgumentMap() {
        return null;
    }
}

