/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class ParameterizedSymbol
extends ContainerSymbol
implements IParameterizedSymbol {
    private LinkedList _parameterList;
    private HashMap _parameterMap;
    private LinkedList _specializations;
    private LinkedList _argumentList;
    private ISymbol _returnType;

    protected ParameterizedSymbol(ParserSymbolTable table, String name) {
        super(table, name);
    }

    protected ParameterizedSymbol(ParserSymbolTable table, String name, ISymbolASTExtension obj) {
        super(table, name, obj);
    }

    protected ParameterizedSymbol(ParserSymbolTable table, String name, TypeInfo.eType typeInfo) {
        super(table, name, typeInfo);
    }

    public Object clone() {
        ParameterizedSymbol copy = (ParameterizedSymbol)super.clone();
        copy._parameterList = this._parameterList != null ? (LinkedList)this._parameterList.clone() : null;
        copy._parameterMap = this._parameterMap != null ? (HashMap)this._parameterMap.clone() : null;
        copy._argumentList = this._argumentList != null ? (LinkedList)this._argumentList.clone() : null;
        copy._specializations = this._specializations != null ? (LinkedList)this._specializations.clone() : null;
        return copy;
    }

    public void addParameter(ISymbol param) {
        Map paramMap;
        List paramList = this.getParameterList();
        paramList.add(param);
        String name = param.getName();
        if (name != null && !name.equals("") && !(paramMap = this.getParameterMap()).containsKey(name)) {
            paramMap.put(name, param);
        }
        param.setContainingSymbol(this);
        param.setIsTemplateMember(this.isTemplateMember() || this.getType() == TypeInfo.t_template);
        AddParameterCommand command = new AddParameterCommand(this, (BasicSymbol)param);
        this.getSymbolTable().pushCommand(command);
    }

    public void addParameter(TypeInfo.eType type, int info, TypeInfo.PtrOp ptrOp, boolean hasDefault) {
        BasicSymbol param = new BasicSymbol(this.getSymbolTable(), "");
        TypeInfo t = param.getTypeInfo();
        t.setTypeInfo(info);
        t.setType(type);
        t.addPtrOperator(ptrOp);
        t.setHasDefault(hasDefault);
        this.addParameter(param);
    }

    public void addParameter(ISymbol typeSymbol, TypeInfo.PtrOp ptrOp, boolean hasDefault) {
        BasicSymbol param = new BasicSymbol(this.getSymbolTable(), "");
        TypeInfo info = param.getTypeInfo();
        info.setType(TypeInfo.t_type);
        info.setTypeSymbol(typeSymbol);
        info.addPtrOperator(ptrOp);
        info.setHasDefault(hasDefault);
        this.addParameter(param);
    }

    public void addArgument(ISymbol arg) {
        List argumentList = this.getArgumentList();
        argumentList.add(arg);
        arg.setIsTemplateMember(this.isTemplateMember() || this.getType() == TypeInfo.t_template);
        AddArgumentCommand command = new AddArgumentCommand(this, (BasicSymbol)arg);
        this.getSymbolTable().pushCommand(command);
    }

    public List getArgumentList() {
        if (this._argumentList == null) {
            this._argumentList = new LinkedList();
        }
        return this._argumentList;
    }

    public Map getParameterMap() {
        if (this._parameterMap == null) {
            this._parameterMap = new HashMap();
        }
        return this._parameterMap;
    }

    public List getParameterList() {
        if (this._parameterList == null) {
            this._parameterList = new LinkedList();
        }
        return this._parameterList;
    }

    public boolean hasSameParameters(IParameterizedSymbol function) {
        int fsize;
        if (function.getType() != this.getType()) {
            return false;
        }
        int size = this.getParameterList() == null ? 0 : this.getParameterList().size();
        int n = fsize = function.getParameterList() == null ? 0 : function.getParameterList().size();
        if (fsize != size) {
            return false;
        }
        if (fsize == 0) {
            return true;
        }
        Iterator iter = this.getParameterList().iterator();
        Iterator fIter = function.getParameterList().iterator();
        TypeInfo info = null;
        TypeInfo fInfo = null;
        int i = size;
        while (i > 0) {
            info = ((BasicSymbol)iter.next()).getTypeInfo();
            if (!info.equals(fInfo = ((BasicSymbol)fIter.next()).getTypeInfo())) {
                return false;
            }
            --i;
        }
        return true;
    }

    public void setReturnType(ISymbol type) {
        this._returnType = type;
    }

    public ISymbol getReturnType() {
        return this._returnType;
    }

    public boolean hasSpecializations() {
        return this._specializations != null && !this._specializations.isEmpty();
    }

    public void addSpecialization(IParameterizedSymbol spec) {
        List specializationList = this.getSpecializations();
        specializationList.add(spec);
        spec.setContainingSymbol(this.getContainingSymbol());
    }

    public List getSpecializations() {
        if (this._specializations == null) {
            this._specializations = new LinkedList();
        }
        return this._specializations;
    }

    private static class AddParameterCommand
    extends ParserSymbolTable.Command {
        private IParameterizedSymbol _decl;
        private ISymbol _param;

        public AddParameterCommand(IParameterizedSymbol container, ISymbol parameter) {
            this._decl = container;
            this._param = parameter;
        }

        public void undoIt() {
            this._decl.getParameterList().remove(this._param);
            String name = this._param.getName();
            if (name != null && !name.equals("")) {
                this._decl.getParameterMap().remove(name);
            }
        }
    }

    private static class AddArgumentCommand
    extends ParserSymbolTable.Command {
        private IParameterizedSymbol _decl;
        private ISymbol _arg;

        public AddArgumentCommand(IParameterizedSymbol container, ISymbol arg) {
            this._decl = container;
            this._arg = arg;
        }

        public void undoIt() {
            this._decl.getArgumentList().remove(this._arg);
        }
    }
}

