/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import java.util.ArrayList;
import org.eclipse.cdt.make.internal.ui.text.IMakefileColorManager;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileSimpleMacroRule;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileWordDetector;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class MakefileCodeScanner
extends RuleBasedScanner {
    private static final String[] keywords = new String[]{"define", "endef", "ifdef", "ifndef", "ifeq", "ifneq", "else", "endif", "include", "-include", "sinclude", "override", "endef", "export", "unexport", "vpath"};
    private static final String[] functions = new String[]{"subst", "patsubst", "strip", "findstring", "filter", "sort", "dir", "notdir", "suffix", "basename", "addsuffix", "addprefix", "join", "word", "words", "wordlist", "firstword", "wildcard", "error", "warning", "shell", "origin", "foreach", "call"};

    public MakefileCodeScanner(IMakefileColorManager provider) {
        Token keyword = new Token((Object)new TextAttribute(provider.getColor(IMakefileColorManager.MAKE_KEYWORD)));
        Token function = new Token((Object)new TextAttribute(provider.getColor(IMakefileColorManager.MAKE_FUNCTION)));
        Token comment = new Token((Object)new TextAttribute(provider.getColor(IMakefileColorManager.MAKE_COMMENT)));
        Token macro = new Token((Object)new TextAttribute(provider.getColor(IMakefileColorManager.MAKE_MACRO_VAR)));
        Token other = new Token((Object)new TextAttribute(provider.getColor(IMakefileColorManager.MAKE_DEFAULT)));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("#", (IToken)comment, '\\'));
        rules.add(new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char character) {
                return Character.isWhitespace(character);
            }
        }));
        WordRule wordRule = new WordRule((IWordDetector)new MakefileWordDetector(), (IToken)other);
        int i = 0;
        while (i < keywords.length) {
            wordRule.addWord(keywords[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < functions.length) {
            wordRule.addWord(functions[i], (IToken)function);
            ++i;
        }
        rules.add(wordRule);
        rules.add((Object)new MakefileSimpleMacroRule((IToken)macro));
        rules.add(new MacroRule((IToken)macro, (IToken)other));
        this.setDefaultReturnToken((IToken)other);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    private class MacroRule
    implements IRule {
        private static final int INIT_STATE = 0;
        private static final int VAR_STATE = 1;
        private static final int END_VAR_STATE = 2;
        private static final int EQUAL_STATE = 3;
        private static final int FINISH_STATE = 4;
        private static final int ERROR_STATE = 5;
        private IToken token;
        private StringBuffer buffer = new StringBuffer();
        protected IToken defaultToken;

        public MacroRule(IToken token, IToken defaultToken) {
            this.token = token;
            this.defaultToken = defaultToken;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int state = 0;
            this.buffer.setLength(0);
            boolean bTwoCharsAssign = false;
            int c = scanner.read();
            while (c != -1) {
                switch (state) {
                    case 0: {
                        if (c != 10 && Character.isWhitespace((char)c)) break;
                        if (this.isValidCharacter(c)) {
                            state = 1;
                            break;
                        }
                        state = 5;
                        break;
                    }
                    case 1: {
                        if (this.isValidCharacter(c)) break;
                    }
                    case 2: {
                        if (c != 10 && Character.isWhitespace((char)c)) {
                            state = 2;
                            break;
                        }
                        if (c == 58 || c == 43) {
                            bTwoCharsAssign = true;
                            state = 3;
                            break;
                        }
                        if (c == 61) {
                            state = 4;
                            break;
                        }
                        if (state == 2) {
                            scanner.unread();
                        }
                        state = 5;
                        break;
                    }
                    case 3: {
                        if (c == 61) {
                            state = 4;
                            break;
                        }
                        state = 5;
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                if (state >= 4) break;
                this.buffer.append((char)c);
                c = scanner.read();
            }
            scanner.unread();
            if (state == 4) {
                if (bTwoCharsAssign) {
                    scanner.unread();
                }
                return this.token;
            }
            if (this.defaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return Token.UNDEFINED;
        }

        protected void unreadBuffer(ICharacterScanner scanner) {
            int i = this.buffer.length() - 1;
            while (i >= 0) {
                scanner.unread();
                --i;
            }
        }

        protected boolean isValidCharacter(int c) {
            char c0 = (char)c;
            return Character.isLetterOrDigit(c0) || c0 == '_';
        }
    }
}

