/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.standard.StandardBuildManager;
import org.eclipse.cdt.core.resources.IStandardBuildInfo;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CProjectNature
implements IProjectNature {
    public static final String BUILDER_NAME = "cbuilder";
    public static final String BUILDER_ID = "org.eclipse.cdt.core.cbuilder";
    public static final String C_NATURE_ID = "org.eclipse.cdt.core.cnature";
    private IProject fProject;
    private IStandardBuildInfo fBuildInfo;

    public CProjectNature() {
    }

    public CProjectNature(IProject project) {
        this.setProject(project);
    }

    public static void addCNature(IProject project, IProgressMonitor mon) throws CoreException {
        CProjectNature.addNature(project, C_NATURE_ID, mon);
    }

    public static void removeCNature(IProject project, IProgressMonitor mon) throws CoreException {
        CProjectNature.removeNature(project, C_NATURE_ID, mon);
    }

    public static void addNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        int i = 0;
        while (i < prevNatures.length) {
            if (natureId.equals(prevNatures[i])) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static void removeNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        ArrayList<String> newNatures = new ArrayList<String>(Arrays.asList(prevNatures));
        newNatures.remove(natureId);
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        project.setDescription(description, monitor);
    }

    public void setBuildCommand(IPath locationPath, IProgressMonitor monitor) throws CoreException {
    }

    public IPath getBuildCommand() throws CoreException {
        if (this.fBuildInfo == null) {
            this.fBuildInfo = StandardBuildManager.getBuildInfo(this.fProject, true);
        }
        String buildLocation = this.fBuildInfo.getBuildLocation();
        return new Path(buildLocation);
    }

    public void setFullBuildArguments(String arguments, IProgressMonitor monitor) throws CoreException {
    }

    public String getFullBuildArguments() throws CoreException {
        String buildArguments;
        if (this.fBuildInfo == null) {
            this.fBuildInfo = StandardBuildManager.getBuildInfo(this.fProject, true);
        }
        if ((buildArguments = this.fBuildInfo.getFullBuildArguments()) == null) {
            buildArguments = "";
        }
        return buildArguments;
    }

    public void setIncrBuildArguments(String arguments, IProgressMonitor monitor) throws CoreException {
    }

    public String getIncrBuildArguments() throws CoreException {
        String buildArguments;
        if (this.fBuildInfo == null) {
            this.fBuildInfo = StandardBuildManager.getBuildInfo(this.fProject, true);
        }
        if ((buildArguments = this.fBuildInfo.getIncrementalBuildArguments()) == null) {
            buildArguments = "";
        }
        return buildArguments;
    }

    public void setStopOnError(boolean on) throws CoreException {
    }

    public void setBuildCommandOverride(boolean on) throws CoreException {
    }

    public boolean isStopOnError() throws CoreException {
        if (this.fBuildInfo == null) {
            this.fBuildInfo = StandardBuildManager.getBuildInfo(this.fProject, true);
        }
        return this.fBuildInfo.isStopOnError();
    }

    public boolean isDefaultBuildCmd() throws CoreException {
        if (this.fBuildInfo == null) {
            this.fBuildInfo = StandardBuildManager.getBuildInfo(this.fProject, true);
        }
        return this.fBuildInfo.isDefaultBuildCmd();
    }

    public static boolean hasCBuildSpec(IProject project) {
        boolean found = false;
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                    found = true;
                    break;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return found;
    }

    public void addCBuildSpec(IProgressMonitor mon) throws CoreException {
    }

    public static void addCBuildSpec(IProject project, IProgressMonitor mon) throws CoreException {
    }

    public void addToBuildSpec(String builderID, IProgressMonitor mon) throws CoreException {
        CProjectNature.addToBuildSpec(this.getProject(), builderID, mon);
    }

    public static void addToBuildSpec(IProject project, String builderID, IProgressMonitor mon) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            description.setBuildSpec(newCommands);
            project.setDescription(description, mon);
        }
    }

    public void removeCBuildSpec(IProgressMonitor mon) throws CoreException {
    }

    public void removeFromBuildSpec(String builderID, IProgressMonitor mon) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                break;
            }
            ++i;
        }
        this.getProject().setDescription(description, mon);
    }

    public static String getBuilderID() {
        CCorePlugin plugin = CCorePlugin.getDefault();
        IPluginDescriptor descriptor = plugin.getDescriptor();
        if (descriptor.getExtension(BUILDER_NAME) != null) {
            return String.valueOf(descriptor.getUniqueIdentifier()) + "." + BUILDER_NAME;
        }
        return BUILDER_ID;
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }
}

