/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model;

import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IProjectEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.internal.core.model.ACPathEntry;
import org.eclipse.cdt.internal.core.model.BatchOperation;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.ContainerEntry;
import org.eclipse.cdt.internal.core.model.IncludeEntry;
import org.eclipse.cdt.internal.core.model.LibraryEntry;
import org.eclipse.cdt.internal.core.model.MacroEntry;
import org.eclipse.cdt.internal.core.model.ProjectEntry;
import org.eclipse.cdt.internal.core.model.SourceEntry;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class CoreModel {
    private static CoreModel cmodel = null;
    private static CModelManager manager = null;
    public static final String CORE_MODEL_ID = "org.eclipse.cdt.core.coremodel";

    public ICElement create(IPath path) {
        return manager.create(path);
    }

    public ICElement create(IFile file) {
        return manager.create(file);
    }

    public ICContainer create(IFolder folder) {
        return manager.create(folder);
    }

    public ICProject create(IProject project) {
        return manager.create(project);
    }

    public ICElement create(IResource resource) {
        return manager.create(resource);
    }

    public ICModel getCModel() {
        return manager.getCModel();
    }

    public boolean isSharedLib(IFile file) {
        return manager.isSharedLib(file);
    }

    public boolean isObject(IFile file) {
        return manager.isObject(file);
    }

    public boolean isExecutable(IFile file) {
        return manager.isExecutable(file);
    }

    public boolean isBinary(IFile file) {
        return manager.isBinary(file);
    }

    public boolean isArchive(IFile file) {
        return manager.isArchive(file);
    }

    public boolean isTranslationUnit(IFile file) {
        return manager.isTranslationUnit(file);
    }

    public boolean isValidTranslationUnitName(String name) {
        return manager.isValidTranslationUnitName(name);
    }

    public String[] getHeaderExtensions() {
        return manager.getHeaderExtensions();
    }

    public String[] getSourceExtensions() {
        return manager.getSourceExtensions();
    }

    public String[] getTranslationUnitExtensions() {
        return manager.getTranslationUnitExtensions();
    }

    public boolean hasCNature(IProject project) {
        return manager.hasCNature(project);
    }

    public boolean hasCCNature(IProject project) {
        return manager.hasCCNature(project);
    }

    public static IProjectEntry newProjectEntry(IPath path) {
        return CoreModel.newProjectEntry(path, false);
    }

    public static IProjectEntry newProjectEntry(IPath path, boolean isExported) {
        return new ProjectEntry(path, isExported);
    }

    public static IContainerEntry newContainerEntry(String id) {
        return CoreModel.newContainerEntry(id, false);
    }

    public static IContainerEntry newContainerEntry(String id, boolean isExported) {
        return new ContainerEntry(id, isExported);
    }

    public static ILibraryEntry newLibraryEntry(IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath sourceAttachmentPrefixMapping) {
        return CoreModel.newLibraryEntry(path, sourceAttachmentPath, sourceAttachmentRootPath, sourceAttachmentPrefixMapping, false);
    }

    public static ILibraryEntry newLibraryEntry(IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath sourceAttachmentPrefixMapping, boolean isExported) {
        return new LibraryEntry(path, sourceAttachmentPath, sourceAttachmentRootPath, sourceAttachmentPrefixMapping, isExported);
    }

    public static ISourceEntry newSourceEntry(IPath path) {
        return CoreModel.newSourceEntry(path, ACPathEntry.NO_EXCLUSION_PATTERNS);
    }

    public static ISourceEntry newSourceEntry(IPath path, IPath[] exclusionPatterns) {
        return CoreModel.newSourceEntry(path, null, exclusionPatterns);
    }

    public static ISourceEntry newSourceEntry(IPath path, IPath outputLocation, IPath[] exclusionPatterns) {
        return CoreModel.newSourceEntry(path, outputLocation, true, exclusionPatterns);
    }

    public static ISourceEntry newSourceEntry(IPath path, IPath outputLocation, boolean isRecursive, IPath[] exclusionPatterns) {
        return new SourceEntry(path, outputLocation, isRecursive, exclusionPatterns);
    }

    public static IIncludeEntry newIncludeEntry(IPath path, IPath includePath) {
        return CoreModel.newIncludeEntry(path, includePath, false);
    }

    public static IIncludeEntry newIncludeEntry(IPath path, IPath includePath, boolean isSystemInclude) {
        return CoreModel.newIncludeEntry(path, includePath, isSystemInclude, true, ACPathEntry.NO_EXCLUSION_PATTERNS, true);
    }

    public static IIncludeEntry newIncludeEntry(IPath path, IPath includePath, boolean isSystemInclude, boolean isRecursive, IPath[] exclusionPatterns, boolean isExported) {
        return new IncludeEntry(path, includePath, isSystemInclude, isRecursive, exclusionPatterns, isExported);
    }

    public static IMacroEntry newMacroEntry(IPath path, String macroName, String macroValue) {
        return CoreModel.newMacroEntry(path, macroName, macroValue, true, ACPathEntry.NO_EXCLUSION_PATTERNS, true);
    }

    public static IMacroEntry newMacroEntry(IPath path, String macroName, String macroValue, boolean isRecursive, IPath[] exclusionPatterns, boolean isExported) {
        return new MacroEntry(path, macroName, macroValue, isRecursive, exclusionPatterns, isExported);
    }

    public void resetBinaryParser(IProject project) {
        manager.resetBinaryParser(project);
    }

    public static CoreModel getDefault() {
        if (cmodel == null) {
            cmodel = new CoreModel();
            manager = CModelManager.getDefault();
        }
        return cmodel;
    }

    public void addElementChangedListener(IElementChangedListener listener) {
        manager.addElementChangedListener(listener);
    }

    public void removeElementChangedListener(IElementChangedListener listener) {
        manager.removeElementChangedListener(listener);
    }

    public void startup() {
        manager.startup();
    }

    public void shutdown() {
        manager.shutdown();
    }

    private CoreModel() {
    }

    public static void run(IWorkspaceRunnable action, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.isTreeLocked()) {
            new BatchOperation(action).run(monitor);
        } else {
            workspace.run((IWorkspaceRunnable)new BatchOperation(action), monitor);
        }
    }

    public void startIndexing() {
        manager.getIndexManager().reset();
    }

    public IndexManager getIndexManager() {
        return manager.getIndexManager();
    }
}

