/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;

public abstract class MultiOperation
extends CModelOperation {
    protected String[] fRenamingsList = null;
    protected Map fParentElements;
    protected Map fInsertBeforeElements = new HashMap(1);
    protected Map fRenamings;

    protected MultiOperation(ICElement[] elementsToProcess, ICElement[] parentElements, boolean force) {
        super(elementsToProcess, parentElements, force);
        this.fParentElements = new HashMap(elementsToProcess.length);
        if (elementsToProcess.length == parentElements.length) {
            int i = 0;
            while (i < elementsToProcess.length) {
                this.fParentElements.put(elementsToProcess[i], parentElements[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < elementsToProcess.length) {
                this.fParentElements.put(elementsToProcess[i], parentElements[0]);
                ++i;
            }
        }
    }

    protected MultiOperation(ICElement[] elementsToProcess, boolean force) {
        super(elementsToProcess, force);
    }

    protected void error(int code, ICElement element) throws CModelException {
        throw new CModelException(new CModelStatus(code, element));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws CModelException {
        try {
            this.processElements();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.mergeDeltas();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.mergeDeltas();
            return;
        }
    }

    protected ICElement getDestinationParent(ICElement child) {
        return (ICElement)this.fParentElements.get(child);
    }

    protected abstract String getMainTaskName();

    protected String getNewNameFor(ICElement element) {
        if (this.fRenamings != null) {
            return (String)this.fRenamings.get(element);
        }
        return null;
    }

    private void initializeRenamings() {
        if (this.fRenamingsList != null && this.fRenamingsList.length == this.fElementsToProcess.length) {
            this.fRenamings = new HashMap(this.fRenamingsList.length);
            int i = 0;
            while (i < this.fRenamingsList.length) {
                if (this.fRenamingsList[i] != null) {
                    this.fRenamings.put(this.fElementsToProcess[i], this.fRenamingsList[i]);
                }
                ++i;
            }
        }
    }

    protected boolean isMove() {
        return false;
    }

    protected boolean isRename() {
        return false;
    }

    protected void mergeDeltas() {
        if (this.fDeltas != null) {
            CElementDelta rootDelta = this.newCElementDelta();
            boolean insertedTree = false;
            int i = 0;
            while (i < this.fDeltas.length) {
                ICElementDelta delta = this.fDeltas[i];
                ICElementDelta[] children = delta.getAffectedChildren();
                int j = 0;
                while (j < children.length) {
                    CElementDelta projectDelta = (CElementDelta)children[j];
                    rootDelta.insertDeltaTree(projectDelta.getElement(), projectDelta);
                    insertedTree = true;
                    ++j;
                }
                ++i;
            }
            this.fDeltas = insertedTree ? new ICElementDelta[]{rootDelta} : null;
        }
    }

    protected abstract void processElement(ICElement var1) throws CModelException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processElements() throws CModelException {
        this.beginTask(this.getMainTaskName(), this.fElementsToProcess.length);
        ICModelStatus[] errors = new ICModelStatus[3];
        int errorsCounter = 0;
        int i = 0;
        while (true) {
            Object var5_5;
            if (i >= this.fElementsToProcess.length) {
                this.done();
                if (errorsCounter != true) break;
                throw new CModelException(errors[0]);
            }
            try {
                try {
                    this.verify(this.fElementsToProcess[i]);
                    this.processElement(this.fElementsToProcess[i]);
                }
                catch (CModelException jme) {
                    if (errorsCounter == errors.length) {
                        ICModelStatus[] iCModelStatusArray = errors;
                        errors = new ICModelStatus[errorsCounter * 2];
                        System.arraycopy(iCModelStatusArray, 0, errors, 0, errorsCounter);
                    }
                    errors[errorsCounter++] = jme.getCModelStatus();
                }
            }
            catch (Throwable throwable) {
                var5_5 = null;
                this.worked(1);
                throw throwable;
            }
            {
                var5_5 = null;
                this.worked(1);
                ++i;
                continue;
            }
            break;
        }
        if (errorsCounter <= 1) {
            return;
        }
        if (errorsCounter != errors.length) {
            ICModelStatus[] iCModelStatusArray = errors;
            errors = new ICModelStatus[errorsCounter];
            System.arraycopy(iCModelStatusArray, 0, errors, 0, errorsCounter);
        }
        throw new CModelException(CModelStatus.newMultiStatus(errors));
    }

    public void setInsertBefore(ICElement modifiedElement, ICElement newSibling) {
        this.fInsertBeforeElements.put(modifiedElement, newSibling);
    }

    public void setRenamings(String[] renamings) {
        this.fRenamingsList = renamings;
        this.initializeRenamings();
    }

    protected abstract void verify(ICElement var1) throws CModelException;

    protected void verifyDestination(ICElement element, ICElement destination) throws CModelException {
        if (destination == null || !destination.exists()) {
            this.error(969, destination);
        }
    }

    protected void verifyRenaming(ICElement element) throws CModelException {
        String newName = this.getNewNameFor(element);
        boolean isValid = true;
        if (newName.indexOf(32) != -1) {
            isValid = false;
        }
        if (!isValid) {
            throw new CModelException(new CModelStatus(983, element, newName));
        }
    }

    protected void verifySibling(ICElement element, ICElement destination) throws CModelException {
        ICElement insertBeforeElement = (ICElement)this.fInsertBeforeElements.get(element);
        if (!(insertBeforeElement == null || insertBeforeElement.exists() && insertBeforeElement.getParent().equals(destination))) {
            this.error(993, insertBeforeElement);
        }
    }
}

