/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

class AddFolderToIndex
extends IndexRequest {
    IPath folderPath;
    IProject project;
    char[][] exclusionPattern;

    public AddFolderToIndex(IPath folderPath, IProject project, char[][] exclusionPattern, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.folderPath = folderPath;
        this.project = project;
        this.exclusionPattern = exclusionPattern;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        IResource folder = this.project.getParent().findMember(this.folderPath);
        if (folder == null) return true;
        if (folder.getType() == 1) {
            return true;
        }
        IIndex index = this.manager.getIndex(this.indexPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.manager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                final IPath container = this.indexPath;
                final IndexManager indexManager = this.manager;
                final char[][] pattern = this.exclusionPattern;
                folder.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        switch (proxy.getType()) {
                            case 1: {
                                IResource resource = proxy.requestResource();
                                if (pattern == null || !Util.isExcluded(resource, pattern)) {
                                    indexManager.addSource((IFile)resource, container);
                                }
                            }
                            case 2: {
                                if (pattern == null || !Util.isExcluded(proxy.requestResource(), pattern)) break;
                                return false;
                            }
                        }
                        return true;
                    }
                }, 0);
            }
            catch (CoreException e) {
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> failed to add " + this.folderPath + " to index because of the following exception:");
                    e.printStackTrace();
                }
                Object var8_9 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.exitRead();
            throw throwable;
        }
        {
            Object var8_11 = null;
            monitor.exitRead();
            return true;
        }
    }

    public String toString() {
        return "adding " + this.folderPath + " to index " + this.indexPath;
    }
}

