/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryException;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class SourceIndexer
extends AbstractIndexer {
    IFile resourceFile;

    SourceIndexer(IFile resourceFile) {
        this.resourceFile = resourceFile;
    }

    public String[] getFileTypes() {
        return CModelManager.sourceExtensions;
    }

    protected void indexFile(IDocument document) throws IOException {
        IScannerInfo buildScanInfo;
        this.output.addDocument(document);
        SourceIndexerRequestor requestor = new SourceIndexerRequestor(this, document);
        IProject currentProject = this.resourceFile.getProject();
        ScannerInfo scanInfo = new ScannerInfo();
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(currentProject);
        if (provider != null && (buildScanInfo = provider.getScannerInformation((IResource)currentProject)) != null) {
            scanInfo = new ScannerInfo(buildScanInfo.getDefinedSymbols(), buildScanInfo.getIncludePaths());
        }
        ParserLanguage language = CoreModel.getDefault().hasCCNature(currentProject) ? ParserLanguage.CPP : ParserLanguage.C;
        IParser parser = null;
        try {
            parser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((Reader)new StringReader(document.getStringContent()), (String)this.resourceFile.getLocation().toOSString(), (IScannerInfo)scanInfo, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)language, (ISourceElementRequestor)requestor, (IParserLogService)ParserUtil.getParserLogService()), (ISourceElementRequestor)requestor, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)language, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryException parserFactoryException) {}
        boolean retVal = parser.parse();
        if (!retVal) {
            Util.log(null, "Failed to index " + this.resourceFile.getFullPath(), ICLogConstants.CDT);
        }
        if (AbstractIndexer.VERBOSE) {
            if (!retVal) {
                AbstractIndexer.verbose("PARSE FAILED " + this.resourceFile.getName().toString());
            } else {
                AbstractIndexer.verbose("PARSE SUCCEEDED " + this.resourceFile.getName().toString());
            }
        }
    }

    public void setFileTypes(String[] fileTypes) {
    }

    public IFile getResourceFile() {
        return this.resourceFile;
    }
}

