/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;

public class CWatchpoint
extends CBreakpoint
implements ICWatchpoint {
    private static final String C_WATCHPOINT = "org.eclipse.cdt.debug.core.cWatchpointMarker";

    public CWatchpoint() {
    }

    public CWatchpoint(IResource resource, Map attributes, boolean add) throws DebugException {
        super(resource, CWatchpoint.getMarkerType(), attributes, add);
    }

    public boolean isWriteType() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.write", true);
    }

    public boolean isReadType() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.read", false);
    }

    public String getExpression() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.expression", "");
    }

    public static String getMarkerType() {
        return C_WATCHPOINT;
    }

    protected String getMarkerMessage() throws CoreException {
        String expression;
        StringBuffer sb = new StringBuffer();
        if (this.isWriteType() && !this.isReadType()) {
            sb.append("Write ");
        } else if (!this.isWriteType() && this.isReadType()) {
            sb.append("Read ");
        } else if (this.isWriteType() && this.isReadType()) {
            sb.append("Access ");
        }
        sb.append("watchpoint: ");
        String fileName = this.ensureMarker().getResource().getName();
        if (fileName != null && fileName.length() > 0) {
            sb.append(' ');
            sb.append(fileName);
        }
        if ((expression = this.getExpression()) != null && expression.length() > 0) {
            sb.append(" at '");
            sb.append(expression);
            sb.append('\'');
        }
        sb.append(this.getConditionText());
        return sb.toString();
    }
}

