/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.internal.ui.SolibSearchPathBlock;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class GDBSolibBlock
extends Observable
implements Observer {
    private SolibSearchPathBlock fSolibSearchPathBlock;
    private Button fAutoSoLibButton;
    private Button fStopOnSolibEventsButton;
    private Composite fControl;

    public void createBlock(Composite parent, boolean solibPath, boolean autoSolib, boolean stopOnSolibEvents) {
        Composite subComp = ControlFactory.createCompositeEx((Composite)parent, (int)1, (int)768);
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)subComp.getLayout()).marginHeight = 0;
        ((GridLayout)subComp.getLayout()).marginWidth = 0;
        if (solibPath) {
            this.fSolibSearchPathBlock = new SolibSearchPathBlock();
            this.fSolibSearchPathBlock.createBlock(subComp);
            this.fSolibSearchPathBlock.addObserver(this);
        }
        if (autoSolib) {
            this.fAutoSoLibButton = ControlFactory.createCheckBox((Composite)subComp, (String)"Load shared library symbols automatically");
            this.fAutoSoLibButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GDBSolibBlock.this.updateButtons();
                    GDBSolibBlock.this.changed();
                }
            });
        }
        if (stopOnSolibEvents) {
            this.fStopOnSolibEventsButton = ControlFactory.createCheckBox((Composite)subComp, (String)"Stop on shared library events");
            this.fStopOnSolibEventsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GDBSolibBlock.this.updateButtons();
                    GDBSolibBlock.this.changed();
                }
            });
        }
        this.setControl(subComp);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.fSolibSearchPathBlock != null) {
            this.fSolibSearchPathBlock.initializeFrom(configuration);
        }
        try {
            if (this.fAutoSoLibButton != null) {
                this.fAutoSoLibButton.setSelection(configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true));
            }
            if (this.fStopOnSolibEventsButton != null) {
                this.fStopOnSolibEventsButton.setSelection(configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false));
            }
            this.initializeButtons(configuration);
            this.updateButtons();
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fSolibSearchPathBlock != null) {
            this.fSolibSearchPathBlock.performApply(configuration);
        }
        try {
            Map attrs = configuration.getAttributes();
            if (this.fAutoSoLibButton != null) {
                attrs.put(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, new Boolean(this.fAutoSoLibButton.getSelection()));
            }
            if (this.fStopOnSolibEventsButton != null) {
                attrs.put(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, new Boolean(this.fStopOnSolibEventsButton.getSelection()));
            }
            configuration.setAttributes(attrs);
        }
        catch (CoreException coreException) {}
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fSolibSearchPathBlock != null) {
            this.fSolibSearchPathBlock.setDefaults(configuration);
        }
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
    }

    protected void updateButtons() {
    }

    public void dispose() {
        this.deleteObservers();
        if (this.fSolibSearchPathBlock != null) {
            this.fSolibSearchPathBlock.deleteObserver(this);
            this.fSolibSearchPathBlock.dispose();
        }
    }

    public void disable() {
        if (this.fAutoSoLibButton != null) {
            this.fAutoSoLibButton.setEnabled(false);
        }
        if (this.fStopOnSolibEventsButton != null) {
            this.fStopOnSolibEventsButton.setEnabled(false);
        }
    }

    public void update(Observable o, Object arg) {
        this.changed();
    }

    protected void changed() {
        this.setChanged();
        this.notifyObservers();
    }

    public Composite getControl() {
        return this.fControl;
    }

    protected void setControl(Composite composite) {
        this.fControl = composite;
    }

    protected void initializeButtons(ILaunchConfiguration configuration) {
        try {
            boolean enable;
            boolean bl = enable = !"core".equals(configuration.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", ""));
            if (this.fAutoSoLibButton != null) {
                this.fAutoSoLibButton.setEnabled(enable);
            }
            if (this.fStopOnSolibEventsButton != null) {
                this.fStopOnSolibEventsButton.setEnabled(enable);
            }
        }
        catch (CoreException coreException) {}
    }
}

