/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MITargetAttach;
import org.eclipse.cdt.debug.mi.core.command.MITargetSelect;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;

public class MIPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.mi.core";
    private static MIPlugin plugin;
    private static final String GDBINIT = ".gdbinit";
    private static final String GDB = "gdb";

    public MIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static MIPlugin getDefault() {
        return plugin;
    }

    public MISession createMISession(Process process, PTY pty, int timeout, int type, int launchTimeout) throws MIException {
        return new MISession(process, pty, timeout, type, launchTimeout);
    }

    public MISession createMISession(Process process, PTY pty, int type) throws MIException {
        MIPlugin plugin = MIPlugin.getDefault();
        Preferences prefs = plugin.getPluginPreferences();
        int timeout = prefs.getInt(IMIConstants.PREF_REQUEST_TIMEOUT);
        int launchTimeout = prefs.getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
        return this.createMISession(process, pty, timeout, type, launchTimeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createCSession(String gdb, File program, File cwd, String gdbinit) throws IOException, MIException {
        InputStream in2;
        ICDISession iCDISession;
        PTY pty = null;
        boolean failed = false;
        try {
            pty = new PTY();
        }
        catch (IOException iOException) {}
        try {
            try {
                iCDISession = this.createCSession(gdb, program, cwd, gdbinit, pty);
                Object var8_8 = null;
                if (!failed) return iCDISession;
                if (pty == null) return iCDISession;
            }
            catch (IOException exc) {
                failed = true;
                throw exc;
            }
            catch (MIException exc) {
                failed = true;
                throw exc;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!failed) throw throwable;
            if (pty == null) throw throwable;
            try {
                InputStream in2;
                OutputStream out = pty.getOutputStream();
                if (out != null) {
                    out.close();
                }
                if ((in2 = pty.getInputStream()) == null) throw throwable;
                in2.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        OutputStream out = pty.getOutputStream();
        if (out != null) {
            out.close();
        }
        if ((in2 = pty.getInputStream()) == null) return iCDISession;
        in2.close();
        return iCDISession;
    }

    public ICDISession createCSession(String gdb, File program, File cwd, String gdbinit, PTY pty) throws IOException, MIException {
        MISession session;
        if (gdb == null || gdb.length() == 0) {
            gdb = GDB;
        }
        if (gdbinit == null || gdbinit.length() == 0) {
            gdbinit = GDBINIT;
        }
        String[] args = pty != null ? (program == null ? new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "-q", "-nw", "-tty", pty.getSlaveName(), "-i", "mi1"} : new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "-q", "-nw", "-tty", pty.getSlaveName(), "-i", "mi1", program.getAbsolutePath()}) : (program == null ? new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "-q", "-nw", "-i", "mi1"} : new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "-q", "-nw", "-i", "mi1", program.getAbsolutePath()});
        Process pgdb = this.getGDBProcess(args);
        try {
            session = this.createMISession(pgdb, pty, 0);
        }
        catch (MIException e) {
            pgdb.destroy();
            throw e;
        }
        try {
            CLICommand cmd = new CLICommand("info remote-process");
            session.postCommand(cmd);
            MIInfo info = cmd.getMIInfo();
            if (info == null) {
                pgdb.destroy();
                throw new MIException("No answer");
            }
            session.getMIInferior().setSuspended();
            session.getMIInferior().update();
        }
        catch (MIException mIException) {}
        return new Session(session, false);
    }

    public ICDISession createCSession(String gdb, File program, File core, File cwd, String gdbinit) throws IOException, MIException {
        MISession session;
        if (gdb == null || gdb.length() == 0) {
            gdb = GDB;
        }
        if (gdbinit == null || gdbinit.length() == 0) {
            gdbinit = GDBINIT;
        }
        String[] args = program == null ? new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "--quiet", "-nw", "-i", "mi1", "-c", core.getAbsolutePath()} : new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "--quiet", "-nw", "-i", "mi1", "-c", core.getAbsolutePath(), program.getAbsolutePath()};
        Process pgdb = this.getGDBProcess(args);
        try {
            session = this.createMISession(pgdb, null, 2);
        }
        catch (MIException e) {
            pgdb.destroy();
            throw e;
        }
        return new Session(session);
    }

    public ICDISession createCSession(String gdb, File program, int pid, String[] targetParams, File cwd, String gdbinit) throws IOException, MIException {
        MIInfo info;
        MISession session;
        if (gdb == null || gdb.length() == 0) {
            gdb = GDB;
        }
        if (gdbinit == null || gdbinit.length() == 0) {
            gdbinit = GDBINIT;
        }
        String[] args = program == null ? new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "--quiet", "-nw", "-i", "mi1"} : new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "--quiet", "-nw", "-i", "mi1", program.getAbsolutePath()};
        Process pgdb = this.getGDBProcess(args);
        try {
            session = this.createMISession(pgdb, null, 1);
        }
        catch (MIException e) {
            pgdb.destroy();
            throw e;
        }
        CommandFactory factory = session.getCommandFactory();
        if (targetParams != null && targetParams.length > 0) {
            MITargetSelect target = factory.createMITargetSelect(targetParams);
            session.postCommand(target);
            info = target.getMIInfo();
            if (info == null) {
                pgdb.destroy();
                throw new MIException("No answer");
            }
        }
        if (pid > 0) {
            MITargetAttach attach = factory.createMITargetAttach(pid);
            session.postCommand(attach);
            info = attach.getMIInfo();
            if (info == null) {
                pgdb.destroy();
                throw new MIException("No answer");
            }
        }
        session.getMIInferior().setSuspended();
        session.getMIInferior().update();
        return new Session(session, true);
    }

    public static String getUniqueIdentifier() {
        if (MIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return MIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public void debugLog(String message) {
        if (MIPlugin.getDefault().isDebugging()) {
            message = MessageFormat.format("[{0}] {1}", new Long(System.currentTimeMillis()), message);
            while (message.length() > 100) {
                String partial = message.substring(0, 100);
                message = message.substring(100);
                System.err.println(String.valueOf(partial) + "\\");
            }
            if (message.endsWith("\n")) {
                System.err.print(message);
            } else {
                System.err.println(message);
            }
        }
    }

    protected Process getGDBProcess(String[] args) throws IOException {
        final Process pgdb = ProcessFactory.getFactory().exec(args);
        Thread syncStartup = new Thread("GDB Start"){

            public void run() {
                try {
                    String line;
                    InputStream stream = pgdb.getInputStream();
                    InputStreamReader r = new InputStreamReader(stream);
                    BufferedReader reader = new BufferedReader(r);
                    while ((line = reader.readLine()) != null) {
                        if (!(line = line.trim()).startsWith("(gdb)")) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {}
                Process process = pgdb;
                synchronized (process) {
                    pgdb.notifyAll();
                }
            }
        };
        syncStartup.start();
        Process process = pgdb;
        synchronized (process) {
            MIPlugin plugin = MIPlugin.getDefault();
            Preferences prefs = plugin.getPluginPreferences();
            int launchTimeout = prefs.getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
            while (syncStartup.isAlive()) {
                try {
                    pgdb.wait(launchTimeout);
                    break;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            syncStartup.interrupt();
            syncStartup.join(1000L);
        }
        catch (InterruptedException interruptedException) {}
        return pgdb;
    }

    public void startup() throws CoreException {
        super.startup();
    }

    protected void initializeDefaultPluginPreferences() {
        this.getPluginPreferences().setDefault(IMIConstants.PREF_REQUEST_TIMEOUT, 10000);
        this.getPluginPreferences().setDefault(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT, 30000);
    }

    public void shutdown() throws CoreException {
        this.savePluginPreferences();
        super.shutdown();
    }
}

