/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDICatchEvent;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDICatchpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Condition;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Watchpoint;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIBreakAfter;
import org.eclipse.cdt.debug.mi.core.command.MIBreakCondition;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDelete;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDisable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakEnable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakInsert;
import org.eclipse.cdt.debug.mi.core.command.MIBreakList;
import org.eclipse.cdt.debug.mi.core.command.MIBreakWatch;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.output.MIBreakInsertInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakListInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakWatchInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;

public class BreakpointManager
extends SessionObject
implements ICDIBreakpointManager {
    List breakList = Collections.synchronizedList(new ArrayList());
    List deferredList = Collections.synchronizedList(new ArrayList());
    boolean allowInterrupt = true;
    boolean autoupdate = false;

    public BreakpointManager(Session session) {
        super(session);
    }

    public MIBreakpoint[] getMIBreakpoints() throws CDIException {
        Session s = (Session)this.getSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakList breakpointList = factory.createMIBreakList();
        try {
            s.getMISession().postCommand(breakpointList);
            MIBreakListInfo info = breakpointList.getMIBreakListInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            return info.getMIBreakpoints();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    boolean hasBreakpointChanged(Breakpoint point, MIBreakpoint miBreakpoint) {
        MIBreakpoint miBreak = point.getMIBreakpoint();
        return miBreak.isEnabled() != miBreakpoint.isEnabled() || !miBreak.getCondition().equals(miBreakpoint.getCondition()) || miBreak.getIgnoreCount() != miBreakpoint.getIgnoreCount();
    }

    public Breakpoint getBreakpoint(int number) {
        Breakpoint[] bkpts = this.breakList.toArray(new Breakpoint[0]);
        int i = 0;
        while (i < bkpts.length) {
            MIBreakpoint miBreak = bkpts[i].getMIBreakpoint();
            if (miBreak.getNumber() == number) {
                return bkpts[i];
            }
            ++i;
        }
        return null;
    }

    public Watchpoint getWatchpoint(int number) {
        return (Watchpoint)this.getBreakpoint(number);
    }

    boolean suspendInferior(ICDITarget target) throws CDIException {
        boolean shouldRestart = false;
        if (this.allowInterrupt) {
            if (target instanceof Target) {
                Target ctarget = (Target)target;
                if (ctarget.isRunning()) {
                    ctarget.suspend();
                    shouldRestart = true;
                }
            } else if (!target.isSuspended()) {
                target.suspend();
                shouldRestart = true;
            }
        }
        return shouldRestart;
    }

    void resumeInferior(ICDITarget target, boolean shouldRestart) throws CDIException {
        if (shouldRestart) {
            target.resume();
        }
    }

    public void deleteBreakpoint(int no) {
        Breakpoint[] points = this.breakList.toArray(new Breakpoint[0]);
        int i = 0;
        while (i < points.length) {
            if (points[i].getMIBreakpoint().getNumber() == no) {
                this.breakList.remove(points[i]);
                break;
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void enableBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        int number = 0;
        if (!(breakpoint instanceof Breakpoint)) throw new CDIException("Not a CDT breakpoint");
        if (!this.breakList.contains(breakpoint)) throw new CDIException("Not a CDT breakpoint");
        number = ((Breakpoint)breakpoint).getMIBreakpoint().getNumber();
        boolean state = this.suspendInferior(breakpoint.getTarget());
        Session session = (Session)this.getSession();
        CommandFactory factory = session.getMISession().getCommandFactory();
        MIBreakEnable breakEnable = factory.createMIBreakEnable(new int[]{number});
        try {
            try {
                session.getMISession().postCommand(breakEnable);
                MIInfo info = breakEnable.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.resumeInferior(breakpoint.getTarget(), state);
            throw throwable;
        }
        this.resumeInferior(breakpoint.getTarget(), state);
        ((Breakpoint)breakpoint).getMIBreakpoint().setEnabled(true);
        MISession mi = session.getMISession();
        mi.fireEvent(new MIBreakpointChangedEvent(((Breakpoint)breakpoint).getMIBreakpoint().getNumber()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void disableBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        int number = 0;
        if (!(breakpoint instanceof Breakpoint)) throw new CDIException("Not a CDT breakpoint");
        if (!this.breakList.contains(breakpoint)) throw new CDIException("Not a CDT breakpoint");
        number = ((Breakpoint)breakpoint).getMIBreakpoint().getNumber();
        Session session = (Session)this.getSession();
        boolean state = this.suspendInferior(breakpoint.getTarget());
        CommandFactory factory = session.getMISession().getCommandFactory();
        MIBreakDisable breakDisable = factory.createMIBreakDisable(new int[]{number});
        try {
            try {
                session.getMISession().postCommand(breakDisable);
                MIInfo info = breakDisable.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.resumeInferior(breakpoint.getTarget(), state);
            throw throwable;
        }
        this.resumeInferior(breakpoint.getTarget(), state);
        ((Breakpoint)breakpoint).getMIBreakpoint().setEnabled(false);
        MISession mi = session.getMISession();
        mi.fireEvent(new MIBreakpointChangedEvent(((Breakpoint)breakpoint).getMIBreakpoint().getNumber()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCondition(ICDIBreakpoint breakpoint, ICDICondition condition) throws CDIException {
        int ignoreCount;
        String exprCond;
        CommandFactory factory;
        boolean state;
        Session session;
        int number;
        block9: {
            block10: {
                block8: {
                    number = 0;
                    if (!(breakpoint instanceof Breakpoint) || !this.breakList.contains(breakpoint)) break block8;
                    number = ((Breakpoint)breakpoint).getMIBreakpoint().getNumber();
                    session = (Session)this.getSession();
                    state = this.suspendInferior(breakpoint.getTarget());
                    factory = session.getMISession().getCommandFactory();
                    exprCond = condition.getExpression();
                    if (exprCond != null) break block9;
                    break block10;
                }
                throw new CDIException("Not a CDT breakpoint");
            }
            exprCond = "";
        }
        if ((ignoreCount = condition.getIgnoreCount()) < 0) {
            ignoreCount = 0;
        }
        try {
            try {
                MIBreakCondition breakCondition = factory.createMIBreakCondition(number, exprCond);
                session.getMISession().postCommand(breakCondition);
                MIInfo info = breakCondition.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                MIBreakAfter breakAfter = factory.createMIBreakAfter(number, ignoreCount);
                session.getMISession().postCommand(breakAfter);
                info = breakAfter.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.resumeInferior(breakpoint.getTarget(), state);
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        this.resumeInferior(breakpoint.getTarget(), state);
        MISession mi = session.getMISession();
        mi.fireEvent(new MIBreakpointChangedEvent(((Breakpoint)breakpoint).getMIBreakpoint().getNumber()));
    }

    public void update() throws CDIException {
        MIBreakpoint[] newMIBreakpoints = this.getMIBreakpoints();
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>(newMIBreakpoints.length);
        int i = 0;
        while (i < newMIBreakpoints.length) {
            int no = newMIBreakpoints[i].getNumber();
            Breakpoint bp = this.getBreakpoint(no);
            if (bp != null) {
                if (this.hasBreakpointChanged(bp, newMIBreakpoints[i])) {
                    bp.setMIBreakpoint(newMIBreakpoints[i]);
                    eventList.add(new MIBreakpointChangedEvent(no));
                } else {
                    eventList.add(new MIBreakpointCreatedEvent(no));
                }
            } else {
                if (newMIBreakpoints[i].isWatchpoint()) {
                    this.breakList.add(new Watchpoint(this, newMIBreakpoints[i]));
                } else {
                    this.breakList.add(new Breakpoint(this, newMIBreakpoints[i]));
                }
                eventList.add(new MIBreakpointCreatedEvent(no));
            }
            ++i;
        }
        Breakpoint[] oldBreakpoints = this.breakList.toArray(new Breakpoint[0]);
        int i2 = 0;
        while (i2 < oldBreakpoints.length) {
            boolean found = false;
            int no = oldBreakpoints[i2].getMIBreakpoint().getNumber();
            int j = 0;
            while (j < newMIBreakpoints.length) {
                if (no == newMIBreakpoints[j].getNumber()) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                eventList.add(new MIBreakpointDeletedEvent(no));
            }
            ++i2;
        }
        MISession mi = ((Session)this.getSession()).getMISession();
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public void allowProgramInterruption(boolean e) {
        this.allowInterrupt = e;
    }

    public void deleteAllBreakpoints() throws CDIException {
        this.deleteBreakpoints(this.getBreakpoints());
    }

    public void deleteBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        this.deleteBreakpoints(new ICDIBreakpoint[]{breakpoint});
    }

    public void deleteFromDeferredList(Breakpoint bkpt) {
        this.deferredList.remove(bkpt);
    }

    public void addToBreakpointList(Breakpoint bkpt) {
        this.breakList.add(bkpt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteBreakpoints(ICDIBreakpoint[] breakpoints) throws CDIException {
        int[] numbers = new int[breakpoints.length];
        int i = 0;
        while (i < numbers.length) {
            if (breakpoints[i] instanceof Breakpoint && this.breakList.contains(breakpoints[i])) {
                numbers[i] = ((Breakpoint)breakpoints[i]).getMIBreakpoint().getNumber();
                ++i;
                continue;
            }
            throw new CDIException("Not a CDT breakpoint");
        }
        Session session = (Session)this.getSession();
        boolean state = this.suspendInferior(session.getCurrentTarget());
        CommandFactory factory = session.getMISession().getCommandFactory();
        MIBreakDelete breakDelete = factory.createMIBreakDelete(numbers);
        try {
            try {
                session.getMISession().postCommand(breakDelete);
                MIInfo info = breakDelete.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            Object var8_14 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.resumeInferior(session.getCurrentTarget(), state);
            throw throwable;
        }
        this.resumeInferior(session.getCurrentTarget(), state);
        ArrayList<MIBreakpointDeletedEvent> eventList = new ArrayList<MIBreakpointDeletedEvent>(breakpoints.length);
        int i2 = 0;
        while (i2 < breakpoints.length) {
            int no = ((Breakpoint)breakpoints[i2]).getMIBreakpoint().getNumber();
            eventList.add(new MIBreakpointDeletedEvent(no));
            ++i2;
        }
        MISession mi = session.getMISession();
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public ICDIBreakpoint[] getBreakpoints() throws CDIException {
        return this.breakList.toArray(new ICDIBreakpoint[0]);
    }

    public ICDIBreakpoint[] getDeferredBreakpoints() throws CDIException {
        return this.deferredList.toArray(new ICDIBreakpoint[0]);
    }

    public ICDICatchpoint setCatchpoint(int type, ICDICatchEvent event, String expression, ICDICondition condition) throws CDIException {
        throw new CDIException("Not Supported");
    }

    public ICDILocationBreakpoint setLocationBreakpoint(int type, ICDILocation location, ICDICondition condition, String threadId) throws CDIException {
        return this.setLocationBreakpoint(type, location, condition, threadId, false);
    }

    public ICDILocationBreakpoint setLocationBreakpoint(int type, ICDILocation location, ICDICondition condition, String threadId, boolean deferred) throws CDIException {
        Breakpoint bkpt;
        block4: {
            bkpt = new Breakpoint(this, type, location, condition, threadId);
            try {
                this.setLocationBreakpoint(bkpt);
                this.breakList.add(bkpt);
                Session session = (Session)this.getSession();
                MISession mi = session.getMISession();
                mi.fireEvent(new MIBreakpointCreatedEvent(bkpt.getMIBreakpoint().getNumber()));
            }
            catch (CDIException e) {
                if (!deferred) {
                    throw e;
                }
                Session session = (Session)this.getSession();
                ICDISharedLibraryManager sharedMgr = session.getSharedLibraryManager();
                if (!(sharedMgr instanceof SharedLibraryManager)) break block4;
                SharedLibraryManager mgr = (SharedLibraryManager)sharedMgr;
                if (mgr.isDeferredBreakpoint()) {
                    this.deferredList.add(bkpt);
                }
                throw e;
            }
        }
        return bkpt;
    }

    MIBreakInsert createMIBreakInsert(Breakpoint bkpt) throws CDIException {
        boolean hardware = bkpt.isHardware();
        boolean temporary = bkpt.isTemporary();
        String exprCond = null;
        int ignoreCount = 0;
        StringBuffer line = new StringBuffer();
        if (bkpt.getCondition() != null) {
            ICDICondition condition = bkpt.getCondition();
            exprCond = condition.getExpression();
            ignoreCount = condition.getIgnoreCount();
        }
        if (bkpt.getLocation() != null) {
            ICDILocation location = bkpt.getLocation();
            String file = location.getFile();
            String function = location.getFunction();
            if (file != null && file.length() > 0) {
                line.append(file).append(':');
                if (function != null && function.length() > 0) {
                    line.append(function);
                } else {
                    line.append(location.getLineNumber());
                }
            } else if (function != null && function.length() > 0) {
                line.append(function);
            } else if (location.getLineNumber() != 0) {
                line.append(location.getLineNumber());
            } else {
                line.append('*').append(location.getAddress());
            }
        }
        Session session = (Session)this.getSession();
        CommandFactory factory = session.getMISession().getCommandFactory();
        return factory.createMIBreakInsert(temporary, hardware, exprCond, ignoreCount, line.toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLocationBreakpoint(Breakpoint bkpt) throws CDIException {
        Session session = (Session)this.getSession();
        boolean state = this.suspendInferior(session.getCurrentTarget());
        MIBreakInsert breakInsert = this.createMIBreakInsert(bkpt);
        MIBreakpoint[] points = null;
        try {
            try {
                session.getMISession().postCommand(breakInsert);
                MIBreakInsertInfo info = breakInsert.getMIBreakInsertInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                points = info.getMIBreakpoints();
                if (points == null || points.length == 0) {
                    throw new CDIException("Error parsing");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.resumeInferior(session.getCurrentTarget(), state);
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        this.resumeInferior(session.getCurrentTarget(), state);
        bkpt.setMIBreakpoint(points[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIWatchpoint setWatchpoint(int type, int watchType, String expression, ICDICondition condition) throws CDIException {
        boolean access = (watchType & 1) == 1 && (watchType & 2) == 2;
        boolean read = (watchType & 1) != 1 && (watchType & 2) == 2;
        Session session = (Session)this.getSession();
        boolean state = this.suspendInferior(session.getCurrentTarget());
        CommandFactory factory = session.getMISession().getCommandFactory();
        MIBreakWatch breakWatch = factory.createMIBreakWatch(access, read, expression);
        MIBreakpoint[] points = null;
        try {
            try {
                session.getMISession().postCommand(breakWatch);
                MIBreakWatchInfo info = breakWatch.getMIBreakWatchInfo();
                points = info.getMIBreakpoints();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                if (points == null || points.length == 0) {
                    throw new CDIException("Parsing Error");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.resumeInferior(session.getCurrentTarget(), state);
            throw throwable;
        }
        {
            Object var13_16 = null;
        }
        this.resumeInferior(session.getCurrentTarget(), state);
        Watchpoint bkpt = new Watchpoint(this, points[0]);
        this.breakList.add(bkpt);
        MISession mi = session.getMISession();
        mi.fireEvent(new MIBreakpointCreatedEvent(bkpt.getMIBreakpoint().getNumber()));
        return bkpt;
    }

    public ICDICondition createCondition(int ignoreCount, String expression) {
        return new Condition(ignoreCount, expression);
    }

    public ICDILocation createLocation(String file, String function, int line) {
        return new Location(file, function, line);
    }

    public ICDILocation createLocation(long address) {
        return new Location(address);
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean update) {
        this.autoupdate = update;
    }
}

