/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataWriteMemory;
import org.eclipse.cdt.debug.mi.core.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIMemory;

public class MemoryBlock
extends CObject
implements ICDIMemoryBlock {
    MIDataReadMemoryInfo mem;
    String expression;
    boolean frozen;
    boolean dirty;

    public MemoryBlock(ICDITarget target, String exp, MIDataReadMemoryInfo info) {
        super(target);
        this.expression = exp;
        this.mem = info;
        this.frozen = true;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setMIDataReadMemoryInfo(MIDataReadMemoryInfo m) {
        this.mem = m;
    }

    public MIDataReadMemoryInfo getMIDataReadMemoryInfo() {
        return this.mem;
    }

    public boolean contains(Long[] adds) {
        int i = 0;
        while (i < adds.length) {
            if (this.contains(adds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(Long addr) {
        long start = this.getStartAddress();
        long length = this.getLength();
        return start <= addr && addr <= start + length;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean d) {
        this.dirty = d;
    }

    public byte[] getBytes() throws CDIException {
        MIMemory[] miMem = this.mem.getMemories();
        ArrayList<Long> aList = new ArrayList<Long>();
        int i = 0;
        while (i < miMem.length) {
            long[] data = miMem[i].getData();
            int j = 0;
            while (j < data.length) {
                aList.add(new Long(data[j]));
                ++j;
            }
            ++i;
        }
        byte[] bytes = new byte[aList.size()];
        int i2 = 0;
        while (i2 < aList.size()) {
            Long l = (Long)aList.get(i2);
            bytes[i2] = l.byteValue();
            ++i2;
        }
        return bytes;
    }

    public void refresh() throws CDIException {
        MemoryManager mgr = (MemoryManager)this.getTarget().getSession().getMemoryManager();
        this.setDirty(true);
        Long[] addresses = mgr.update(this, null);
        if (addresses.length > 0) {
            MemoryBlock[] blocks = mgr.listMemoryBlocks();
            int i = 0;
            while (i < blocks.length) {
                if (!blocks[i].equals(this) && blocks[i].contains(addresses)) {
                    blocks[i].setDirty(true);
                    mgr.update(blocks[i], null);
                }
                ++i;
            }
        }
    }

    public long getLength() {
        return this.mem.getTotalBytes();
    }

    public long getStartAddress() {
        return this.mem.getAddress();
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public void setValue(long offset, byte[] bytes) throws CDIException {
        if (offset >= this.getLength() || offset + (long)bytes.length > this.getLength()) {
            throw new CDIException("Bad Offset");
        }
        Session session = (Session)this.getTarget().getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        int i = 0;
        while (i < bytes.length) {
            long l = new Byte(bytes[i]).longValue() & 0xFFL;
            String value = "0x" + Long.toHexString(l);
            MIDataWriteMemory mw = factory.createMIDataWriteMemory(offset + (long)i, this.expression, 0, 1, value);
            try {
                mi.postCommand(mw);
                MIInfo info = mw.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            ++i;
        }
        this.refresh();
    }
}

