/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgument;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;

public class StackFrame
extends CObject
implements ICDIStackFrame {
    MIFrame frame;
    Thread cthread;
    int level;
    ICDIArgument[] args;
    ICDIVariable[] locals;

    public StackFrame(Thread thread, MIFrame f, int l) {
        super(thread.getTarget());
        this.cthread = thread;
        this.frame = f;
        this.level = l;
    }

    public MIFrame getMIFrame() {
        return this.frame;
    }

    public ICDIThread getThread() {
        return this.cthread;
    }

    public ICDIArgument[] getArguments() throws CDIException {
        if (this.args == null) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = (VariableManager)session.getVariableManager();
            ICDIArgumentObject[] argObjs = mgr.getArgumentObjects(this);
            this.args = new ICDIArgument[argObjs.length];
            int i = 0;
            while (i < this.args.length) {
                try {
                    this.args[i] = mgr.createArgument(argObjs[i]);
                }
                catch (CDIException e) {
                    this.args = null;
                    throw e;
                }
                ++i;
            }
        }
        return this.args;
    }

    public ICDIVariable[] getLocalVariables() throws CDIException {
        if (this.locals == null) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = (VariableManager)session.getVariableManager();
            ICDIVariableObject[] varObjs = mgr.getLocalVariableObjects(this);
            this.locals = new ICDIVariable[varObjs.length];
            int i = 0;
            while (i < this.locals.length) {
                try {
                    this.locals[i] = mgr.createVariable(varObjs[i]);
                }
                catch (CDIException e) {
                    this.locals = null;
                    throw e;
                }
                ++i;
            }
        }
        return this.locals;
    }

    public ICDILocation getLocation() {
        if (this.frame != null) {
            return new Location(this.frame.getFile(), this.frame.getFunction(), this.frame.getLine(), this.frame.getAddress());
        }
        return new Location("", "", 0, 0L);
    }

    public int getLevel() {
        return this.level;
    }

    public boolean equals(ICDIStackFrame stackframe) {
        if (stackframe instanceof StackFrame) {
            StackFrame stack = (StackFrame)stackframe;
            return this.cthread != null && this.cthread.equals(stack.getThread()) && this.getLevel() == stack.getLevel() && this.getLocation().equals(stack.getLocation());
        }
        return super.equals(stackframe);
    }
}

