/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.io.StringWriter;
import org.eclipse.cdt.internal.ui.cview.CElementFilters;
import org.eclipse.cdt.internal.ui.cview.CPatternFilter;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.FiltersContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;

class FilterSelectionAction
extends SelectionProviderAction {
    private CView cview;
    private Shell shell;

    public FilterSelectionAction(Shell shell, CView cview, String label) {
        super((ISelectionProvider)cview.getViewer(), label);
        this.setToolTipText("Filter Selection Action");
        this.setEnabled(true);
        this.shell = shell;
        this.cview = cview;
    }

    public void run() {
        CPatternFilter filter = this.cview.getPatternFilter();
        FiltersContentProvider contentProvider = new FiltersContentProvider(filter);
        ListSelectionDialog dialog = new ListSelectionDialog(this.shell, (Object)this.cview.getViewer(), (IStructuredContentProvider)contentProvider, (ILabelProvider)new LabelProvider(), "Select the filters to apply (matching files will be hidden):");
        dialog.setInitialSelections((Object[])contentProvider.getInitialSelections());
        dialog.setTitle("C/C++ File Filters");
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            Object[] results = dialog.getResult();
            String[] selectedPatterns = new String[results.length];
            System.arraycopy(results, 0, selectedPatterns, 0, results.length);
            filter.setPatterns(selectedPatterns);
            CElementFilters.setPatterns(selectedPatterns);
            this.saveInPreferences(selectedPatterns);
            TreeViewer viewer = this.cview.getViewer();
            viewer.getControl().setRedraw(false);
            viewer.refresh();
            viewer.getControl().setRedraw(true);
        }
    }

    private void saveInPreferences(String[] patterns) {
        CUIPlugin plugin = CUIPlugin.getDefault();
        StringWriter writer = new StringWriter();
        int i = 0;
        while (i < patterns.length) {
            writer.write(patterns[i]);
            writer.write(CPatternFilter.COMMA_SEPARATOR);
            ++i;
        }
        plugin.getPreferenceStore().setValue(CPatternFilter.FILTERS_TAG, writer.toString());
    }
}

