/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public class OpenIncludeAction
extends Action {
    private static final String PREFIX = "OpenIncludeAction.";
    private static final String DIALOG_TITLE = "OpenIncludeAction.dialog.title";
    private static final String DIALOG_MESSAGE = "OpenIncludeAction.dialog.message";
    private ISelectionProvider fSelectionProvider;

    public OpenIncludeAction(ISelectionProvider provider) {
        super(CUIPlugin.getResourceString("OpenIncludeAction.label"));
        this.setDescription(CUIPlugin.getResourceString("OpenIncludeAction.description"));
        this.setToolTipText(CUIPlugin.getResourceString("OpenIncludeAction.tooltip"));
        CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.open_incl.gif");
        this.fSelectionProvider = provider;
    }

    public void run() {
        ICElement include = OpenIncludeAction.getIncludeStatement(this.fSelectionProvider.getSelection());
        if (include == null) {
            return;
        }
        try {
            int nElementsFound;
            IPath fileToOpen;
            IResource res = include.getUnderlyingResource();
            ArrayList filesFound = new ArrayList(4);
            if (res != null) {
                IProject proj = res.getProject();
                String includeName = include.getElementName();
                IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(proj);
                if (provider != null) {
                    IScannerInfo info = provider.getScannerInformation(res);
                    if (info == null) {
                        info = provider.getScannerInformation((IResource)proj);
                    }
                    if (info != null) {
                        String[] includePaths = info.getIncludePaths();
                        this.findFile(includePaths, includeName, filesFound);
                    }
                    if (filesFound.size() == 0) {
                        this.findFile((IContainer)proj, (IPath)new Path(includeName), filesFound);
                    }
                }
            }
            if ((fileToOpen = (nElementsFound = filesFound.size()) == 0 ? null : (nElementsFound == 1 ? (IPath)filesFound.get(0) : this.chooseFile(filesFound))) != null) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(fileToOpen);
                if (file != null) {
                    EditorUtility.openInEditor(file);
                } else {
                    FileStorage storage = new FileStorage(null, fileToOpen);
                    EditorUtility.openInEditor(storage);
                }
            }
        }
        catch (CModelException e) {
            CUIPlugin.getDefault().log(e.getStatus());
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e.getStatus());
        }
    }

    private void findFile(String[] includePaths, String name, ArrayList list) throws CoreException {
        int i = 0;
        while (i < includePaths.length) {
            Path path = new Path(String.valueOf(includePaths[i]) + "/" + name);
            File file = path.toFile();
            if (file.exists()) {
                list.add(path);
            }
            ++i;
        }
    }

    private void findFile(IContainer parent, final IPath name, final ArrayList list) throws CoreException {
        parent.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 1 && proxy.getName().equalsIgnoreCase(name.lastSegment())) {
                    list.add(proxy.requestResource().getLocation());
                    return false;
                }
                return true;
            }
        }, 0);
    }

    private IPath chooseFile(ArrayList filesFound) {
        LabelProvider renderer = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IPath) {
                    IPath file = (IPath)element;
                    return String.valueOf(file.lastSegment()) + " - " + file.toString();
                }
                return super.getText(element);
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(CUIPlugin.getDefault().getActiveWorkbenchShell(), (ILabelProvider)renderer, false, false);
        dialog.setTitle(CUIPlugin.getResourceString(DIALOG_TITLE));
        dialog.setMessage(CUIPlugin.getResourceString(DIALOG_MESSAGE));
        dialog.setElements(filesFound);
        if (dialog.open() == 0) {
            return (IPath)dialog.getSelectedElement();
        }
        return null;
    }

    private static ICElement getIncludeStatement(ISelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (element = list.get(0)) instanceof ICElement && ((ICElement)element).getElementType() == 72) {
            return (ICElement)element;
        }
        return null;
    }

    public static boolean canActionBeAdded(ISelection selection) {
        IResource res;
        ICElement include = OpenIncludeAction.getIncludeStatement(selection);
        return include != null && (res = include.getUnderlyingResource()) != null;
    }

    public static String getEditorID(String name) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        if (registry != null) {
            IEditorDescriptor descriptor = registry.getDefaultEditor(name);
            if (descriptor != null) {
                return descriptor.getId();
            }
            return registry.getDefaultEditor().getId();
        }
        return null;
    }
}

