/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.ui.controls;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RadioButtonsArea
extends Composite {
    private String[][] labelsAndValues;
    private int numColumns;
    protected String value = null;
    private SelectionListener listener;
    private ArrayList externalListeners = new ArrayList();
    private Composite area = null;
    protected Button[] radioButtons;

    public RadioButtonsArea(Composite parent, String labelText, int numColumns, String[][] labelAndValues) {
        super(parent, 0);
        Assert.isTrue((boolean)this.checkArray(labelAndValues));
        this.labelsAndValues = labelAndValues;
        this.numColumns = numColumns;
        this.createControl(parent, labelText);
    }

    public void setEnabled(boolean enabled) {
        int i = 0;
        while (i < this.radioButtons.length) {
            this.radioButtons[i].setEnabled(enabled);
            ++i;
        }
    }

    private boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        int i = 0;
        while (i < table.length) {
            String[] array = table[i];
            if (array == null || array.length != 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void fireSelectionEvent(SelectionEvent event) {
        Iterator i = ((AbstractList)this.externalListeners).iterator();
        while (i.hasNext()) {
            SelectionListener s = (SelectionListener)i.next();
            s.widgetSelected(event);
        }
    }

    protected void createControl(Composite parent, String labelText) {
        GridLayout gl = new GridLayout();
        this.setLayoutData(new GridData(768));
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        this.setLayout((Layout)gl);
        this.area = labelText != null ? ControlFactory.createGroup(this, labelText, this.numColumns) : this;
        this.radioButtons = new Button[this.labelsAndValues.length];
        this.listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RadioButtonsArea.this.value = (String)event.widget.getData();
                RadioButtonsArea.this.fireSelectionEvent(event);
            }
        };
        int i = 0;
        while (i < this.labelsAndValues.length) {
            this.radioButtons[i] = ControlFactory.createRadioButton(this.area, this.labelsAndValues[i][0], this.labelsAndValues[i][1], this.listener);
            ++i;
        }
        this.area.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                RadioButtonsArea.this.radioButtons = null;
            }
        });
    }

    public void setIndent(int indent) {
        if (this.area == null) {
            return;
        }
        if (indent < 0) {
            indent = 0;
        }
        int i = 0;
        while (i < this.radioButtons.length) {
            ((GridData)this.radioButtons[i].getLayoutData()).horizontalIndent = indent;
            ++i;
        }
    }

    public void setSelectValue(String selectedValue) {
        this.value = selectedValue;
        if (this.radioButtons == null) {
            return;
        }
        if (this.value != null) {
            boolean found = false;
            int i = 0;
            while (i < this.radioButtons.length) {
                Button radio = this.radioButtons[i];
                boolean selection = false;
                if (((String)radio.getData()).equals(this.value)) {
                    selection = true;
                    found = true;
                }
                radio.setSelection(selection);
                ++i;
            }
            if (found) {
                return;
            }
        }
        if (this.radioButtons.length > 0) {
            this.radioButtons[0].setSelection(true);
            this.value = (String)this.radioButtons[0].getData();
        }
    }

    public void setSelectedButton(int index) {
        Button b;
        if (index < 0 || index >= this.radioButtons.length) {
            return;
        }
        int i = 0;
        while (i < this.radioButtons.length) {
            b = this.radioButtons[i];
            boolean selected = b.getSelection();
            if (i == index) {
                if (selected) {
                    return;
                }
            } else if (selected) {
                b.setSelection(false);
            }
            ++i;
        }
        b = this.radioButtons[index];
        b.setSelection(true);
    }

    public String getSelectedValue() {
        return this.value;
    }

    public int getSeletedIndex() {
        if (this.radioButtons == null) {
            return -1;
        }
        if (this.value != null) {
            int i = 0;
            while (i < this.radioButtons.length) {
                if (((String)this.radioButtons[i].getData()).equals(this.value)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void addSelectionListener(SelectionListener s) {
        if (this.externalListeners.contains(s)) {
            return;
        }
        this.externalListeners.add(s);
    }
}

