/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.sharedlibs;

import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.ICSharedLibraryManager;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.internal.ui.CDTDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.actions.AutoRefreshAction;
import org.eclipse.cdt.debug.internal.ui.actions.LoadSymbolsForAllAction;
import org.eclipse.cdt.debug.internal.ui.actions.RefreshAction;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.sharedlibs.SharedLibrariesViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.sharedlibs.SharedLibrariesViewEventHandler;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.IUpdate;

public class SharedLibrariesView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler {
    static /* synthetic */ Class class$0;

    protected Viewer createViewer(Composite parent) {
        TableTreeViewer viewer = new TableTreeViewer(parent, 66306);
        Table table = viewer.getTableTree().getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        TableColumn[] columns = table.getColumns();
        columns[1].setResizable(true);
        columns[2].setResizable(true);
        columns[3].setResizable(true);
        columns[0].setText("");
        columns[1].setText("Name");
        columns[2].setText("Start Address");
        columns[3].setText("End Address");
        PixelConverter pc = new PixelConverter((Control)parent);
        columns[0].setWidth(pc.convertWidthInCharsToPixels(3));
        columns[1].setWidth(pc.convertWidthInCharsToPixels(50));
        columns[2].setWidth(pc.convertWidthInCharsToPixels(20));
        columns[3].setWidth(pc.convertWidthInCharsToPixels(20));
        viewer.setContentProvider((IContentProvider)new SharedLibrariesViewContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new SharedLibrariesLabelProvider());
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(this.createEventHandler((Viewer)viewer));
        return viewer;
    }

    protected void createActions() {
        Action action = new AutoRefreshAction(this.getViewer(), "Auto-Refresh");
        CDebugImages.setLocalImageDescriptors((IAction)action, "org.eclipse.cdt.debug.ui.autorefresh_mem.gif");
        action.setDescription("Automatically Refresh Shared Libraries View");
        action.setToolTipText("Auto-Refresh");
        WorkbenchHelp.setHelp((IAction)action, (String)ICDebugHelpContextIds.AUTO_REFRESH_SHARED_LIBRARIES_ACTION);
        action.setEnabled(false);
        this.setAction("AutoRefresh", (IAction)action);
        this.add((IUpdate)action);
        action = new RefreshAction(this.getViewer(), "Refresh");
        CDebugImages.setLocalImageDescriptors((IAction)action, "org.eclipse.cdt.debug.ui.refresh_mem.gif");
        action.setDescription("Refresh Shared Libraries View");
        action.setToolTipText("Refresh");
        WorkbenchHelp.setHelp((IAction)action, (String)ICDebugHelpContextIds.REFRESH_SHARED_LIBRARIES_ACTION);
        action.setEnabled(false);
        this.setAction("Refresh", (IAction)action);
        this.add((RefreshAction)action);
        action = new LoadSymbolsForAllAction(this.getViewer());
        action.setEnabled(false);
        this.setAction("LoadSymbolsForAll", (IAction)action);
        this.add((LoadSymbolsForAllAction)action);
        this.setInitialContent();
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.SHARED_LIBRARIES_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        this.updateObjects();
        menu.add((IContributionItem)new Separator("emptySharedLibrariesGroup"));
        menu.add((IContributionItem)new Separator("sharedLibrariesGroup"));
        menu.add((IContributionItem)new Separator("emptyRefreshGroup"));
        menu.add((IContributionItem)new Separator("refreshGroup"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.appendToGroup("sharedLibrariesGroup", this.getAction("LoadSymbolsForAll"));
        menu.appendToGroup("refreshGroup", this.getAction("AutoRefresh"));
        menu.appendToGroup("refreshGroup", this.getAction("Refresh"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator(this.getClass().getName()));
        tbm.add((IContributionItem)new Separator("sharedLibrariesGroup"));
        tbm.add(this.getAction("LoadSymbolsForAll"));
        tbm.add((IContributionItem)new Separator("refreshGroup"));
        tbm.add(this.getAction("AutoRefresh"));
        tbm.add(this.getAction("Refresh"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)selection);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void handleException(DebugException e) {
    }

    protected void setViewerInput(IStructuredSelection ssel) {
        Object input;
        ICSharedLibraryManager slm = null;
        if (ssel != null && ssel.size() == 1 && (input = ssel.getFirstElement()) instanceof IDebugElement) {
            IDebugTarget iDebugTarget = ((IDebugElement)input).getDebugTarget();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.cdt.debug.core.ICSharedLibraryManager;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            slm = (ICSharedLibraryManager)iDebugTarget.getAdapter((Class)clazz);
        }
        if (this.getViewer() == null) {
            return;
        }
        Object current = this.getViewer().getInput();
        if (current != null && current.equals(slm)) {
            this.updateObjects();
            return;
        }
        this.showViewer();
        this.getViewer().setInput(slm);
        this.updateObjects();
    }

    protected void setInitialContent() {
        ISelection selection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.setViewerInput((IStructuredSelection)selection);
        } else {
            this.setViewerInput(null);
        }
    }

    protected AbstractDebugEventHandler createEventHandler(Viewer viewer) {
        return new SharedLibrariesViewEventHandler(this);
    }

    public class SharedLibrariesLabelProvider
    extends CDTDebugModelPresentation
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof ICSharedLibrary && columnIndex == 1) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ICSharedLibrary) {
                ICSharedLibrary library = (ICSharedLibrary)element;
                switch (columnIndex) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return this.getText(element);
                    }
                    case 2: {
                        return library.getStartAddress() > 0L ? CDebugUtils.toHexAddressString((long)library.getStartAddress()) : "";
                    }
                    case 3: {
                        return library.getEndAddress() > 0L ? CDebugUtils.toHexAddressString((long)library.getEndAddress()) : "";
                    }
                }
            }
            return null;
        }
    }
}

