/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionComboFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionListFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.managedbuilder.ui.properties.SummaryFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Point;

public class BuildToolSettingsPage
extends FieldEditorPreferencePage {
    private IConfiguration configuration;
    private IOptionCategory category;

    BuildToolSettingsPage(IConfiguration configuration, IOptionCategory category) {
        super(1);
        this.noDefaultAndApplyButton();
        this.configuration = configuration;
        this.category = category;
    }

    public Point computeSize() {
        return super.computeSize();
    }

    protected void createFieldEditors() {
        IPreferenceStore settings = this.getPreferenceStore();
        this.setPreferenceStore(settings);
        IOption[] options = this.category.getOptions(this.configuration);
        int index = 0;
        while (index < options.length) {
            IOption opt = options[index];
            switch (opt.getValueType()) {
                case 2: {
                    StringFieldEditor stringField = new StringFieldEditor(opt.getId(), opt.getName(), this.getFieldEditorParent());
                    this.addField((FieldEditor)stringField);
                    break;
                }
                case 0: {
                    BooleanFieldEditor booleanField = new BooleanFieldEditor(opt.getId(), opt.getName(), this.getFieldEditorParent());
                    this.addField((FieldEditor)booleanField);
                    break;
                }
                case 1: {
                    String sel;
                    try {
                        sel = opt.getSelectedEnum();
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    BuildOptionComboFieldEditor comboField = new BuildOptionComboFieldEditor(opt.getId(), opt.getName(), opt.getApplicableValues(), sel, this.getFieldEditorParent());
                    this.addField(comboField);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    BuildOptionListFieldEditor listField = new BuildOptionListFieldEditor(opt.getId(), opt.getName(), this.getFieldEditorParent());
                    this.addField(listField);
                    break;
                }
                default: {
                    SummaryFieldEditor summaryField = new SummaryFieldEditor(opt.getId(), opt.getName(), this.category.getTool(), this.getFieldEditorParent());
                    this.addField(summaryField);
                }
            }
            ++index;
        }
    }

    public IOptionCategory getCategory() {
        return this.category;
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        IOption[] options = this.category.getOptions(this.configuration);
        int i = 0;
        while (i < options.length) {
            IOption option = options[i];
            switch (option.getValueType()) {
                case 0: {
                    boolean boolVal = this.getPreferenceStore().getBoolean(option.getId());
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)option, (boolean)boolVal);
                    break;
                }
                case 1: {
                    String enumVal = this.getPreferenceStore().getString(option.getId());
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)option, (String)enumVal);
                    break;
                }
                case 2: {
                    String strVal = this.getPreferenceStore().getString(option.getId());
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)option, (String)strVal);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    String listStr = this.getPreferenceStore().getString(option.getId());
                    String[] listVal = BuildToolsSettingsStore.parseString(listStr);
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)option, (String[])listVal);
                    break;
                }
            }
            ++i;
        }
        return ok;
    }
}

