/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.DerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.SpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.TemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class ParserSymbolTable {
    public static final String EMPTY_NAME = "";
    public static final String THIS = "this";
    private IContainerSymbol _compilationUnit;
    private ParserLanguage _language;
    private LinkedList undoList = new LinkedList();
    private HashSet markSet = new HashSet();

    public ParserSymbolTable(ParserLanguage language) {
        this._compilationUnit = this.newContainerSymbol(EMPTY_NAME, TypeInfo.t_namespace);
        this._language = language;
    }

    public IContainerSymbol getCompilationUnit() {
        return this._compilationUnit;
    }

    public IContainerSymbol newContainerSymbol(String name) {
        return new ContainerSymbol(this, name);
    }

    public IContainerSymbol newContainerSymbol(String name, TypeInfo.eType type) {
        return new ContainerSymbol(this, name, type);
    }

    public ISymbol newSymbol(String name) {
        return new BasicSymbol(this, name);
    }

    public ISymbol newSymbol(String name, TypeInfo.eType type) {
        return new BasicSymbol(this, name, type);
    }

    public IDerivableContainerSymbol newDerivableContainerSymbol(String name) {
        return new DerivableContainerSymbol(this, name);
    }

    public IDerivableContainerSymbol newDerivableContainerSymbol(String name, TypeInfo.eType type) {
        return new DerivableContainerSymbol(this, name, type);
    }

    public IParameterizedSymbol newParameterizedSymbol(String name) {
        return new ParameterizedSymbol(this, name);
    }

    public IParameterizedSymbol newParameterizedSymbol(String name, TypeInfo.eType type) {
        return new ParameterizedSymbol(this, name, type);
    }

    public ISpecializedSymbol newSpecializedSymbol(String name) {
        return new SpecializedSymbol(this, name);
    }

    protected static void lookup(LookupData data, IContainerSymbol inSymbol) throws ParserSymbolTableException {
        ISymbol symbol;
        if (data.type != TypeInfo.t_any && data.type.compareTo(TypeInfo.t_class) < 0 && data.upperType.compareTo(TypeInfo.t_union) > 0) {
            throw new ParserSymbolTableException(1);
        }
        if (inSymbol.isType(TypeInfo.t_namespace) && (symbol = inSymbol.getTypeSymbol()) != null && symbol.isType(TypeInfo.t_namespace)) {
            inSymbol = (IContainerSymbol)symbol;
        }
        symbol = null;
        LinkedList transitives = new LinkedList();
        ParserSymbolTable.lookupInContained(data, inSymbol);
        if (inSymbol.getSymbolTable().getLanguage() == ParserLanguage.CPP && !data.ignoreUsingDirectives) {
            data.visited.clear();
            ParserSymbolTable.lookupInNominated(data, inSymbol, transitives);
            if (!data.qualified || data.foundItems == null) {
                ParserSymbolTable.processDirectives(inSymbol, data, transitives);
                if (inSymbol.hasUsingDirectives()) {
                    ParserSymbolTable.processDirectives(inSymbol, data, inSymbol.getUsingDirectives());
                }
                while (data.usingDirectives != null && data.usingDirectives.get(inSymbol) != null) {
                    transitives.clear();
                    ParserSymbolTable.lookupInNominated(data, inSymbol, transitives);
                    if (data.qualified && data.foundItems != null) continue;
                    ParserSymbolTable.processDirectives(inSymbol, data, transitives);
                }
            }
        }
        if (data.foundItems != null || data.stopAt == inSymbol) {
            return;
        }
        if (inSymbol instanceof IDerivableContainerSymbol) {
            data.visited.clear();
            symbol = ParserSymbolTable.lookupInParents(data, (IDerivableContainerSymbol)inSymbol);
            if (symbol != null) {
                data.foundItems.add(symbol);
            }
        }
        if (data.foundItems == null && inSymbol.getContainingSymbol() != null) {
            ParserSymbolTable.lookup(data, inSymbol.getContainingSymbol());
        }
    }

    private static void lookupInNominated(LookupData data, IContainerSymbol symbol, LinkedList transitiveDirectives) {
        if (data.usingDirectives == null) {
            return;
        }
        LinkedList directives = null;
        Iterator iter = null;
        IContainerSymbol temp = null;
        boolean foundSomething = false;
        int size = 0;
        directives = (LinkedList)data.usingDirectives.remove(symbol);
        if (directives == null) {
            return;
        }
        iter = directives.iterator();
        int i = size = directives.size();
        while (i > 0) {
            temp = (IContainerSymbol)iter.next();
            if (!data.visited.contains(temp)) {
                data.visited.add(temp);
                foundSomething = ParserSymbolTable.lookupInContained(data, temp);
                if (!(data.qualified && foundSomething || temp.getUsingDirectives() == null)) {
                    transitiveDirectives.addAll(temp.getUsingDirectives());
                }
            }
            --i;
        }
    }

    protected static boolean lookupInContained(LookupData data, IContainerSymbol lookIn) {
        Map parameters;
        Map declarations;
        boolean foundSomething = false;
        ISymbol temp = null;
        Object obj = null;
        if (data.associated != null) {
            data.associated.remove(lookIn);
        }
        Object v0 = obj = (declarations = lookIn.getContainedSymbols()) != null ? declarations.get(data.name) : null;
        if (obj != null) {
            if (obj instanceof ISymbol) {
                temp = obj;
                if (ParserSymbolTable.checkType(data, temp, data.type, data.upperType)) {
                    if (data.foundItems == null) {
                        data.foundItems = new HashSet();
                    }
                    if (temp.isTemplateMember()) {
                        data.foundItems.add(new TemplateInstance(temp.getSymbolTable(), temp, data.templateInstance.getArgumentMap()));
                    } else {
                        data.foundItems.add(temp);
                    }
                    foundSomething = true;
                }
            } else {
                LinkedList objList = obj;
                Iterator iter = objList.iterator();
                int size = objList.size();
                int i = 0;
                while (i < size) {
                    temp = (ISymbol)iter.next();
                    if (ParserSymbolTable.checkType(data, temp, data.type, data.upperType)) {
                        if (data.foundItems == null) {
                            data.foundItems = new HashSet();
                        }
                        if (temp.isTemplateMember()) {
                            data.foundItems.add(new TemplateInstance(temp.getSymbolTable(), temp, data.templateInstance.getArgumentMap()));
                        } else {
                            data.foundItems.add(temp);
                        }
                        foundSomething = true;
                    }
                    ++i;
                }
            }
        }
        if (foundSomething) {
            return foundSomething;
        }
        if (lookIn instanceof IParameterizedSymbol && (parameters = ((IParameterizedSymbol)lookIn).getParameterMap()) != null && (obj = parameters.get(data.name)) != null && ParserSymbolTable.checkType(data, obj, data.type, data.upperType)) {
            ISymbol symbol;
            if (data.foundItems == null) {
                data.foundItems = new HashSet();
            }
            if ((symbol = (ISymbol)obj).isTemplateMember() && data.templateInstance != null) {
                data.foundItems.add(new TemplateInstance(symbol.getSymbolTable(), symbol, data.templateInstance.getArgumentMap()));
            } else {
                data.foundItems.add(symbol);
            }
            foundSomething = true;
        }
        return foundSomething;
    }

    private static boolean checkType(LookupData data, ISymbol symbol, TypeInfo.eType type, TypeInfo.eType upperType) {
        if (data.templateInstance != null && symbol.isTemplateMember()) {
            if (symbol.isType(TypeInfo.t_type)) {
                symbol = symbol.getTypeSymbol();
            }
            if (symbol.isType(TypeInfo.t_undef) && symbol.getContainingSymbol().isType(TypeInfo.t_template)) {
                TypeInfo info = (TypeInfo)data.templateInstance.getArgumentMap().get(symbol);
                return info.isType(type, upperType);
            }
        }
        return symbol.isType(type, upperType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ISymbol lookupInParents(LookupData data, ISymbol lookIn) throws ParserSymbolTableException {
        int size;
        IDerivableContainerSymbol container = null;
        if (!(lookIn instanceof IDerivableContainerSymbol)) {
            throw new ParserSymbolTableException(-1);
        }
        container = (IDerivableContainerSymbol)lookIn;
        List scopes = container.getParents();
        ISymbol temp = null;
        ISymbol symbol = null;
        Iterator iterator = null;
        IDerivableContainerSymbol.IParentSymbol wrapper = null;
        if (scopes == null) {
            return null;
        }
        if (data.inheritanceChain == null) {
            data.inheritanceChain = new HashSet();
        }
        data.inheritanceChain.add(container);
        iterator = scopes.iterator();
        int i = size = scopes.size();
        while (i > 0) {
            wrapper = (IDerivableContainerSymbol.IParentSymbol)iterator.next();
            ISymbol parent = wrapper.getParent();
            if (parent.isType(TypeInfo.t_undef) && parent.getContainingSymbol().isType(TypeInfo.t_template)) {
                TypeInfo info = (TypeInfo)data.templateInstance.getArgumentMap().get(parent);
                if (!(info.getTypeSymbol() instanceof IDerivableContainerSymbol)) throw new ParserSymbolTableException(4);
                parent = (IDerivableContainerSymbol)info.getTypeSymbol();
            }
            if (!wrapper.isVirtual() || !data.visited.contains(parent)) {
                if (wrapper.isVirtual()) {
                    data.visited.add(parent);
                }
                if (data.inheritanceChain.contains(parent)) throw new ParserSymbolTableException(2);
                if (parent instanceof TemplateInstance) {
                    ISymbol tempInstance = data.templateInstance;
                    data.templateInstance = (TemplateInstance)parent;
                    ISymbol instance = ((TemplateInstance)parent).getInstantiatedSymbol();
                    if (!(instance instanceof IContainerSymbol)) {
                        throw new ParserSymbolTableException(4);
                    }
                    ParserSymbolTable.lookupInContained(data, (IContainerSymbol)instance);
                    data.templateInstance = tempInstance;
                } else {
                    if (!(parent instanceof IDerivableContainerSymbol)) throw new ParserSymbolTableException(1);
                    ParserSymbolTable.lookupInContained(data, (IDerivableContainerSymbol)parent);
                }
                temp = ParserSymbolTable.resolveAmbiguities(data);
                if (temp == null) {
                    temp = ParserSymbolTable.lookupInParents(data, parent);
                }
            }
            if (temp != null && temp.isType(data.type)) {
                if (symbol == null) {
                    symbol = temp;
                } else if (temp != null) {
                    TypeInfo type = temp.getTypeInfo();
                    if (symbol != temp || !type.checkBit(128) && !type.isType(TypeInfo.t_enumerator)) throw new ParserSymbolTableException(0);
                    temp = null;
                }
            } else {
                temp = null;
            }
            --i;
        }
        data.inheritanceChain.remove(container);
        return symbol;
    }

    protected static boolean isValidOverload(ISymbol origSymbol, ISymbol newSymbol) {
        TypeInfo.eType origType = origSymbol.getType();
        TypeInfo.eType newType = newSymbol.getType();
        if (origSymbol.getTypeInfo().isForwardDeclaration() && origSymbol.getTypeSymbol() == newSymbol) {
            return true;
        }
        if (origType.compareTo(TypeInfo.t_class) >= 0 && origType.compareTo(TypeInfo.t_enumeration) <= 0 && (newType == TypeInfo.t_type || newType.compareTo(TypeInfo.t_function) >= 0)) {
            return true;
        }
        if (origSymbol instanceof IParameterizedSymbol && newSymbol instanceof IParameterizedSymbol) {
            return ParserSymbolTable.isValidFunctionOverload((IParameterizedSymbol)origSymbol, (IParameterizedSymbol)newSymbol);
        }
        return false;
    }

    protected static boolean isValidOverload(List origList, ISymbol newSymbol) {
        if (origList.size() == 1) {
            return ParserSymbolTable.isValidOverload((ISymbol)origList.iterator().next(), newSymbol);
        }
        if (origList.size() > 1) {
            boolean valid;
            if (newSymbol.getType() != TypeInfo.t_function && newSymbol.getType() != TypeInfo.t_constructor) {
                return false;
            }
            Iterator iter = origList.iterator();
            ISymbol symbol = (ISymbol)iter.next();
            boolean bl = valid = symbol.getType().compareTo(TypeInfo.t_class) >= 0 && symbol.getType().compareTo(TypeInfo.t_enumeration) <= 0;
            if (!valid && symbol instanceof IParameterizedSymbol) {
                valid = ParserSymbolTable.isValidFunctionOverload((IParameterizedSymbol)symbol, (IParameterizedSymbol)newSymbol);
            }
            while (valid && iter.hasNext()) {
                symbol = (ISymbol)iter.next();
                boolean bl2 = valid = symbol instanceof IParameterizedSymbol && ParserSymbolTable.isValidFunctionOverload((IParameterizedSymbol)symbol, (IParameterizedSymbol)newSymbol);
            }
            return valid;
        }
        return true;
    }

    private static boolean isValidFunctionOverload(IParameterizedSymbol origSymbol, IParameterizedSymbol newSymbol) {
        if (!origSymbol.isType(TypeInfo.t_function) && !origSymbol.isType(TypeInfo.t_constructor) || !newSymbol.isType(TypeInfo.t_function) && !newSymbol.isType(TypeInfo.t_constructor)) {
            return false;
        }
        if (origSymbol.getTypeInfo().isForwardDeclaration() && origSymbol.getTypeSymbol() == newSymbol) {
            return true;
        }
        if (origSymbol.hasSameParameters(newSymbol)) {
            if (origSymbol.getTypeInfo().checkBit(128) || newSymbol.getTypeInfo().checkBit(128)) {
                return false;
            }
            return origSymbol.compareCVQualifiersTo(newSymbol) != 0;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ISymbol resolveAmbiguities(LookupData data) throws ParserSymbolTableException {
        ISymbol decl = null;
        ISymbol obj = null;
        ISymbol cls = null;
        if (data.foundItems == null) {
            return null;
        }
        int size = data.foundItems.size();
        Iterator iter = data.foundItems.iterator();
        boolean needDecl = true;
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            decl = (ISymbol)iter.next();
            if (!decl.isType(TypeInfo.t_function)) {
                data.foundItems.clear();
                return decl;
            }
            needDecl = false;
        }
        LinkedList<ISymbol> functionList = null;
        int i = size;
        while (i > 0) {
            if (needDecl) {
                decl = (ISymbol)iter.next();
            } else {
                needDecl = true;
            }
            if (decl.isType(TypeInfo.t_function)) {
                if (functionList == null) {
                    functionList = new LinkedList<ISymbol>();
                }
                functionList.add(decl);
            } else if (decl.isType(TypeInfo.t_class, TypeInfo.t_enumeration)) {
                if (cls == null) {
                    cls = (IContainerSymbol)decl;
                } else if (cls.getTypeInfo().isForwardDeclaration() && cls.getTypeSymbol() == decl) {
                    cls = (IContainerSymbol)decl;
                } else if (!decl.getTypeInfo().isForwardDeclaration() || decl.getTypeSymbol() != cls) {
                    throw new ParserSymbolTableException(0);
                }
            } else {
                if (obj != null) throw new ParserSymbolTableException(0);
                obj = decl;
            }
            decl = null;
            --i;
        }
        data.foundItems.clear();
        int numFunctions = functionList == null ? 0 : functionList.size();
        boolean ambiguous = false;
        if (cls != null) {
            if (obj != null && cls.getContainingSymbol() != obj.getContainingSymbol()) {
                ambiguous = true;
            }
            if (functionList != null) {
                Iterator fnIter = functionList.iterator();
                IParameterizedSymbol fn = null;
                int i2 = numFunctions;
                while (i2 > 0) {
                    fn = (IParameterizedSymbol)fnIter.next();
                    if (cls.getContainingSymbol() != fn.getContainingSymbol()) {
                        ambiguous = true;
                        break;
                    }
                    --i2;
                }
            }
        }
        if (obj != null && !ambiguous) {
            if (numFunctions <= 0) return obj;
            ambiguous = true;
        } else if (numFunctions > 0) {
            if (data.parameters != null) return ParserSymbolTable.resolveFunction(data, functionList);
            if (numFunctions == 1) {
                return (ISymbol)functionList.getFirst();
            }
            data.foundItems.addAll(functionList);
            throw new ParserSymbolTableException(7);
        }
        if (!ambiguous) return cls;
        throw new ParserSymbolTableException(0);
    }

    protected static IParameterizedSymbol resolveFunction(LookupData data, List functions) throws ParserSymbolTableException {
        if (functions == null) {
            return null;
        }
        ParserSymbolTable.reduceToViable(data, functions);
        int numSourceParams = data.parameters == null ? 0 : data.parameters.size();
        int numFns = functions.size();
        if (numSourceParams == 0) {
            if (numFns == 0) {
                return null;
            }
            if (numFns == 1) {
                return (IParameterizedSymbol)functions.iterator().next();
            }
            if (numFns == 2) {
                Iterator iter = functions.iterator();
                while (iter.hasNext()) {
                    IParameterizedSymbol fn = (IParameterizedSymbol)iter.next();
                    if (!fn.getTypeInfo().isForwardDeclaration() || fn.getTypeSymbol() == null || !functions.contains(fn.getTypeSymbol())) continue;
                    return (IParameterizedSymbol)fn.getTypeSymbol();
                }
                throw new ParserSymbolTableException(0);
            }
            throw new ParserSymbolTableException(0);
        }
        ISymbol bestFn = null;
        IParameterizedSymbol currFn = null;
        Cost[] bestFnCost = null;
        Cost[] currFnCost = null;
        Iterator iterFns = functions.iterator();
        Iterator sourceParams = null;
        Iterator targetParams = null;
        int numTargetParams = 0;
        int numParams = 0;
        Cost cost = null;
        Cost temp = null;
        TypeInfo source = null;
        TypeInfo target = null;
        boolean hasWorse = false;
        boolean hasBetter = false;
        boolean ambiguous = false;
        boolean currHasAmbiguousParam = false;
        boolean bestHasAmbiguousParam = false;
        int i = numFns;
        while (i > 0) {
            block25: {
                block23: {
                    block24: {
                        currFn = (IParameterizedSymbol)iterFns.next();
                        if (bestFn == null) break block23;
                        if (!bestFn.isForwardDeclaration() || bestFn.getTypeSymbol() != currFn) break block24;
                        bestFn = currFn;
                        break block25;
                    }
                    if (currFn.isForwardDeclaration() && currFn.getTypeSymbol() == bestFn) break block25;
                }
                sourceParams = data.parameters.iterator();
                LinkedList<ISymbol> parameterList = null;
                if (currFn.getParameterList().isEmpty()) {
                    parameterList = new LinkedList<ISymbol>();
                    parameterList.add(currFn.getSymbolTable().newSymbol(EMPTY_NAME, TypeInfo.t_void));
                    targetParams = parameterList.iterator();
                } else {
                    parameterList = currFn.getParameterList();
                }
                targetParams = parameterList.iterator();
                numTargetParams = parameterList.size();
                int n = numParams = numTargetParams < numSourceParams ? numTargetParams : numSourceParams;
                if (currFnCost == null) {
                    currFnCost = new Cost[numParams];
                }
                int comparison = 0;
                int j = 0;
                while (j < numParams) {
                    source = (TypeInfo)sourceParams.next();
                    if (source.equals(target = ((ISymbol)targetParams.next()).getTypeInfo())) {
                        cost = new Cost(source, target);
                        cost.rank = 0;
                    } else {
                        cost = ParserSymbolTable.checkStandardConversionSequence(source, target);
                        if (cost.rank == -1 && !data.forUserDefinedConversion && (temp = ParserSymbolTable.checkUserDefinedConversionSequence(source, target)) != null) {
                            cost = temp;
                        }
                    }
                    currFnCost[j] = cost;
                    ++j;
                }
                hasWorse = false;
                hasBetter = false;
                j = 0;
                while (j < numParams) {
                    if (currFnCost[j].rank < 0) {
                        hasWorse = true;
                        hasBetter = false;
                        break;
                    }
                    boolean bl = currHasAmbiguousParam = currFnCost[j].userDefined == 1;
                    if (bestFnCost != null) {
                        comparison = currFnCost[j].compare(bestFnCost[j]);
                        hasWorse |= comparison < 0;
                        hasBetter |= comparison > 0;
                    } else {
                        hasBetter = true;
                    }
                    ++j;
                }
                ambiguous |= hasWorse && hasBetter || !hasWorse && !hasBetter;
                if (!hasWorse && hasBetter) {
                    ambiguous = false;
                    bestFnCost = currFnCost;
                    bestHasAmbiguousParam = currHasAmbiguousParam;
                    currFnCost = null;
                    bestFn = currFn;
                }
            }
            --i;
        }
        if (ambiguous || bestHasAmbiguousParam) {
            throw new ParserSymbolTableException(0);
        }
        return bestFn;
    }

    private static void reduceToViable(LookupData data, List functions) {
        int numParameters = data.parameters == null ? 0 : data.parameters.size();
        Iterator iter = functions.iterator();
        block0: while (iter.hasNext()) {
            ISymbol param;
            TypeInfo paramType;
            int num;
            IParameterizedSymbol function = (IParameterizedSymbol)iter.next();
            int n = num = function.getParameterList() == null ? 0 : function.getParameterList().size();
            if (num == numParameters || (numParameters != 0 || num != 1 ? numParameters == 1 && num == 0 && (paramType = (TypeInfo)data.parameters.iterator().next()).isType(TypeInfo.t_void) : (param = (ISymbol)function.getParameterList().iterator().next()).isType(TypeInfo.t_void))) continue;
            if (num < numParameters) {
                iter.remove();
                continue;
            }
            ListIterator listIter = function.getParameterList().listIterator(num);
            int i = num;
            while (i > numParameters - num + 1) {
                TypeInfo param2 = ((ISymbol)listIter.previous()).getTypeInfo();
                if (!param2.getHasDefault()) {
                    iter.remove();
                    continue block0;
                }
                --i;
            }
        }
    }

    private static void processDirectives(IContainerSymbol symbol, LookupData data, List directives) {
        IContainerSymbol enclosing = null;
        IContainerSymbol temp = null;
        int size = directives.size();
        Iterator iter = directives.iterator();
        int i = size;
        while (i > 0) {
            temp = (IContainerSymbol)iter.next();
            if (!data.visited.contains(temp)) {
                LinkedList<IContainerSymbol> list;
                enclosing = ParserSymbolTable.getClosestEnclosingDeclaration(symbol, temp);
                LinkedList<IContainerSymbol> linkedList = list = data.usingDirectives == null ? null : (LinkedList<IContainerSymbol>)data.usingDirectives.get(enclosing);
                if (list == null) {
                    list = new LinkedList<IContainerSymbol>();
                    list.add(temp);
                    if (data.usingDirectives == null) {
                        data.usingDirectives = new HashMap();
                    }
                    data.usingDirectives.put(enclosing, list);
                } else {
                    list.add(temp);
                }
            }
            --i;
        }
    }

    private static IContainerSymbol getClosestEnclosingDeclaration(ISymbol symbol1, ISymbol symbol2) {
        if (symbol1 == symbol2) {
            return symbol1 instanceof IContainerSymbol ? (IContainerSymbol)symbol1 : symbol1.getContainingSymbol();
        }
        if (symbol1.getDepth() == symbol2.getDepth()) {
            return ParserSymbolTable.getClosestEnclosingDeclaration(symbol1.getContainingSymbol(), symbol2.getContainingSymbol());
        }
        if (symbol1.getDepth() > symbol2.getDepth()) {
            return ParserSymbolTable.getClosestEnclosingDeclaration(symbol1.getContainingSymbol(), symbol2);
        }
        return ParserSymbolTable.getClosestEnclosingDeclaration(symbol1, symbol2.getContainingSymbol());
    }

    private static int hasBaseClass(ISymbol obj, ISymbol base) throws ParserSymbolTableException {
        return ParserSymbolTable.hasBaseClass(obj, base, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int hasBaseClass(ISymbol obj, ISymbol base, boolean throwIfNotVisible) throws ParserSymbolTableException {
        int size;
        ISymbol temp;
        if (obj == base) {
            return 0;
        }
        IDerivableContainerSymbol symbol = null;
        TemplateInstance instance = null;
        if (obj instanceof TemplateInstance) {
            instance = (TemplateInstance)obj;
            temp = instance.getInstantiatedSymbol();
            if (!(temp instanceof IDerivableContainerSymbol)) return -1;
            symbol = (IDerivableContainerSymbol)temp;
        } else {
            if (!(obj instanceof IDerivableContainerSymbol)) return -1;
            symbol = (IDerivableContainerSymbol)obj;
        }
        if (!symbol.hasParents()) return -1;
        temp = null;
        IDerivableContainerSymbol parent = null;
        Iterator iter = symbol.getParents().iterator();
        int i = size = symbol.getParents().size();
        while (i > 0) {
            block14: {
                boolean isVisible;
                block16: {
                    block15: {
                        TypeInfo info;
                        block13: {
                            IDerivableContainerSymbol.IParentSymbol wrapper = (IDerivableContainerSymbol.IParentSymbol)iter.next();
                            temp = wrapper.getParent();
                            boolean bl = isVisible = wrapper.getVisibility() == ASTAccessVisibility.PUBLIC;
                            if (!(temp instanceof TemplateInstance)) break block13;
                            instance = (TemplateInstance)temp;
                            if (instance.getInstantiatedSymbol() instanceof IDerivableContainerSymbol) {
                                if (instance.getInstantiatedSymbol() == base) {
                                    if (!throwIfNotVisible || isVisible) return 1;
                                    throw new ParserSymbolTableException(6);
                                }
                                int n = ParserSymbolTable.hasBaseClass(instance, base, throwIfNotVisible);
                                if (n > 0) {
                                    return n + 1;
                                }
                            }
                            break block14;
                        }
                        if (!temp.isType(TypeInfo.t_undef) || !temp.getContainingSymbol().isType(TypeInfo.t_template)) break block15;
                        if (instance == null || (info = (TypeInfo)instance.getArgumentMap().get(temp)) == null || !info.isType(TypeInfo.t_class, TypeInfo.t_struct)) break block14;
                        parent = (IDerivableContainerSymbol)info.getTypeSymbol();
                        break block16;
                    }
                    if (!(temp instanceof IDerivableContainerSymbol)) break block14;
                    parent = (IDerivableContainerSymbol)temp;
                }
                if (parent == base) {
                    if (!throwIfNotVisible || isVisible) return 1;
                    throw new ParserSymbolTableException(6);
                }
                int n = ParserSymbolTable.hasBaseClass(parent, base, throwIfNotVisible);
                if (n > 0) {
                    return n + 1;
                }
            }
            --i;
        }
        return -1;
    }

    protected static void getAssociatedScopes(ISymbol symbol, HashSet associated) {
        if (symbol == null) {
            return;
        }
        if (symbol instanceof IDerivableContainerSymbol) {
            associated.add(symbol);
            ParserSymbolTable.getBaseClassesAndContainingNamespaces((IDerivableContainerSymbol)symbol, associated);
        } else if (symbol.getType() == TypeInfo.t_union || symbol.getType() == TypeInfo.t_enumeration) {
            associated.add(symbol.getContainingSymbol());
        }
    }

    private static void getBaseClassesAndContainingNamespaces(IDerivableContainerSymbol obj, HashSet classes) {
        if (obj.getParents() != null) {
            int size;
            if (classes == null) {
                return;
            }
            Iterator iter = obj.getParents().iterator();
            int i = size = obj.getParents().size();
            while (i > 0) {
                IDerivableContainerSymbol.IParentSymbol wrapper = (IDerivableContainerSymbol.IParentSymbol)iter.next();
                ISymbol base = wrapper.getParent();
                classes.add(base);
                if (base.getContainingSymbol().getType() == TypeInfo.t_namespace) {
                    classes.add(base.getContainingSymbol());
                }
                ParserSymbolTable.getBaseClassesAndContainingNamespaces((IDerivableContainerSymbol)base, classes);
                --i;
            }
        }
    }

    protected static boolean okToAddUsingDeclaration(ISymbol obj, IContainerSymbol context) {
        boolean okToAdd = false;
        if (obj.isTemplateMember() && obj.getContainingSymbol().isType(TypeInfo.t_template)) {
            okToAdd = false;
        } else if (context.isType(TypeInfo.t_class, TypeInfo.t_struct)) {
            IContainerSymbol container = obj.getContainingSymbol();
            try {
                if (obj.getContainingSymbol().getType() == context.getType()) {
                    okToAdd = ParserSymbolTable.hasBaseClass((IDerivableContainerSymbol)context, (IDerivableContainerSymbol)container) > 0;
                } else if (obj.getContainingSymbol().getType() == TypeInfo.t_union) {
                    okToAdd = (container = container.getContainingSymbol()) instanceof IDerivableContainerSymbol ? ParserSymbolTable.hasBaseClass((IDerivableContainerSymbol)context, (IDerivableContainerSymbol)container) > 0 : false;
                } else if (obj.getType() == TypeInfo.t_enumerator) {
                    okToAdd = (container = container.getContainingSymbol()) instanceof IDerivableContainerSymbol ? ParserSymbolTable.hasBaseClass((IDerivableContainerSymbol)context, (IDerivableContainerSymbol)container) > 0 : false;
                }
            }
            catch (ParserSymbolTableException parserSymbolTableException) {}
        } else {
            okToAdd = true;
        }
        return okToAdd;
    }

    private static Cost lvalue_to_rvalue(TypeInfo source, TypeInfo target) {
        int i;
        Iterator iter;
        int size;
        TypeInfo.PtrOp ptr;
        Iterator<TypeInfo.PtrOp> iterator;
        ISymbol symbol;
        if (source.isType(TypeInfo.t_type)) {
            source = ParserSymbolTable.getFlatTypeInfo(source);
        }
        if (target.isType(TypeInfo.t_type) && (symbol = target.getTypeSymbol()) != null && symbol.isForwardDeclaration() && symbol.getTypeSymbol() != null) {
            target = new TypeInfo(target);
            target.setType(TypeInfo.t_type);
            target.setTypeSymbol(symbol.getTypeSymbol());
        }
        Cost cost = new Cost(source, target);
        if (cost.source == null || cost.target == null) {
            return cost;
        }
        TypeInfo.PtrOp op = null;
        if (cost.source.hasPtrOperators()) {
            List sourcePtrs = cost.source.getPtrOperators();
            iterator = sourcePtrs.iterator();
            ptr = (TypeInfo.PtrOp)iterator.next();
            if (ptr.getType() == TypeInfo.PtrOp.t_reference) {
                iterator.remove();
            }
            size = sourcePtrs.size();
            iter = sourcePtrs.iterator();
            i = size;
            while (i > 0) {
                op = (TypeInfo.PtrOp)iter.next();
                if (op.getType() == TypeInfo.PtrOp.t_array) {
                    op.setType(TypeInfo.PtrOp.t_pointer);
                }
                --i;
            }
        }
        if (cost.target.hasPtrOperators()) {
            List targetPtrs = cost.target.getPtrOperators();
            iterator = targetPtrs.listIterator();
            ptr = (TypeInfo.PtrOp)iterator.next();
            if (ptr.getType() == TypeInfo.PtrOp.t_reference) {
                if (ptr.isConst() || ptr.isVolatile()) {
                    iterator.set(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_undef, ptr.isConst(), ptr.isVolatile()));
                } else {
                    iterator.remove();
                }
                cost.targetHadReference = true;
            }
            size = targetPtrs.size();
            iter = targetPtrs.iterator();
            i = size;
            while (i > 0) {
                op = (TypeInfo.PtrOp)iter.next();
                if (op.getType() == TypeInfo.PtrOp.t_array) {
                    op.setType(TypeInfo.PtrOp.t_pointer);
                }
                --i;
            }
        }
        return cost;
    }

    private static void qualificationConversion(Cost cost) {
        int size = cost.source.getPtrOperators().size();
        int size2 = cost.target.getPtrOperators().size();
        TypeInfo.PtrOp op1 = null;
        TypeInfo.PtrOp op2 = null;
        boolean canConvert = true;
        Iterator iter1 = cost.source.getPtrOperators().iterator();
        Iterator iter2 = cost.target.getPtrOperators().iterator();
        if (size != size2) {
            canConvert = size2 - size == 1 ? (op2 = (TypeInfo.PtrOp)iter2.next()).isConst() || op2.isVolatile() : false;
        } else if (size == 1) {
            op1 = (TypeInfo.PtrOp)iter1.next();
            op2 = (TypeInfo.PtrOp)iter2.next();
            if (op1.isConst() && !op2.isConst() || op1.isVolatile() && !op2.isVolatile()) {
                cost.qualification = 0;
                return;
            }
            canConvert = true;
        } else if (size > 0) {
            op1 = (TypeInfo.PtrOp)iter1.next();
            op2 = (TypeInfo.PtrOp)iter2.next();
            boolean constInEveryCV2k = true;
            int j = 1;
            while (j < size) {
                op1 = (TypeInfo.PtrOp)iter1.next();
                op2 = (TypeInfo.PtrOp)iter2.next();
                if (op1.getType() != op2.getType()) {
                    canConvert = false;
                    break;
                }
                if (op1.isConst() && !op2.isConst() || op1.isVolatile() && !op2.isVolatile()) {
                    canConvert = false;
                    break;
                }
                if (op1.compareCVTo(op2) != 0 && !constInEveryCV2k) {
                    canConvert = false;
                    break;
                }
                constInEveryCV2k &= op2.isConst();
                ++j;
            }
        }
        if (canConvert) {
            cost.qualification = 1;
            cost.rank = 0;
        } else {
            cost.qualification = 0;
        }
    }

    private static void promotion(Cost cost) {
        TypeInfo src = cost.source;
        TypeInfo trg = cost.target;
        int mask = 917504;
        if ((src.isType(TypeInfo.t_bool, TypeInfo.t_float) || src.isType(TypeInfo.t_enumeration)) && (trg.isType(TypeInfo.t_int) || trg.isType(TypeInfo.t_double))) {
            if (src.getType() == trg.getType() && (src.getTypeInfo() & mask) == (trg.getTypeInfo() & mask)) {
                return;
            }
            cost.promotion = src.isType(TypeInfo.t_float) ? (trg.isType(TypeInfo.t_double) ? 1 : 0) : (trg.isType(TypeInfo.t_int) && trg.canHold(src) ? 1 : 0);
        } else {
            cost.promotion = 0;
        }
        cost.rank = cost.promotion > 0 ? 1 : -1;
    }

    private static void conversion(Cost cost) {
        TypeInfo src = cost.source;
        TypeInfo trg = cost.target;
        int temp = -1;
        cost.conversion = 0;
        cost.detail = 0;
        if (!src.hasSamePtrs(trg)) {
            return;
        }
        if (src.hasPtrOperators() && src.getPtrOperators().size() == 1) {
            ISymbol trgDecl;
            TypeInfo.PtrOp ptr = (TypeInfo.PtrOp)src.getPtrOperators().iterator().next();
            ISymbol srcDecl = src.isType(TypeInfo.t_type) ? src.getTypeSymbol() : null;
            ISymbol iSymbol = trgDecl = trg.isType(TypeInfo.t_type) ? trg.getTypeSymbol() : null;
            if (ptr.getType() == TypeInfo.PtrOp.t_pointer) {
                if (srcDecl == null || trgDecl == null && !trg.isType(TypeInfo.t_void)) {
                    return;
                }
                if (trg.isType(TypeInfo.t_void)) {
                    cost.rank = 2;
                    cost.conversion = 1;
                    cost.detail = 2;
                    return;
                }
                cost.detail = 1;
                if (srcDecl instanceof IDerivableContainerSymbol && trgDecl.isType(srcDecl.getType())) {
                    try {
                        temp = ParserSymbolTable.hasBaseClass((IDerivableContainerSymbol)srcDecl, (IDerivableContainerSymbol)trgDecl);
                    }
                    catch (ParserSymbolTableException parserSymbolTableException) {}
                    cost.rank = temp > -1 ? 2 : -1;
                    cost.conversion = temp > -1 ? temp : 0;
                    cost.detail = 1;
                    return;
                }
            } else if (ptr.getType() == TypeInfo.PtrOp.t_memberPointer) {
                TypeInfo.PtrOp srcPtr;
                if (srcDecl == null || trgDecl == null) {
                    return;
                }
                TypeInfo.PtrOp ptrOp = srcPtr = trg.hasPtrOperators() ? (TypeInfo.PtrOp)trg.getPtrOperators().iterator().next() : null;
                if (trgDecl.isType(srcDecl.getType()) && srcPtr != null && srcPtr.getType() == TypeInfo.PtrOp.t_memberPointer) {
                    try {
                        temp = ParserSymbolTable.hasBaseClass((IDerivableContainerSymbol)ptr.getMemberOf(), (IDerivableContainerSymbol)srcPtr.getMemberOf());
                    }
                    catch (ParserSymbolTableException parserSymbolTableException) {}
                    cost.rank = temp > -1 ? 2 : -1;
                    cost.detail = 1;
                    cost.conversion = temp > -1 ? temp : 0;
                    return;
                }
            }
        } else if (!src.hasPtrOperators() && (src.isType(TypeInfo.t_bool, TypeInfo.t_int) || src.isType(TypeInfo.t_float, TypeInfo.t_double) || src.isType(TypeInfo.t_enumeration)) && (trg.isType(TypeInfo.t_bool, TypeInfo.t_int) || trg.isType(TypeInfo.t_float, TypeInfo.t_double))) {
            cost.rank = 2;
            cost.conversion = 1;
        }
    }

    private static void derivedToBaseConversion(Cost cost) throws ParserSymbolTableException {
        ISymbol trgDecl;
        TypeInfo src = cost.source;
        TypeInfo trg = cost.target;
        ISymbol srcDecl = src.isType(TypeInfo.t_type) ? src.getTypeSymbol() : null;
        ISymbol iSymbol = trgDecl = trg.isType(TypeInfo.t_type) ? trg.getTypeSymbol() : null;
        if (!src.hasSamePtrs(trg) || srcDecl == null || trgDecl == null || !cost.targetHadReference) {
            return;
        }
        int temp = ParserSymbolTable.hasBaseClass((IDerivableContainerSymbol)srcDecl, (IDerivableContainerSymbol)trgDecl, true);
        if (temp > -1) {
            cost.rank = 3;
            cost.conversion = temp;
        }
    }

    private static Cost checkStandardConversionSequence(TypeInfo source, TypeInfo target) throws ParserSymbolTableException {
        Cost cost = ParserSymbolTable.lvalue_to_rvalue(source, target);
        if (cost.source == null || cost.target == null) {
            return cost;
        }
        if (cost.source.equals(cost.target)) {
            cost.rank = 0;
            return cost;
        }
        ParserSymbolTable.qualificationConversion(cost);
        if (cost.qualification == 0) {
            return cost;
        }
        if (cost.source.isType(TypeInfo.t_type) && cost.target.isType(TypeInfo.t_type) && cost.target.hasSamePtrs(cost.source)) {
            ISymbol srcSymbol = cost.source.getTypeSymbol();
            ISymbol trgSymbol = cost.target.getTypeSymbol();
            if (srcSymbol != null && trgSymbol != null && srcSymbol.equals(trgSymbol)) {
                return cost;
            }
        }
        ParserSymbolTable.promotion(cost);
        if (cost.promotion > 0 || cost.rank > -1) {
            return cost;
        }
        ParserSymbolTable.conversion(cost);
        if (cost.rank > -1) {
            return cost;
        }
        ParserSymbolTable.derivedToBaseConversion(cost);
        return cost;
    }

    private static Cost checkUserDefinedConversionSequence(TypeInfo source, TypeInfo target) throws ParserSymbolTableException {
        Cost cost = null;
        Cost constructorCost = null;
        Cost conversionCost = null;
        ISymbol targetDecl = null;
        ISymbol sourceDecl = null;
        ISymbol constructor = null;
        Object conversion = null;
        if (target.getType() == TypeInfo.t_type && (targetDecl = target.getTypeSymbol()).isType(TypeInfo.t_class, TypeInfo.t_union)) {
            LookupData data = new LookupData(EMPTY_NAME, TypeInfo.t_constructor, null);
            data.parameters = new LinkedList();
            data.parameters.add(source);
            data.forUserDefinedConversion = true;
            IDerivableContainerSymbol container = (IDerivableContainerSymbol)targetDecl;
            if (targetDecl instanceof TemplateInstance) {
                data.templateInstance = targetDecl;
                container = (IDerivableContainerSymbol)((TemplateInstance)targetDecl).getInstantiatedSymbol();
            }
            if (!container.getConstructors().isEmpty()) {
                LinkedList constructors = new LinkedList(container.getConstructors());
                constructor = ParserSymbolTable.resolveFunction(data, constructors);
            }
            if (constructor != null && constructor.getTypeInfo().checkBit(4096)) {
                constructor = null;
            }
        }
        if (source.getType() == TypeInfo.t_type) {
            String name;
            ISymbol iSymbol = sourceDecl = (source = ParserSymbolTable.getFlatTypeInfo(source)) != null ? source.getTypeSymbol() : null;
            if (sourceDecl != null && sourceDecl instanceof IContainerSymbol && !(name = target.toString()).equals(EMPTY_NAME)) {
                LinkedList params;
                LookupData data = new LookupData("operator " + name, TypeInfo.t_function, null);
                data.parameters = params = new LinkedList();
                data.forUserDefinedConversion = true;
                ParserSymbolTable.lookupInContained(data, (IContainerSymbol)sourceDecl);
                conversion = (IParameterizedSymbol)ParserSymbolTable.resolveAmbiguities(data);
            }
        }
        if (constructor != null) {
            constructorCost = ParserSymbolTable.checkStandardConversionSequence(new TypeInfo(TypeInfo.t_type, 0, constructor.getContainingSymbol()), target);
        }
        if (conversion != null) {
            conversionCost = ParserSymbolTable.checkStandardConversionSequence(new TypeInfo(target.getType(), 0, target.getTypeSymbol()), target);
        }
        if (constructorCost != null && constructorCost.rank != -1 && conversionCost != null && conversionCost.rank != -1) {
            cost = constructorCost;
            cost.userDefined = 1;
            cost.rank = 4;
        } else if (constructorCost != null && constructorCost.rank != -1) {
            cost = constructorCost;
            cost.userDefined = constructor.hashCode();
            cost.rank = 4;
        } else if (conversionCost != null && conversionCost.rank != -1) {
            cost = conversionCost;
            cost.userDefined = conversion.hashCode();
            cost.rank = 4;
        }
        return cost;
    }

    public static TypeInfo getConditionalOperand(TypeInfo secondOp, TypeInfo thirdOp) throws ParserSymbolTableException {
        boolean canConvertThird;
        Cost secondCost = ParserSymbolTable.checkStandardConversionSequence(secondOp, ParserSymbolTable.getFlatTypeInfo(thirdOp));
        if (secondCost.rank == -1) {
            secondCost = ParserSymbolTable.checkUserDefinedConversionSequence(secondOp, ParserSymbolTable.getFlatTypeInfo(thirdOp));
        }
        Cost thirdCost = ParserSymbolTable.checkStandardConversionSequence(thirdOp, ParserSymbolTable.getFlatTypeInfo(secondOp));
        if (thirdCost.rank == -1) {
            thirdCost = ParserSymbolTable.checkUserDefinedConversionSequence(thirdOp, ParserSymbolTable.getFlatTypeInfo(secondOp));
        }
        boolean canConvertSecond = secondCost != null && secondCost.rank != -1;
        boolean bl = canConvertThird = thirdCost != null && thirdCost.rank != -1;
        if (!canConvertSecond && !canConvertThird) {
            return null;
        }
        if (canConvertSecond && canConvertThird) {
            throw new ParserSymbolTableException(0);
        }
        if (canConvertSecond) {
            if (secondCost.userDefined == 1) {
                throw new ParserSymbolTableException(0);
            }
            return thirdOp;
        }
        if (thirdCost.userDefined == 1) {
            throw new ParserSymbolTableException(0);
        }
        return secondOp;
    }

    protected static TypeInfo getFlatTypeInfo(TypeInfo topInfo) {
        TypeInfo returnInfo = topInfo;
        TypeInfo info = null;
        if (topInfo.getType() == TypeInfo.t_type && topInfo.getTypeSymbol() != null) {
            returnInfo = new TypeInfo();
            ISymbol typeSymbol = topInfo.getTypeSymbol();
            info = typeSymbol.getTypeInfo();
            while (info.getTypeSymbol() != null && (info.getType() == TypeInfo.t_type || info.isForwardDeclaration())) {
                typeSymbol = info.getTypeSymbol();
                returnInfo.addPtrOperator(info.getPtrOperators());
                info = typeSymbol.getTypeInfo();
            }
            if (info.isType(TypeInfo.t_class, TypeInfo.t_enumeration)) {
                returnInfo.setType(TypeInfo.t_type);
                returnInfo.setTypeSymbol(typeSymbol);
            } else {
                returnInfo.setTypeInfo(info.getTypeInfo());
                returnInfo.setType(info.getType());
                returnInfo.setTypeSymbol(null);
                returnInfo.addPtrOperator(info.getPtrOperators());
            }
            returnInfo.applyOperatorExpressions(topInfo.getOperatorExpressions());
            if (topInfo.hasPtrOperators()) {
                TypeInfo.PtrOp topPtr = (TypeInfo.PtrOp)topInfo.getPtrOperators().iterator().next();
                TypeInfo.PtrOp ptr = null;
                if (returnInfo.hasPtrOperators()) {
                    ptr = (TypeInfo.PtrOp)returnInfo.getPtrOperators().iterator().next();
                } else {
                    ptr = new TypeInfo.PtrOp();
                    returnInfo.addPtrOperator(ptr);
                    ptr.setType(topPtr.getType());
                }
                ptr.setConst(topPtr.isConst());
                ptr.setVolatile(topPtr.isVolatile());
            }
        } else {
            returnInfo = new TypeInfo(topInfo);
        }
        return returnInfo;
    }

    private static IParameterizedSymbol matchTemplatePartialSpecialization(IParameterizedSymbol template, List args) {
        int size;
        if (template == null) {
            return null;
        }
        List specs = template.getSpecializations();
        int n = size = specs != null ? specs.size() : 0;
        if (size == 0) {
            return template;
        }
        IParameterizedSymbol bestMatch = null;
        boolean bestMatchIsBest = true;
        Iterator iter = specs.iterator();
        IParameterizedSymbol spec = null;
        List specArgs = null;
        int i = size;
        while (i > 0) {
            spec = (IParameterizedSymbol)iter.next();
            specArgs = spec.getArgumentList();
            if (specArgs != null && specArgs.size() == args.size()) {
                ISymbol sym1 = null;
                ISymbol sym2 = null;
                Iterator iter1 = specArgs.iterator();
                Iterator iter2 = args.iterator();
                HashMap map = new HashMap();
                boolean match = true;
                int j = specArgs.size();
                while (j > 0) {
                    sym1 = (ISymbol)iter1.next();
                    TypeInfo info2 = (TypeInfo)iter2.next();
                    if (info2.isType(TypeInfo.t_type)) {
                        sym2 = sym2.getTypeSymbol();
                    } else {
                        sym2 = template.getSymbolTable().newSymbol(EMPTY_NAME);
                        sym2.setTypeInfo(info2);
                    }
                    if (!ParserSymbolTable.deduceTemplateArgument(map, sym1, sym2, null)) {
                        match = false;
                        break;
                    }
                    --j;
                }
                if (match) {
                    int compare = ParserSymbolTable.orderSpecializations(bestMatch, spec);
                    if (compare == 0) {
                        bestMatchIsBest = false;
                    } else if (compare < 0) {
                        bestMatch = spec;
                        bestMatchIsBest = true;
                    }
                }
            }
            --i;
        }
        return bestMatchIsBest ? bestMatch : null;
    }

    private static int orderSpecializations(IParameterizedSymbol spec1, IParameterizedSymbol spec2) {
        if (spec1 == null) {
            return -1;
        }
        Iterator iter = spec1.getContainedSymbols().keySet().iterator();
        ISymbol decl = (ISymbol)spec1.getContainedSymbols().get(iter.next());
        if (decl.isType(TypeInfo.t_class)) {
            spec1 = ParserSymbolTable.classTemplateSpecializationToFunctionTemplate(spec1);
            spec2 = ParserSymbolTable.classTemplateSpecializationToFunctionTemplate(spec2);
        }
        TemplateInstance transformed1 = ParserSymbolTable.transformFunctionTemplateForOrdering(spec1);
        TemplateInstance transformed2 = ParserSymbolTable.transformFunctionTemplateForOrdering(spec2);
        boolean d1 = ParserSymbolTable.deduceTemplateArguments(spec2, transformed1);
        boolean d2 = ParserSymbolTable.deduceTemplateArguments(spec1, transformed2);
        if (d1 && d2 || !d1 && !d2) {
            return 0;
        }
        if (d1 && !d2) {
            return 1;
        }
        return -1;
    }

    private static boolean deduceTemplateArguments(IParameterizedSymbol template, TemplateInstance argSource) {
        if (template.getContainedSymbols() == null || template.getContainedSymbols().size() != 1) {
            return false;
        }
        Iterator iter = template.getContainedSymbols().keySet().iterator();
        ISymbol templateSymbol = (ISymbol)template.getContainedSymbols().get(iter.next());
        if (!templateSymbol.isType(TypeInfo.t_function)) {
            return false;
        }
        IParameterizedSymbol argTemplate = (IParameterizedSymbol)argSource.getInstantiatedSymbol();
        iter = argTemplate.getContainedSymbols().keySet().iterator();
        ISymbol argFunction = (ISymbol)argTemplate.getContainedSymbols().get(iter.next());
        if (!argFunction.isType(TypeInfo.t_function)) {
            return false;
        }
        List args = ((IParameterizedSymbol)argFunction).getParameterList();
        IParameterizedSymbol function = (IParameterizedSymbol)templateSymbol;
        if (function.getParameterList() == null || function.getParameterList().size() != args.size()) {
            return false;
        }
        HashMap map = new HashMap();
        Iterator pIter = function.getParameterList().iterator();
        Iterator aIter = args.iterator();
        while (pIter.hasNext()) {
            if (ParserSymbolTable.deduceTemplateArgument(map, (ISymbol)pIter.next(), (ISymbol)aIter.next(), argSource.getArgumentMap())) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean deduceTemplateArgument(Map map, ISymbol p, ISymbol a, Map argumentMap) {
        if (argumentMap != null && argumentMap.containsKey(a)) {
            a = (ISymbol)argumentMap.get(a);
        }
        ISymbol pSymbol = p;
        ISymbol aSymbol = a;
        if (p.isType(TypeInfo.t_type)) {
            pSymbol = p.getTypeSymbol();
            aSymbol = a.isType(TypeInfo.t_type) ? a.getTypeSymbol() : a;
            return ParserSymbolTable.deduceTemplateArgument(map, pSymbol, aSymbol, argumentMap);
        }
        if (pSymbol.isTemplateMember() && pSymbol.isType(TypeInfo.t_undef)) {
            List pPtrs = pSymbol.getPtrOperators();
            List aPtrs = aSymbol.getPtrOperators();
            if (pPtrs != null) {
                TypeInfo.PtrOp aOp;
                TypeInfo.PtrOp pOp = (TypeInfo.PtrOp)pPtrs.iterator().next();
                TypeInfo.PtrOp ptrOp = aOp = aPtrs != null ? (TypeInfo.PtrOp)pPtrs.iterator().next() : null;
                if (pOp == null || aOp == null || pOp.getType() != aOp.getType()) return false;
                if (pOp.getType() == TypeInfo.PtrOp.t_memberPointer) return false;
                TypeInfo type = new TypeInfo(aSymbol.getTypeInfo());
                type.getPtrOperators().clear();
                map.put(pSymbol.getName(), type);
                return true;
            }
            map.put(pSymbol.getName(), a.getTypeInfo());
            return true;
        }
        if (pSymbol.isType(TypeInfo.t_template) && aSymbol.isType(TypeInfo.t_template)) {
            List pArgs = ((IParameterizedSymbol)pSymbol).getArgumentList();
            List aArgs = ((IParameterizedSymbol)aSymbol).getArgumentList();
            if (pArgs == null || aArgs == null || pArgs.size() != aArgs.size()) {
                return false;
            }
            Iterator pIter = pArgs.iterator();
            Iterator aIter = aArgs.iterator();
            while (pIter.hasNext()) {
                if (ParserSymbolTable.deduceTemplateArgument(map, (ISymbol)pIter.next(), (ISymbol)aIter.next(), argumentMap)) continue;
                return false;
            }
            return false;
        } else if (pSymbol.isType(TypeInfo.t_function) && aSymbol.isType(TypeInfo.t_function)) {
            List ptrs;
            TypeInfo.PtrOp op;
            IParameterizedSymbol pFunction = (IParameterizedSymbol)pSymbol;
            IParameterizedSymbol aFunction = (IParameterizedSymbol)aSymbol;
            if (!ParserSymbolTable.deduceTemplateArgument(map, aFunction.getReturnType(), pFunction.getReturnType(), argumentMap)) {
                return false;
            }
            if (pSymbol.getPtrOperators() != null && (op = (TypeInfo.PtrOp)(ptrs = pSymbol.getPtrOperators()).iterator().next()).getType() == TypeInfo.PtrOp.t_memberPointer && !ParserSymbolTable.deduceTemplateArgument(map, op.getMemberOf(), pFunction.getContainingSymbol(), argumentMap)) {
                return false;
            }
            List pParams = pFunction.getParameterList();
            List aParams = aFunction.getParameterList();
            if (pParams.size() != aParams.size()) {
                return false;
            }
            Iterator pIter = pParams.iterator();
            Iterator aIter = aParams.iterator();
            while (pIter.hasNext()) {
                if (ParserSymbolTable.deduceTemplateArgument(map, (ISymbol)pIter.next(), (ISymbol)aIter.next(), argumentMap)) continue;
                return false;
            }
            return false;
        } else {
            if (pSymbol.getType() != aSymbol.getType()) return false;
            if (pSymbol.getTypeInfo().getHasDefault() && (!aSymbol.getTypeInfo().getHasDefault() || aSymbol.getTypeInfo().getDefault().equals(pSymbol.getTypeInfo().getDefault()))) {
                return false;
            }
            map.put(pSymbol.getName(), aSymbol.getTypeInfo());
            return true;
        }
    }

    private static IParameterizedSymbol classTemplateSpecializationToFunctionTemplate(IParameterizedSymbol template) {
        IParameterizedSymbol transformed = (IParameterizedSymbol)template.clone();
        transformed.getArgumentList().clear();
        transformed.getContainedSymbols().clear();
        IParameterizedSymbol function = template.getSymbolTable().newParameterizedSymbol(transformed.getName(), TypeInfo.t_function);
        try {
            transformed.addSymbol(function);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
        function.addParameter(template);
        return transformed;
    }

    private static TemplateInstance transformFunctionTemplateForOrdering(IParameterizedSymbol template) {
        int size;
        List paramList = template.getParameterList();
        int n = size = paramList != null ? paramList.size() : 0;
        if (size == 0) {
            return null;
        }
        HashMap<ISymbol, ISymbol> map = new HashMap<ISymbol, ISymbol>();
        Iterator iterator = paramList.iterator();
        while (iterator.hasNext()) {
            ISymbol param = (ISymbol)iterator.next();
            ISymbol val = template.getSymbolTable().newSymbol(EMPTY_NAME, TypeInfo.t_type);
            map.put(param, val);
        }
        return new TemplateInstance(template.getSymbolTable(), template, map);
    }

    public void setLanguage(ParserLanguage language) {
        this._language = language;
    }

    public ParserLanguage getLanguage() {
        return this._language;
    }

    protected void pushCommand(Command command) {
        this.undoList.addFirst(command);
    }

    public Mark setMark() {
        Mark mark = new Mark();
        this.undoList.addFirst(mark);
        this.markSet.add(mark);
        return mark;
    }

    public boolean rollBack(Mark toMark) {
        if (this.markSet.contains(toMark)) {
            this.markSet.remove(toMark);
            Command command = (Command)this.undoList.removeFirst();
            while (command != toMark) {
                command.undoIt();
                command = (Command)this.undoList.removeFirst();
            }
            return true;
        }
        return false;
    }

    public boolean commit(Mark toMark) {
        if (this.markSet.contains(toMark)) {
            this.markSet.remove(toMark);
            Command command = (Command)this.undoList.removeLast();
            while (command != toMark) {
                command = (Command)this.undoList.removeLast();
            }
            return true;
        }
        return false;
    }

    protected static abstract class Command {
        protected Command() {
        }

        public abstract void undoIt();
    }

    public static class Mark
    extends Command {
        public void undoIt() {
        }
    }

    protected static class LookupData {
        public String name;
        public Map usingDirectives;
        public Set visited = new HashSet();
        public HashSet inheritanceChain;
        public List parameters;
        public HashSet associated;
        public ISymbol stopAt;
        public TypeInfo.eType type = TypeInfo.t_any;
        public TypeInfo.eType upperType = TypeInfo.t_undef;
        public boolean qualified = false;
        public boolean ignoreUsingDirectives = false;
        public boolean forUserDefinedConversion = false;
        public HashSet foundItems = null;
        public ISymbol templateInstance = null;

        public LookupData(String n, TypeInfo.eType t, ISymbol i) {
            this.name = n;
            this.type = t;
            this.templateInstance = i;
        }
    }

    private static class Cost {
        public TypeInfo source;
        public TypeInfo target;
        public boolean targetHadReference = false;
        public int lvalue;
        public int promotion;
        public int conversion;
        public int qualification;
        public int userDefined;
        public int rank = -1;
        public int detail;
        public static final int AMBIGUOUS_USERDEFINED_CONVERSION = 1;
        public static final int NO_MATCH_RANK = -1;
        public static final int IDENTITY_RANK = 0;
        public static final int LVALUE_OR_QUALIFICATION_RANK = 0;
        public static final int PROMOTION_RANK = 1;
        public static final int CONVERSION_RANK = 2;
        public static final int DERIVED_TO_BASE_CONVERSION = 3;
        public static final int USERDEFINED_CONVERSION_RANK = 4;
        public static final int ELLIPSIS_CONVERSION = 5;

        public Cost(TypeInfo s, TypeInfo t) {
            this.source = new TypeInfo(s);
            this.target = new TypeInfo(t);
        }

        public int compare(Cost cost) {
            int result = 0;
            if (this.rank != cost.rank) {
                return cost.rank - this.rank;
            }
            if (this.userDefined != 0 || cost.userDefined != 0) {
                if (this.userDefined == 0 || cost.userDefined == 0) {
                    return cost.userDefined - this.userDefined;
                }
                if (this.userDefined == 1 || cost.userDefined == 1 || this.userDefined != cost.userDefined) {
                    return 0;
                }
            }
            if (this.promotion > 0 || cost.promotion > 0) {
                result = cost.promotion - this.promotion;
            }
            if (this.conversion > 0 || cost.conversion > 0) {
                result = this.detail == cost.detail ? cost.conversion - this.conversion : cost.detail - this.detail;
            }
            if (result == 0) {
                if (cost.qualification != this.qualification) {
                    return cost.qualification - this.qualification;
                }
                if (cost.qualification == this.qualification && this.qualification == 0) {
                    return 0;
                }
                int size = cost.target.hasPtrOperators() ? cost.target.getPtrOperators().size() : 0;
                int size2 = this.target.hasPtrOperators() ? this.target.getPtrOperators().size() : 0;
                ListIterator iter1 = cost.target.getPtrOperators().listIterator(size);
                ListIterator iter2 = this.target.getPtrOperators().listIterator(size2);
                TypeInfo.PtrOp op1 = null;
                TypeInfo.PtrOp op2 = null;
                int subOrSuper = 0;
                int i = size < size2 ? size : size2;
                while (i > 0) {
                    op1 = (TypeInfo.PtrOp)iter1.previous();
                    op2 = (TypeInfo.PtrOp)iter2.previous();
                    if (subOrSuper == 0) {
                        subOrSuper = op1.compareCVTo(op2);
                    } else if (subOrSuper > 0 && op1.compareCVTo(op2) < 0 || subOrSuper < 0 && op1.compareCVTo(op2) > 0) {
                        result = -1;
                        break;
                    }
                    --i;
                }
                result = result == -1 ? 0 : (size == size2 ? subOrSuper : size - size2);
            }
            return result;
        }
    }
}

