/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class TemplateInstance
extends BasicSymbol {
    private final ParserSymbolTable _table;
    private ISymbol _instantiatedSymbol;
    private Map _argumentMap;

    protected TemplateInstance(ParserSymbolTable table, ISymbol symbol, Map argMap) {
        super(table, "");
        this._table = table;
        this._instantiatedSymbol = symbol;
        symbol.setTemplateInstance(this);
        this._argumentMap = argMap;
    }

    public boolean equals(Object t) {
        if (t == null || !(t instanceof TemplateInstance)) {
            return false;
        }
        TemplateInstance instance = (TemplateInstance)t;
        if (this._instantiatedSymbol != instance._instantiatedSymbol) {
            return false;
        }
        Iterator iter1 = this._argumentMap.keySet().iterator();
        Iterator iter2 = instance._argumentMap.keySet().iterator();
        int size = this._argumentMap.size();
        int size2 = instance._argumentMap.size();
        ISymbol t1 = null;
        ISymbol t2 = null;
        if (size == size2) {
            int i = size;
            while (i > 0) {
                t1 = (ISymbol)iter1.next();
                if (t1 != (t2 = (ISymbol)iter2.next()) || !this._argumentMap.get(t1).equals(instance._argumentMap.get(t2))) {
                    return false;
                }
                --i;
            }
        }
        return true;
    }

    public ISymbol getInstantiatedSymbol() {
        this._instantiatedSymbol.setTemplateInstance(this);
        return this._instantiatedSymbol;
    }

    public TypeInfo.eType getType() {
        ISymbol symbol = this._instantiatedSymbol;
        TypeInfo.eType returnType = this._instantiatedSymbol.getType();
        if (returnType == TypeInfo.t_type) {
            symbol = symbol.getTypeSymbol();
            TypeInfo info = null;
            while (symbol != null && symbol.getType() == TypeInfo.t_undef && symbol.getContainingSymbol().getType() == TypeInfo.t_template) {
                info = (TypeInfo)this._argumentMap.get(symbol);
                if (!info.isType(TypeInfo.t_type)) break;
                symbol = info.getTypeSymbol();
            }
            return info != null ? info.getType() : TypeInfo.t_type;
        }
        return returnType;
    }

    public boolean isType(TypeInfo.eType type) {
        return type == TypeInfo.t_any || this.getType() == type;
    }

    public boolean isType(TypeInfo.eType type, TypeInfo.eType upperType) {
        if (type == TypeInfo.t_any) {
            return true;
        }
        if (upperType == TypeInfo.t_undef) {
            return this.getType() == type;
        }
        return this.getType().compareTo(type) >= 0 && this.getType().compareTo(upperType) <= 0;
    }

    public ISymbol getTypeSymbol() {
        ISymbol symbol = this._instantiatedSymbol.getTypeSymbol();
        if (symbol != null && symbol.getType() == TypeInfo.t_undef && symbol.getContainingSymbol().getType() == TypeInfo.t_template) {
            TypeInfo info = (TypeInfo)this._argumentMap.get(symbol);
            return info != null ? info.getTypeSymbol() : null;
        }
        return symbol;
    }

    public TypeInfo getTypeInfo() {
        ISymbol symbol = this._instantiatedSymbol.getTypeSymbol();
        if (symbol != null && symbol.getType() == TypeInfo.t_undef && symbol.getContainingSymbol().getType() == TypeInfo.t_template) {
            TypeInfo info = (TypeInfo)this._argumentMap.get(symbol);
            return info;
        }
        return this._instantiatedSymbol.getTypeInfo();
    }

    public Map getArgumentMap() {
        return this._argumentMap;
    }
}

