/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.win32;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.internal.core.win32.ProcessInfo;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;

public class ProcessList
implements IProcessList {
    private IProcessInfo[] NOPROCESS = new IProcessInfo[0];

    public IProcessInfo[] getProcessList() {
        Process p = null;
        String command = null;
        InputStream in = null;
        IPluginDescriptor desc = CCorePlugin.getDefault().getDescriptor();
        if (desc instanceof PluginDescriptorModel) {
            PluginDescriptorModel model = (PluginDescriptorModel)desc;
            PluginFragmentModel[] fragments = model.getFragments();
            int i = 0;
            while (i < fragments.length) {
                String location = fragments[i].getLocation();
                try {
                    URL url = new URL(String.valueOf(location) + "/os/" + BootLoader.getOS() + "/" + BootLoader.getOSArch());
                    File path = new File(url.getFile(), "listtasks.exe");
                    if (path.exists()) {
                        command = path.getCanonicalPath();
                        break;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
                ++i;
            }
        }
        if (command != null) {
            try {
                p = ProcessFactory.getFactory().exec(command);
                in = p.getInputStream();
                InputStreamReader reader = new InputStreamReader(in);
                return this.parseListTasks(reader);
            }
            catch (IOException iOException) {}
        }
        return this.NOPROCESS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProcessInfo[] parseListTasks(InputStreamReader reader) {
        BufferedReader br = new BufferedReader(reader);
        ArrayList<ProcessInfo> processList = new ArrayList<ProcessInfo>();
        try {
            while (true) {
                String line;
                if ((line = br.readLine()) == null) {
                    return processList.toArray(new IProcessInfo[processList.size()]);
                }
                int tab = line.indexOf(9);
                if (tab == -1) continue;
                String proc = line.substring(0, tab).trim();
                String name = line.substring(tab).trim();
                try {
                    int pid = Integer.parseInt(proc);
                    processList.add(new ProcessInfo(pid, name));
                }
                catch (NumberFormatException numberFormatException) {
                    name = null;
                }
            }
        }
        catch (IOException iOException) {}
        return processList.toArray(new IProcessInfo[processList.size()]);
    }
}

