/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.win32;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.internal.core.win32.ProcessInfo;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public class ProcessList
implements IProcessList {
    private final int NAME = 1;
    private final int PID = 2;
    private final int OTHER = 3;

    public IProcessInfo[] getProcessList() {
        String OS = System.getProperty("os.name").toLowerCase();
        Process p = null;
        String command = null;
        InputStream in = null;
        if (OS.indexOf("windows xp") <= -1) {
            return new IProcessInfo[0];
        }
        command = "tasklist /fo csv /nh  /svc";
        try {
            p = ProcessFactory.getFactory().exec(command);
        }
        catch (IOException e) {
            return null;
        }
        in = p.getInputStream();
        InputStreamReader reader = new InputStreamReader(in);
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.eolIsSignificant(true);
        tokenizer.parseNumbers();
        boolean done = false;
        ArrayList<ProcessInfo> processList = new ArrayList<ProcessInfo>();
        String name = null;
        int pid = 0;
        int token_state = 1;
        while (!done) {
            try {
                block3 : switch (tokenizer.nextToken()) {
                    case 10: {
                        if (name == null) break;
                        processList.add(new ProcessInfo(pid, name));
                        name = null;
                        break;
                    }
                    case -1: {
                        done = true;
                        break;
                    }
                    case 34: {
                        switch (token_state) {
                            case 1: {
                                name = tokenizer.sval;
                                token_state = 2;
                                break block3;
                            }
                            case 2: {
                                try {
                                    pid = Integer.parseInt(tokenizer.sval);
                                }
                                catch (NumberFormatException e) {
                                    name = null;
                                }
                                token_state = 3;
                                break block3;
                            }
                            case 3: {
                                token_state = 1;
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return processList.toArray(new IProcessInfo[processList.size()]);
    }
}

