/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.CMarkerAnnotationModel;
import org.eclipse.cdt.internal.ui.editor.DocumentAdapter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class CDocumentProvider
extends FileDocumentProvider {
    private IBufferFactory fBufferFactory = new BufferFactory();
    private boolean fIsAboutToSave = false;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    protected IDocument createDocument(Object element) throws CoreException {
        if (!(element instanceof IStorageEditorInput)) {
            return null;
        }
        IStorage storage = ((IStorageEditorInput)element).getStorage();
        CDocument document = new CDocument();
        this.setDocumentContent((IDocument)document, storage.getContents(), this.getDefaultEncoding());
        this.initializeDocument((IDocument)document);
        return document;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        IStorageEditorInput input;
        IResource res;
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input2 = (IFileEditorInput)element;
            return new CMarkerAnnotationModel((IResource)input2.getFile());
        }
        if (element instanceof IStorageEditorInput && (res = (IResource)(input = (IStorageEditorInput)element).getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = CDocumentProvider.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource)) != null && res.exists()) {
            return new CMarkerAnnotationModel(res);
        }
        return super.createAnnotationModel(element);
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (!(element instanceof IFileEditorInput)) {
            return super.createElementInfo(element);
        }
        IFileEditorInput input = (IFileEditorInput)element;
        ITranslationUnit original = this.createTranslationUnit(input.getFile());
        if (original != null) {
            try {
                try {
                    this.refreshFile(input.getFile());
                }
                catch (CoreException x) {
                    this.handleCoreException(x, CEditorMessages.getString("TranslationUnitDocumentProvider.error.createElementInfo"));
                }
                IAnnotationModel m = this.createAnnotationModel(input);
                IWorkingCopy c = original.getSharedWorkingCopy(this.getProgressMonitor(), this.fBufferFactory);
                DocumentAdapter a = null;
                try {
                    a = (DocumentAdapter)c.getBuffer();
                }
                catch (ClassCastException x) {
                    Status status = new Status(4, "org.eclipse.cdt.ui", 2, "Shared working copy has wrong buffer", (Throwable)x);
                    throw new CoreException((IStatus)status);
                }
                FileDocumentProvider.FileSynchronizer f = new FileDocumentProvider.FileSynchronizer((FileDocumentProvider)this, input);
                f.install();
                TranslationUnitFileInfo info = new TranslationUnitFileInfo(a.getDocument(), m, f, c);
                info.setModificationStamp(this.computeModificationStamp((IResource)input.getFile()));
                ((AbstractDocumentProvider.ElementInfo)info).fStatus = a.getStatus();
                ((StorageDocumentProvider.StorageInfo)info).fEncoding = this.getPersistedEncoding(input);
                return info;
            }
            catch (CModelException x) {
                throw new CoreException(x.getStatus());
            }
        }
        return super.createElementInfo(element);
    }

    protected ITranslationUnit createTranslationUnit(IFile file) {
        ICElement element = CoreModel.getDefault().create(file);
        if (element instanceof ITranslationUnit) {
            return (ITranslationUnit)element;
        }
        return null;
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info instanceof TranslationUnitFileInfo) {
            TranslationUnitFileInfo cuInfo = (TranslationUnitFileInfo)info;
            cuInfo.fCopy.destroy();
        }
        super.disposeElementInfo(element, info);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo instanceof TranslationUnitFileInfo) {
            TranslationUnitFileInfo info = (TranslationUnitFileInfo)elementInfo;
            info.fCopy.reconcile();
            ITranslationUnit original = info.fCopy.getOriginalElement();
            IResource resource = original.getResource();
            if (resource == null) {
                super.doSaveDocument(monitor, element, document, overwrite);
                return;
            }
            if (resource != null && !overwrite) {
                this.checkSynchronizationState(info.fModificationStamp, resource);
            }
            this.fireElementStateChanging(element);
            try {
                try {
                    this.fIsAboutToSave = true;
                    info.fCopy.commit(overwrite, monitor);
                }
                catch (CoreException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
                catch (RuntimeException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
                Object var12_9 = null;
                this.fIsAboutToSave = false;
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                this.fIsAboutToSave = false;
                throw throwable;
            }
            AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)((AbstractDocumentProvider.ElementInfo)info).fModel;
            model.updateMarkers(((AbstractDocumentProvider.ElementInfo)info).fDocument);
            if (resource != null) {
                info.setModificationStamp(this.computeModificationStamp(resource));
            }
        } else {
            super.doSaveDocument(monitor, element, document, overwrite);
        }
    }

    public IBufferFactory getBufferFactory() {
        return this.fBufferFactory;
    }

    public IResource getUnderlyingResource(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return input.getFile();
        }
        return null;
    }

    public IWorkingCopy getWorkingCopy(IEditorInput element) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo instanceof TranslationUnitFileInfo) {
            TranslationUnitFileInfo info = (TranslationUnitFileInfo)elementInfo;
            return info.fCopy;
        }
        return null;
    }

    protected void initializeDocument(IDocument document) {
        if (document != null) {
            IDocumentPartitioner partitioner = CUIPlugin.getDefault().getTextTools().createDocumentPartitioner();
            partitioner.connect(document);
            document.setDocumentPartitioner(partitioner);
        }
    }

    public void saveDocumentContent(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (!this.fIsAboutToSave) {
            return;
        }
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            try {
                String encoding = this.getEncoding(element);
                if (encoding == null) {
                    encoding = ResourcesPlugin.getEncoding();
                }
                ByteArrayInputStream stream = new ByteArrayInputStream(document.get().getBytes(encoding));
                IFile file = input.getFile();
                file.setContents((InputStream)stream, overwrite, true, monitor);
            }
            catch (IOException x) {
                Status s = new Status(4, "org.eclipse.cdt.ui", 0, x.getMessage(), (Throwable)x);
                throw new CoreException((IStatus)s);
            }
        }
    }

    public void shutdown() {
    }

    public boolean isConnected(IEditorInput input) {
        return this.getElementInfo(input) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class BufferFactory
    implements IBufferFactory {
        protected BufferFactory() {
        }

        private IDocument internalGetDocument(IFileEditorInput input) throws CoreException {
            IDocument document = CDocumentProvider.this.getDocument(input);
            if (document != null) {
                return document;
            }
            return CDocumentProvider.this.createDocument(input);
        }

        public IBuffer createBuffer(IOpenable owner) {
            IWorkingCopy unit;
            ITranslationUnit original;
            IResource resource;
            if (owner instanceof IWorkingCopy && (resource = (original = (unit = (IWorkingCopy)owner).getOriginalElement()).getResource()) instanceof IFile) {
                FileEditorInput providerKey = new FileEditorInput((IFile)resource);
                IDocument document = null;
                IStatus status = null;
                try {
                    document = this.internalGetDocument((IFileEditorInput)providerKey);
                }
                catch (CoreException x) {
                    status = x.getStatus();
                    document = new Document();
                    CDocumentProvider.this.initializeDocument(document);
                }
                DocumentAdapter adapter = new DocumentAdapter((IOpenable)unit, document, (ILineTracker)new DefaultLineTracker(), CDocumentProvider.this, providerKey);
                adapter.setStatus(status);
                return adapter;
            }
            return DocumentAdapter.NULL;
        }
    }

    protected class TranslationUnitFileInfo
    extends FileDocumentProvider.FileInfo {
        IWorkingCopy fCopy;

        TranslationUnitFileInfo(IDocument document, IAnnotationModel model, FileDocumentProvider.FileSynchronizer fileSynchronizer, IWorkingCopy copy) {
            super((FileDocumentProvider)CDocumentProvider.this, document, model, fileSynchronizer);
            this.fCopy = copy;
        }

        void setModificationStamp(long timeStamp) {
            this.fModificationStamp = timeStamp;
        }
    }

    protected class CDocument
    extends AbstractDocument {
        public CDocument() {
            this.setTextStore((ITextStore)new GapTextStore(50, 300));
            this.setLineTracker((ILineTracker)new DefaultLineTracker());
            this.completeInitialization();
        }

        public CDocument(String initialContent) {
            this.setTextStore((ITextStore)new GapTextStore(50, 300));
            this.setLineTracker((ILineTracker)new DefaultLineTracker());
            this.getStore().set(initialContent);
            this.getTracker().set(initialContent);
            this.completeInitialization();
        }
    }
}

