/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.AddIncludeOnSelectionAction;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditorErrorTickUpdater;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.CMarkerAnnotation;
import org.eclipse.cdt.internal.ui.editor.OpenOnSelectionAction;
import org.eclipse.cdt.internal.ui.editor.SearchForReferencesAction;
import org.eclipse.cdt.internal.ui.text.CPairMatcher;
import org.eclipse.cdt.internal.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.tasklist.TaskList;

public class CEditor
extends TextEditor
implements ISelectionChangedListener {
    protected CContentOutlinePage fOutlinePage;
    private SearchForReferencesAction fSearchForReferencesAction;
    protected ISelectionChangedListener fStatusLineClearer;
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    protected CPairMatcher fBracketMatcher = new CPairMatcher(BRACKETS);
    private TabConverter fTabConverter;
    private MarkerAnnotationPreferences fAnnotationPreferences = new MarkerAnnotationPreferences();
    private CEditorErrorTickUpdater fCEditorErrorTickUpdater;
    public static final String MATCHING_BRACKETS = "matchingBrackets";
    public static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    public static final String SPACES_FOR_TABS = "spacesForTabs";
    public static final String LINKED_POSITION_COLOR = "linkedPositionColor";
    public static final String LANGUAGE_CPP = "CEditor.language.cpp";
    public static final String LANGUAGE_C = "CEditor.language.c";
    protected String fOutlinerContextMenuId;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;

    public CEditor() {
        CTextTools textTools = CUIPlugin.getDefault().getTextTools();
        this.setSourceViewerConfiguration(new CSourceViewerConfiguration(textTools, this));
        this.setDocumentProvider((IDocumentProvider)CUIPlugin.getDefault().getDocumentProvider());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.setEditorContextMenuId("#CEditorContext");
        this.setRulerContextMenuId("#CEditorRulerContext");
        this.setOutlinerContextMenuId("#CEditorOutlinerContext");
        this.fCEditorErrorTickUpdater = new CEditorErrorTickUpdater(this);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.fCEditorErrorTickUpdater.setAnnotationModel(this.getDocumentProvider().getAnnotationModel((Object)input));
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public IFile getInputFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput != null && editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public CContentOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = new CContentOutlinePage(this);
            this.fOutlinePage.addSelectionChangedListener(this);
        }
        return this.fOutlinePage;
    }

    public Object getAdapter(Class required) {
        if ((class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = CEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage).equals(required)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(required);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        block9: {
            AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            try {
                String property;
                block10: {
                    if (asv == null) break block9;
                    property = event.getProperty();
                    if ("org.eclipse.cdt.editor.tab.width".equals(property)) {
                        Object value;
                        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
                        String[] types = configuration.getConfiguredContentTypes((ISourceViewer)asv);
                        int i = 0;
                        while (true) {
                            if (i >= types.length) {
                                if (this.fTabConverter != null) {
                                    this.fTabConverter.setNumberOfSpacesPerTab(this.getPreferenceStore().getInt("org.eclipse.cdt.editor.tab.width"));
                                }
                                if (!((value = event.getNewValue()) instanceof Integer)) break;
                                asv.getTextWidget().setTabs(((Integer)value).intValue());
                                break block10;
                            }
                            asv.setIndentPrefixes(configuration.getIndentPrefixes((ISourceViewer)asv, types[i]), types[i]);
                            ++i;
                        }
                        if (value instanceof String) {
                            asv.getTextWidget().setTabs(Integer.parseInt((String)value));
                        }
                    }
                }
                if (!SPACES_FOR_TABS.equals(property)) break block9;
                if (this.isTabConversionEnabled()) {
                    this.startTabConversion();
                } else {
                    this.stopTabConversion();
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                super.handlePreferenceStoreChanged(event);
                throw throwable;
            }
            super.handlePreferenceStoreChanged(event);
            return;
        }
        Object var9_9 = null;
        super.handlePreferenceStoreChanged(event);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection;
        Object obj;
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection && (obj = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof ISourceReference) {
            try {
                ISourceRange range = ((ISourceReference)obj).getSourceRange();
                if (range != null) {
                    this.setSelection(range, !this.isActivePart());
                }
            }
            catch (CModelException e) {
                // empty catch block
            }
        }
    }

    public void setSelection(ICElement element) {
        if (element == null || element instanceof ITranslationUnit) {
            return;
        }
        if (element instanceof ISourceReference) {
            ISourceReference reference = (ISourceReference)element;
            this.setSelection(reference, true);
        }
    }

    public void setSelection(ISourceReference element, boolean moveCursor) {
        if (element != null) {
            try {
                this.setSelection(element.getSourceRange(), moveCursor);
            }
            catch (CModelException cModelException) {
                // empty catch block
            }
        }
    }

    public void setSelection(ISourceRange element, boolean moveCursor) {
        if (element == null) {
            return;
        }
        try {
            IRegion alternateRegion = null;
            int start = element.getStartPos();
            int length = element.getLength();
            if (start < 0 || length < 0) {
                start = 0;
                length = 0;
            }
            if (length == 0 && start == 0 && element.getStartLine() != 0 && (alternateRegion = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineInformation(element.getStartLine())) != null) {
                start = alternateRegion.getOffset();
                length = alternateRegion.getLength();
            }
            this.setHighlightRange(start, length, moveCursor);
            if (moveCursor) {
                start = element.getIdStartPos();
                length = element.getIdLength();
                if (start == 0 && length == 0 && alternateRegion != null) {
                    start = alternateRegion.getOffset();
                    length = alternateRegion.getLength();
                }
                if (start > -1 && this.getSourceViewer() != null) {
                    this.getSourceViewer().revealRange(start, length);
                    this.getSourceViewer().setSelectedRange(start, length);
                }
                this.updateStatusField("CursorPosition");
            }
            return;
        }
        catch (IllegalArgumentException x) {
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        if (moveCursor) {
            this.resetHighlightRange();
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        return this == service.getActivePart();
    }

    public void dispose() {
        if (this.fCEditorErrorTickUpdater != null) {
            this.fCEditorErrorTickUpdater.setAnnotationModel(null);
            this.fCEditorErrorTickUpdater = null;
        }
        if (this.fBracketMatcher != null) {
            this.fBracketMatcher.dispose();
            this.fBracketMatcher = null;
        }
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction action = new TextOperationAction(CEditorMessages.getResourceBundle(), "Comment.", (ITextEditor)this, 11);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.comment");
        this.setAction("Comment", (IAction)action);
        this.markAsStateDependentAction("Comment", true);
        action = new TextOperationAction(CEditorMessages.getResourceBundle(), "Uncomment.", (ITextEditor)this, 12);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.uncomment");
        this.setAction("Uncomment", (IAction)action);
        this.markAsStateDependentAction("Uncomment", true);
        action = new TextOperationAction(CEditorMessages.getResourceBundle(), "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.format");
        this.setAction("Format", (IAction)action);
        this.markAsStateDependentAction("Format", true);
        action = new ContentAssistAction(CEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        action = new TextOperationAction(CEditorMessages.getResourceBundle(), "ContentAssistTip.", (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)action);
        this.setAction("AddIncludeOnSelection", (IAction)new AddIncludeOnSelectionAction((ITextEditor)this));
        this.setAction("OpenOnSelection", (IAction)new OpenOnSelectionAction(this));
        this.fSearchForReferencesAction = new SearchForReferencesAction(this.getSelectionProvider());
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addGroup(menu, "group.edit", "group.reorganize");
        this.addGroup(menu, "group.edit", "group.generate");
        this.addGroup(menu, "group.edit", "group.new");
        this.addAction(menu, "group.edit", "Comment");
        this.addAction(menu, "group.edit", "Uncomment");
        MenuManager search = new MenuManager("Search", "group.search");
        menu.appendToGroup("group.find", (IContributionItem)search);
        if (SearchForReferencesAction.canActionBeAdded(this.getSelectionProvider().getSelection())) {
            search.add((IAction)this.fSearchForReferencesAction);
        }
        this.addAction(menu, "group.generate", "ContentAssistProposal");
        this.addAction(menu, "group.generate", "AddIncludeOnSelection");
        this.addAction(menu, "group.generate", "OpenOnSelection");
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ISelectionChangedListener sListener = new ISelectionChangedListener(){
            private Runnable fRunnable = new Runnable(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    CEditor.access$101(1.access$000(this.this$1), "CursorPosition");
                }
            };
            private Display fDisplay;

            public void selectionChanged(SelectionChangedEvent event) {
                if (this.fDisplay == null) {
                    this.fDisplay = CEditor.this.getSite().getShell().getDisplay();
                }
                this.fDisplay.asyncExec(this.fRunnable);
            }

            static /* synthetic */ CEditor access$000(1 x0) {
                return x0.CEditor.this;
            }
        };
        this.getSelectionProvider().addSelectionChangedListener(sListener);
        if (this.isTabConversionEnabled()) {
            this.startTabConversion();
        }
    }

    private IMarker getNextError(int offset, boolean forward) {
        IMarker nextError = null;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int endOfDocument = document.getLength();
        int distance = 0;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Position p;
            MarkerAnnotation ma;
            IMarker marker;
            Annotation a = (Annotation)e.next();
            if (!(a instanceof CMarkerAnnotation) || !MarkerUtilities.isMarkerType((IMarker)(marker = (ma = (MarkerAnnotation)a).getMarker()), (String)"org.eclipse.core.resources.problemmarker") || (p = model.getPosition(a)).includes(offset)) continue;
            int currentDistance = 0;
            if (forward) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument - offset + p.getOffset();
                }
            } else {
                currentDistance = offset - p.getOffset();
                if (currentDistance < 0) {
                    currentDistance = offset + endOfDocument - p.getOffset();
                }
            }
            if (nextError != null && (currentDistance >= distance || currentDistance == 0)) continue;
            distance = currentDistance;
            if (distance == 0) {
                distance = endOfDocument;
            }
            nextError = marker;
        }
        return nextError;
    }

    public void gotoError(boolean forward) {
        ITextSelection s;
        IMarker nextError;
        ISelectionProvider provider = this.getSelectionProvider();
        if (this.fStatusLineClearer != null) {
            provider.removeSelectionChangedListener(this.fStatusLineClearer);
            this.fStatusLineClearer = null;
        }
        if ((nextError = this.getNextError((s = (ITextSelection)provider.getSelection()).getOffset(), forward)) != null) {
            this.gotoMarker(nextError);
            IWorkbenchPage page = this.getSite().getPage();
            IViewPart view = page.findView("org.eclipse.ui.views.TaskList");
            if (view instanceof TaskList) {
                StructuredSelection ss = new StructuredSelection((Object)nextError);
                ((TaskList)view).setSelection((ISelection)ss, true);
            }
            this.getStatusLineManager().setErrorMessage(nextError.getAttribute("message", ""));
            this.fStatusLineClearer = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CEditor.this.getSelectionProvider().removeSelectionChangedListener(CEditor.this.fStatusLineClearer);
                    CEditor.this.fStatusLineClearer = null;
                    CEditor.this.getStatusLineManager().setErrorMessage("");
                }
            };
            provider.addSelectionChangedListener(this.fStatusLineClearer);
        } else {
            this.getStatusLineManager().setErrorMessage("");
        }
    }

    protected IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new TabConverter();
            this.fTabConverter.setNumberOfSpacesPerTab(this.getPreferenceStore().getInt("org.eclipse.cdt.editor.tab.width"));
            AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            asv.addTextConverter(this.fTabConverter);
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            asv.removeTextConverter(this.fTabConverter);
            this.fTabConverter = null;
        }
    }

    private boolean isTabConversionEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(SPACES_FOR_TABS);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        IFile file;
        String filename = this.getEditorInput().getName();
        boolean c_file = filename.endsWith(".c");
        if (!c_file && filename.endsWith(".h") && (file = this.getInputFile()) != null) {
            IProject project = file.getProject();
            c_file = !CoreModel.getDefault().hasCCNature(project);
        }
        this.fAnnotationAccess = this.createAnnotationAccess();
        ISharedTextColors sharedColors = EditorsPlugin.getDefault().getSharedTextColors();
        this.fOverviewRuler = new OverviewRuler(this.fAnnotationAccess, 12, sharedColors);
        Iterator e = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference preference = (AnnotationPreference)e.next();
            if (!preference.contributesToHeader()) continue;
            this.fOverviewRuler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        AdaptedSourceViewer sourceViewer = new AdaptedSourceViewer(parent, ruler, styles, this.fOverviewRuler, this.isOverviewRulerVisible(), c_file ? LANGUAGE_C : LANGUAGE_CPP);
        this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)sourceViewer, this.fOverviewRuler, this.fAnnotationAccess, sharedColors);
        this.configureSourceViewerDecorationSupport();
        return sourceViewer;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess(this.fAnnotationPreferences);
    }

    protected void configureSourceViewerDecorationSupport() {
        Iterator e = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            this.fSourceViewerDecorationSupport.setAnnotationPreference((AnnotationPreference)e.next());
        }
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)"org.eclipse.ui.workbench.texteditor.unknown", "othersIndicationColor", "othersIndication", "othersIndicationInOverviewRuler", 0);
        this.fSourceViewerDecorationSupport.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        this.fSourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        this.fSourceViewerDecorationSupport.setCursorLinePainterPreferenceKeys("currentLine", "currentLineColor");
        this.fSourceViewerDecorationSupport.setMarginPainterPreferenceKeys("printMargin", "printMarginColor", "printMarginColumn");
        this.fSourceViewerDecorationSupport.setSymbolicFontName(this.getFontPropertyPreferenceKey());
    }

    protected void setOutlinerContextMenuId(String menuId) {
        this.fOutlinerContextMenuId = menuId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$101(CEditor x0, String x1) {
        super.updateStatusField(x1);
    }

    public class AdaptedSourceViewer
    extends SourceViewer
    implements ITextViewerExtension {
        private List fTextConverters;
        private String fDisplayLanguage;

        public AdaptedSourceViewer(Composite parent, IVerticalRuler ruler, int styles, IOverviewRuler fOverviewRuler, boolean isOverviewRulerShowing, String language) {
            super(parent, ruler, fOverviewRuler, isOverviewRulerShowing, styles);
            this.fDisplayLanguage = language;
        }

        public void doOperation(int operation) {
            if (this.getTextWidget() == null) {
                return;
            }
            super.doOperation(operation);
        }

        public void insertTextConverter(ITextConverter textConverter, int index) {
            throw new UnsupportedOperationException();
        }

        public void addTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters == null) {
                this.fTextConverters = new ArrayList(1);
                this.fTextConverters.add(textConverter);
            } else if (!this.fTextConverters.contains(textConverter)) {
                this.fTextConverters.add(textConverter);
            }
        }

        public void removeTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters != null) {
                this.fTextConverters.remove(textConverter);
                if (this.fTextConverters.size() == 0) {
                    this.fTextConverters = null;
                }
            }
        }

        protected void customizeDocumentCommand(DocumentCommand command) {
            super.customizeDocumentCommand(command);
            if (this.fTextConverters != null) {
                Iterator e = this.fTextConverters.iterator();
                while (e.hasNext()) {
                    ((ITextConverter)e.next()).customizeDocumentCommand(this.getDocument(), command);
                }
            }
        }

        public void setDisplayLanguage(String language) {
            this.fDisplayLanguage = language;
        }

        public String getDisplayLanguage() {
            return this.fDisplayLanguage;
        }
    }

    static class TabConverter
    implements ITextConverter {
        private String fTabString = "";
        private int tabRatio = 0;

        TabConverter() {
        }

        public void setNumberOfSpacesPerTab(int ratio) {
            this.tabRatio = ratio;
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < ratio) {
                buffer.append(' ');
                ++i;
            }
            this.fTabString = buffer.toString();
        }

        public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
            String text = command.text;
            StringBuffer buffer = new StringBuffer();
            String TAB = "\t";
            StringTokenizer tokens = new StringTokenizer(text, "\t", true);
            int charCount = 0;
            try {
                charCount = command.offset - document.getLineInformationOfOffset(command.offset).getOffset();
            }
            catch (Exception ex) {
                // empty catch block
            }
            String nextToken = null;
            int spaces = 0;
            while (tokens.hasMoreTokens()) {
                nextToken = tokens.nextToken();
                if ("\t".equals(nextToken)) {
                    spaces = this.tabRatio - charCount % this.tabRatio;
                    int i = 0;
                    while (i < spaces) {
                        buffer.append(' ');
                        ++i;
                    }
                    charCount += spaces;
                    continue;
                }
                buffer.append(nextToken);
                charCount += nextToken.length();
            }
            command.text = buffer.toString();
        }
    }

    static interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }
}

