/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.BufferChangedEvent;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.IBufferChangedListener;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Display;

public class DocumentAdapter
implements IBuffer,
IDocumentListener {
    public static final IBuffer NULL = new NullBuffer();
    private IOpenable fOwner;
    IDocument fDocument;
    private DocumentSetCommand fSetCmd = new DocumentSetCommand();
    private DocumentReplaceCommand fReplaceCmd = new DocumentReplaceCommand();
    private Object fProviderKey;
    private CDocumentProvider fProvider;
    private String fLineDelimiter;
    private ILineTracker fLineTracker;
    private List fBufferListeners = new ArrayList(3);
    private IStatus fStatus;

    public void addBufferChangedListener(IBufferChangedListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.fBufferListeners.contains(listener)) {
            this.fBufferListeners.add(listener);
        }
    }

    public DocumentAdapter(IOpenable owner, IDocument document, ILineTracker lineTracker, CDocumentProvider provider, Object providerKey) {
        Assert.isNotNull((Object)document);
        Assert.isNotNull((Object)lineTracker);
        this.fOwner = owner;
        this.fDocument = document;
        this.fLineTracker = lineTracker;
        this.fProvider = provider;
        this.fProviderKey = providerKey;
        this.fDocument.addPrenotifiedDocumentListener((IDocumentListener)this);
    }

    public void setStatus(IStatus status) {
        this.fStatus = status;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    protected String getLineDelimiter() {
        if (this.fLineDelimiter == null) {
            try {
                this.fLineDelimiter = this.fDocument.getLineDelimiter(0);
            }
            catch (BadLocationException x) {
                // empty catch block
            }
            if (this.fLineDelimiter == null) {
                String sysLineDelimiter = System.getProperty("line.separator");
                String[] delimiters = this.fDocument.getLegalLineDelimiters();
                Assert.isTrue((delimiters.length > 0 ? 1 : 0) != 0);
                int i = 0;
                while (i < delimiters.length) {
                    if (delimiters[i].equals(sysLineDelimiter)) {
                        this.fLineDelimiter = sysLineDelimiter;
                        break;
                    }
                    ++i;
                }
                if (this.fLineDelimiter == null) {
                    this.fLineDelimiter = delimiters[0];
                }
            }
        }
        return this.fLineDelimiter;
    }

    public String normalize(String text) {
        this.fLineTracker.set(text);
        int lines = this.fLineTracker.getNumberOfLines();
        if (lines <= 1) {
            return text;
        }
        StringBuffer buffer = new StringBuffer(text);
        try {
            IRegion previous = this.fLineTracker.getLineInformation(0);
            int i = 1;
            while (i < lines) {
                int lastLineEnd = previous.getOffset() + previous.getLength();
                int lineStart = this.fLineTracker.getLineInformation(i).getOffset();
                this.fLineTracker.replace(lastLineEnd, lineStart - lastLineEnd, this.getLineDelimiter());
                buffer.replace(lastLineEnd, lineStart, this.getLineDelimiter());
                previous = this.fLineTracker.getLineInformation(i);
                ++i;
            }
            String delimiter = this.fLineTracker.getLineDelimiter(lines - 1);
            if (delimiter != null && delimiter.length() > 0) {
                buffer.replace(previous.getOffset() + previous.getLength(), buffer.length(), this.getLineDelimiter());
            }
            return buffer.toString();
        }
        catch (BadLocationException x) {
            return text;
        }
    }

    public void append(char[] text) {
        this.append(new String(text));
    }

    public void append(String text) {
        this.fReplaceCmd.replace(this.fDocument.getLength(), 0, this.normalize(text));
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        IDocument d = this.fDocument;
        this.fDocument = null;
        d.removePrenotifiedDocumentListener((IDocumentListener)this);
        this.fireBufferChanged(new BufferChangedEvent((IBuffer)this, 0, 0, null));
        this.fBufferListeners.clear();
    }

    public char getChar(int position) {
        try {
            return this.fDocument.getChar(position);
        }
        catch (BadLocationException x) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public char[] getCharacters() {
        String content = this.getContents();
        return content == null ? null : content.toCharArray();
    }

    public String getContents() {
        return this.fDocument.get();
    }

    public int getLength() {
        return this.fDocument.getLength();
    }

    public IOpenable getOwner() {
        return this.fOwner;
    }

    public String getText(int offset, int length) {
        try {
            return this.fDocument.get(offset, length);
        }
        catch (BadLocationException x) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public IResource getUnderlyingResource() {
        return this.fProvider != null ? this.fProvider.getUnderlyingResource(this.fProviderKey) : null;
    }

    public boolean hasUnsavedChanges() {
        return this.fProvider != null ? this.fProvider.canSaveDocument(this.fProviderKey) : false;
    }

    public boolean isClosed() {
        return this.fDocument == null;
    }

    public boolean isReadOnly() {
        IResource resource = this.getUnderlyingResource();
        return resource == null ? true : resource.isReadOnly();
    }

    public void removeBufferChangedListener(IBufferChangedListener listener) {
        Assert.isNotNull((Object)listener);
        this.fBufferListeners.remove(listener);
    }

    public void replace(int position, int length, char[] text) {
        this.replace(position, length, new String(text));
    }

    public void replace(int position, int length, String text) {
        this.fReplaceCmd.replace(position, length, this.normalize(text));
    }

    public void save(IProgressMonitor progress, boolean force) throws CModelException {
        if (this.fProvider != null) {
            try {
                this.fProvider.saveDocumentContent(progress, this.fProviderKey, this.fDocument, force);
            }
            catch (CoreException e) {
                throw new CModelException(e);
            }
        }
    }

    public void setContents(char[] contents) {
        this.setContents(new String(contents));
    }

    public void setContents(String contents) {
        int oldLength = this.fDocument.getLength();
        if (contents == null) {
            if (oldLength != 0) {
                this.fSetCmd.set("");
            }
        } else {
            String newContents = this.normalize(contents);
            int newLength = newContents.length();
            if (oldLength != newLength || !newContents.equals(this.fDocument.get())) {
                this.fSetCmd.set(newContents);
            }
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.fireBufferChanged(new BufferChangedEvent((IBuffer)this, event.getOffset(), event.getLength(), event.getText()));
    }

    private void fireBufferChanged(BufferChangedEvent event) {
        if (this.fBufferListeners != null && this.fBufferListeners.size() > 0) {
            Iterator e = ((AbstractList)new ArrayList(this.fBufferListeners)).iterator();
            while (e.hasNext()) {
                ((IBufferChangedListener)e.next()).bufferChanged(event);
            }
        }
    }

    protected class DocumentReplaceCommand
    implements Runnable {
        private int fOffset;
        private int fLength;
        private String fText;

        protected DocumentReplaceCommand() {
        }

        public void run() {
            try {
                DocumentAdapter.this.fDocument.replace(this.fOffset, this.fLength, this.fText);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void replace(int offset, int length, String text) {
            this.fOffset = offset;
            this.fLength = length;
            this.fText = text;
            Display.getDefault().syncExec((Runnable)this);
        }
    }

    protected class DocumentSetCommand
    implements Runnable {
        private String fContents;

        protected DocumentSetCommand() {
        }

        public void run() {
            DocumentAdapter.this.fDocument.set(this.fContents);
        }

        public void set(String contents) {
            this.fContents = contents;
            Display.getDefault().syncExec((Runnable)this);
        }
    }

    private static class NullBuffer
    implements IBuffer {
        private NullBuffer() {
        }

        public void addBufferChangedListener(IBufferChangedListener listener) {
        }

        public void append(char[] text) {
        }

        public void append(String text) {
        }

        public void close() {
        }

        public char getChar(int position) {
            return '\u0000';
        }

        public char[] getCharacters() {
            return null;
        }

        public String getContents() {
            return null;
        }

        public int getLength() {
            return 0;
        }

        public IOpenable getOwner() {
            return null;
        }

        public String getText(int offset, int length) {
            return null;
        }

        public IResource getUnderlyingResource() {
            return null;
        }

        public boolean hasUnsavedChanges() {
            return false;
        }

        public boolean isClosed() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        public void removeBufferChangedListener(IBufferChangedListener listener) {
        }

        public void replace(int position, int length, char[] text) {
        }

        public void replace(int position, int length, String text) {
        }

        public void save(IProgressMonitor progress, boolean force) throws CModelException {
        }

        public void setContents(char[] contents) {
        }

        public void setContents(String contents) {
        }
    }
}

