/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.IWorkingCopyManagerExtension;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.IEditorInput;

public class WorkingCopyManager
implements IWorkingCopyManager,
IWorkingCopyManagerExtension {
    private CDocumentProvider fDocumentProvider;
    private Map fMap;
    private boolean fIsShuttingDown;

    public WorkingCopyManager(CDocumentProvider provider) {
        Assert.isNotNull((Object)((Object)provider));
        this.fDocumentProvider = provider;
    }

    public void connect(IEditorInput input) throws CoreException {
        this.fDocumentProvider.connect(input);
    }

    public void disconnect(IEditorInput input) {
        this.fDocumentProvider.disconnect(input);
    }

    public void shutdown() {
        if (!this.fIsShuttingDown) {
            this.fIsShuttingDown = true;
            try {
                if (this.fMap != null) {
                    this.fMap.clear();
                    this.fMap = null;
                }
                this.fDocumentProvider.shutdown();
                Object var2_1 = null;
                this.fIsShuttingDown = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.fIsShuttingDown = false;
                throw throwable;
            }
        }
    }

    public ITranslationUnit getWorkingCopy(IEditorInput input) {
        ITranslationUnit unit = this.fMap == null ? null : (ITranslationUnit)this.fMap.get(input);
        return unit != null ? unit : this.fDocumentProvider.getWorkingCopy(input);
    }

    public void setWorkingCopy(IEditorInput input, ITranslationUnit workingCopy) {
        if (this.fDocumentProvider.isConnected(input)) {
            if (this.fMap == null) {
                this.fMap = new HashMap();
            }
            this.fMap.put(input, workingCopy);
        }
    }

    public void removeWorkingCopy(IEditorInput input) {
        this.fMap.remove(input);
        if (this.fMap.isEmpty()) {
            this.fMap = null;
        }
    }
}

