/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class CPartitionScanner
extends RuleBasedPartitionScanner {
    private static final String SKIP = "__skip";
    public static final String C_MULTILINE_COMMENT = "c_multi_line_comment";
    public static final String C_SINGLE_LINE_COMMENT = "c_single_line_comment";
    public static final String C_STRING = "c_string";

    public CPartitionScanner() {
        Token comment = new Token((Object)C_MULTILINE_COMMENT);
        Token single_comment = new Token((Object)C_SINGLE_LINE_COMMENT);
        Token string = new Token((Object)C_STRING);
        Token skip = new Token((Object)SKIP);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)single_comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)skip, '\\'));
        EmptyCommentRule wordRule = new EmptyCommentRule((IToken)comment);
        rules.add((Object)wordRule);
        rules.add(new MultiLineRule("/*", "*/", (IToken)comment));
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        this.setPredicateRules(result);
    }

    static class EmptyCommentRule
    extends WordRule
    implements IPredicateRule {
        private IToken fSuccessToken;

        public EmptyCommentRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.fSuccessToken = successToken;
            this.addWord("/**/", this.fSuccessToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return this.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.fSuccessToken;
        }
    }

    static class EmptyCommentDetector
    implements IWordDetector {
        EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }
}

