/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtility {
    static /* synthetic */ Class class$org$eclipse$cdt$core$model$ICElement;

    private EditorUtility() {
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = null;
        try {
            input = EditorUtility.getEditorInput(inputElement);
        }
        catch (CModelException x) {
            // empty catch block
        }
        if (input != null && (p = CUIPlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement) throws CModelException, PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws CModelException, PartInitException {
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            return EditorUtility.openInEditor(fileInput.getFile(), activate);
        }
        if (input != null) {
            return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, inputElement), activate);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart part, ICElement element) {
        if (element != null && part instanceof CEditor) {
            ((CEditor)part).setSelection(element);
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file != null && (p = CUIPlugin.getActivePage()) != null) {
            IEditorPart editorPart = p.openEditor(file, null, activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = CUIPlugin.getActivePage()) != null) {
            IEditorPart editorPart = p.openEditor(input, editorID, activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static void initializeHighlightRange(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            // empty if block
        }
    }

    private static IEditorInput getEditorInput(ICElement element) throws CModelException {
        while (element != null) {
            ITranslationUnit unit;
            IResource resource;
            ITranslationUnit tu;
            if (element instanceof IWorkingCopy && ((IWorkingCopy)element).isWorkingCopy()) {
                element = ((IWorkingCopy)element).getOriginalElement();
            }
            if (element instanceof ISourceReference && (tu = ((ISourceReference)element).getTranslationUnit()) != null) {
                element = tu;
            }
            if (element instanceof ITranslationUnit && (resource = (unit = (ITranslationUnit)element).getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            if (element instanceof IBinary) {
                return new ExternalEditorInput(EditorUtility.getStorage((IBinary)element));
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) throws CModelException {
        if (input instanceof ICElement) {
            return EditorUtility.getEditorInput((ICElement)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (input instanceof IStorage) {
            return new ExternalEditorInput((IStorage)input);
        }
        return null;
    }

    public static ICElement getActiveEditorCInput() {
        IEditorInput editorInput;
        IEditorPart part;
        IWorkbenchPage page = CUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null && (editorInput = part.getEditorInput()) != null) {
            return (ICElement)editorInput.getAdapter(class$org$eclipse$cdt$core$model$ICElement == null ? (class$org$eclipse$cdt$core$model$ICElement = EditorUtility.class$("org.eclipse.cdt.core.model.ICElement")) : class$org$eclipse$cdt$core$model$ICElement);
        }
        return null;
    }

    private static ITranslationUnit getTranslationUnit(ICElement element) {
        if (element == null) {
            return null;
        }
        int type = element.getElementType();
        if (60 == type) {
            return (ITranslationUnit)element;
        }
        if (14 == type) {
            return null;
        }
        if (element instanceof ISourceReference) {
            return ((ISourceReference)element).getTranslationUnit();
        }
        return EditorUtility.getTranslationUnit(element.getParent());
    }

    public static String getEditorID(String name) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        if (registry != null) {
            IEditorDescriptor descriptor = registry.getDefaultEditor(name);
            if (descriptor != null) {
                return descriptor.getId();
            }
            return registry.getDefaultEditor().getId();
        }
        return null;
    }

    public static String getEditorID(IEditorInput input, Object inputObject) {
        return EditorUtility.getEditorID(input.getName());
    }

    public static IStorage getStorage(IBinary bin) {
        FileStorage store;
        block15: {
            store = null;
            Process objdump = null;
            IResource file = null;
            file = bin.getResource();
            if (file == null) {
                return store;
            }
            IPath path = file.getLocation();
            try {
                try {
                    String[] args = new String[]{"objdump", "-CxS", path.toOSString()};
                    objdump = ProcessFactory.getFactory().exec(args);
                    StringBuffer buffer = new StringBuffer();
                    BufferedReader stdout = new BufferedReader(new InputStreamReader(objdump.getInputStream()));
                    char[] buf = new char[128];
                    while (stdout.read(buf, 0, buf.length) != -1) {
                        buffer.append(buf);
                    }
                    store = new FileStorage((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), path);
                }
                catch (SecurityException e) {
                    Object var10_14 = null;
                    if (objdump != null) {
                        objdump.destroy();
                    }
                    break block15;
                }
                catch (IndexOutOfBoundsException e) {
                    Object var10_15 = null;
                    if (objdump != null) {
                        objdump.destroy();
                    }
                    break block15;
                }
                catch (NullPointerException e) {
                    Object var10_16 = null;
                    if (objdump != null) {
                        objdump.destroy();
                    }
                    break block15;
                }
                catch (IOException e) {
                    Object var10_17 = null;
                    if (objdump != null) {
                        objdump.destroy();
                    }
                }
                Object var10_13 = null;
                if (objdump != null) {
                    objdump.destroy();
                }
            }
            catch (Throwable throwable) {
                Object var10_18 = null;
                if (objdump != null) {
                    objdump.destroy();
                }
                throw throwable;
            }
        }
        return store;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

