/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.BaseCElementContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class CElementContentProvider
extends BaseCElementContentProvider
implements ITreeContentProvider,
IElementChangedListener {
    protected StructuredViewer fViewer;
    protected Object fInput;
    static /* synthetic */ Class class$org$eclipse$cdt$core$model$ICElement;

    public void dispose() {
        super.dispose();
        CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (StructuredViewer)viewer;
        if (oldInput == null && newInput != null) {
            if (newInput instanceof ICModel) {
                CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this);
            }
        } else if (oldInput != null && newInput == null) {
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = newInput;
    }

    public CElementContentProvider() {
    }

    public CElementContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        super(provideMembers, provideWorkingCopy);
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (CModelException e) {
            CUIPlugin.getDefault().log(e);
            e.printStackTrace();
        }
    }

    protected void processDelta(ICElementDelta delta) throws CModelException {
        int i;
        Object parent;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        ICElement element = delta.getElement();
        if ((flags & 0x400) != 0 || (flags & 0x200) != 0) {
            this.postRefresh(element);
        }
        if (kind == 2) {
            parent = this.internalGetParent(element);
            this.postRemove(element);
            if (this.updateContainer(element)) {
                this.postRefresh(parent);
            }
        }
        if (kind == 1) {
            parent = this.internalGetParent(element);
            this.postAdd(parent, element);
            if (this.updateContainer(element)) {
                this.postRefresh(parent);
            }
        }
        if (kind == 4) {
            if ((flags & 0x800) != 0) {
                this.postRefresh(element.getCProject());
                return;
            }
            if (element instanceof ITranslationUnit || element instanceof IBinary || element instanceof IArchive) {
                this.postRefresh(element);
                return;
            }
        }
        if (delta.getResourceDeltas() != null) {
            IResourceDelta[] rd = delta.getResourceDeltas();
            i = 0;
            while (i < rd.length) {
                this.processResourceDelta(rd[i], element);
                ++i;
            }
        }
        ICElementDelta[] affectedChildren = delta.getAffectedChildren();
        i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private void processResourceDelta(IResourceDelta delta, Object parent) {
        IResourceDelta[] affectedChildren;
        int status = delta.getKind();
        IResource resource = delta.getResource();
        if (resource == null) {
            return;
        }
        if ((status & 2) != 0) {
            this.postRemove(resource);
        }
        if ((status & 1) != 0) {
            this.postAdd(parent, resource);
        }
        if ((affectedChildren = delta.getAffectedChildren()).length > 1) {
            this.postRefresh(resource);
            return;
        }
        int i = 0;
        while (i < affectedChildren.length) {
            this.processResourceDelta(affectedChildren[i], resource);
            ++i;
        }
    }

    private boolean updateContainer(ICElement cfile) {
        IArchiveContainer container = null;
        ICProject cproject = null;
        if (cfile instanceof IBinary) {
            IBinary bin = (IBinary)cfile;
            if (bin.isExecutable() || bin.isSharedLib()) {
                cproject = bin.getCProject();
                container = cproject.getBinaryContainer();
            }
        } else if (cfile instanceof IArchive) {
            cproject = cfile.getCProject();
            container = cproject.getArchiveContainer();
        }
        if (container != null) {
            this.postContainerRefresh((IParent)container, cproject);
            return true;
        }
        return false;
    }

    private void postContainerRefresh(final IParent container, final ICProject cproject) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CElementContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    if (container.hasChildren()) {
                        if (CElementContentProvider.this.fViewer.testFindItem((Object)container) != null) {
                            CElementContentProvider.this.fViewer.refresh((Object)container);
                        } else {
                            CElementContentProvider.this.fViewer.refresh((Object)cproject);
                        }
                    } else {
                        CElementContentProvider.this.fViewer.refresh((Object)cproject);
                    }
                }
            }
        });
    }

    private void postRefresh(final Object root) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CElementContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    CElementContentProvider.this.fViewer.refresh(root);
                }
            }
        });
    }

    private void postAdd(final Object parent, Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CElementContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    CElementContentProvider.this.fViewer.refresh(parent);
                }
            }
        });
    }

    private void postRemove(final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CElementContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    CElementContentProvider.this.fViewer.refresh(CElementContentProvider.this.internalGetParent(element));
                }
            }
        });
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().asyncExec(r);
        }
    }

    protected ICElement getAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        return (ICElement)((IAdaptable)o).getAdapter(class$org$eclipse$cdt$core$model$ICElement == null ? (class$org$eclipse$cdt$core$model$ICElement = CElementContentProvider.class$("org.eclipse.cdt.core.model.ICElement")) : class$org$eclipse$cdt$core$model$ICElement);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

