/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IndexModel;
import org.eclipse.cdt.ui.wizards.IWizardTab;
import org.eclipse.cdt.utils.ui.swt.IValidation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class IndexerBlock
implements IWizardTab {
    private Button indexerSwitch;
    IProject project;
    IValidation page;

    public IndexerBlock(IValidation valid, IProject p) {
        this.page = valid;
        this.project = p;
    }

    public Composite getControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout grid = new GridLayout();
        grid.numColumns = 1;
        composite.setLayout((Layout)grid);
        IndexModel indexer = CCorePlugin.getDefault().getIndexModel();
        this.indexerSwitch = new Button(composite, 131104);
        this.indexerSwitch.setAlignment(16384);
        this.indexerSwitch.setText("Enable indexing service for this project");
        this.indexerSwitch.setSelection(indexer.isEnabled(this.project));
        return composite;
    }

    public void doRun(IProject project, IProgressMonitor monitor) {
        IndexModel indexer = CCorePlugin.getDefault().getIndexModel();
        indexer.setEnabled(project, this.indexerSwitch.getSelection());
    }

    public Image getImage() {
        return null;
    }

    public String getLabel() {
        return "Indexer";
    }

    public boolean isValid() {
        return true;
    }

    public void setVisible(boolean visible) {
        IndexModel indexer = CCorePlugin.getDefault().getIndexModel();
        if (this.indexerSwitch != null) {
            this.indexerSwitch.setSelection(indexer.isEnabled(this.project));
        }
    }
}

