/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class ManageFunctionBreakpointActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ICElement fElement = null;
    static /* synthetic */ Class class$org$eclipse$cdt$core$model$IFunction;
    static /* synthetic */ Class class$org$eclipse$cdt$core$model$IMethod;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.getMethod() != null) {
            this.manageBreakpoint(this.getMethod());
        } else if (this.getFunction() != null) {
            this.manageBreakpoint(this.getFunction());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ICElement) {
            boolean enabled = this.enablesFor((ICElement)element);
            action.setEnabled(enabled);
            if (enabled) {
                this.setElement((ICElement)element);
                return;
            }
        }
        action.setEnabled(false);
        this.setElement(null);
    }

    public ICElement getElement() {
        return this.fElement;
    }

    public void setElement(ICElement element) {
        this.fElement = element;
    }

    private boolean enablesFor(ICElement element) {
        return true;
    }

    private void manageBreakpoint(IFunction function) {
        try {
            ICFunctionBreakpoint breakpoint = CDebugModel.functionBreakpointExists((IFunction)function);
            if (breakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
            } else {
                CDebugModel.createFunctionBreakpoint((IFunction)function, (boolean)true, (int)0, (String)"", (boolean)true);
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog("Cannot add breakpoint", e);
        }
    }

    private IFunction getFunction() {
        return this.getElement() != null ? (IFunction)this.getElement().getAdapter(class$org$eclipse$cdt$core$model$IFunction == null ? (class$org$eclipse$cdt$core$model$IFunction = ManageFunctionBreakpointActionDelegate.class$("org.eclipse.cdt.core.model.IFunction")) : class$org$eclipse$cdt$core$model$IFunction) : null;
    }

    private void manageBreakpoint(IMethod method) {
        try {
            ICFunctionBreakpoint breakpoint = CDebugModel.methodBreakpointExists((IMethod)method);
            if (breakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
            } else {
                CDebugModel.createMethodBreakpoint((IMethod)method, (boolean)true, (int)0, (String)"", (boolean)true);
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog("Cannot add breakpoint", e);
        }
    }

    private IMethod getMethod() {
        return this.getElement() != null ? (IMethod)this.getElement().getAdapter(class$org$eclipse$cdt$core$model$IMethod == null ? (class$org$eclipse$cdt$core$model$IMethod = ManageFunctionBreakpointActionDelegate.class$("org.eclipse.cdt.core.model.IMethod")) : class$org$eclipse$cdt$core$model$IMethod) : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

