/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.internal.core.CDebugUtils;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CWatchpoint;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CFormattedMemoryBlock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IProcess;

public class CDebugModel {
    public static String getPluginIdentifier() {
        return CDebugCorePlugin.getUniqueIdentifier();
    }

    public static IDebugTarget newDebugTarget(final ILaunch launch, final ICDITarget cdiTarget, final String name, final IProcess debuggeeProcess, final IProcess debuggerProcess, final IFile file, final boolean allowTerminate, final boolean allowDisconnect, boolean stopInMain) throws DebugException {
        final IDebugTarget[] target = new IDebugTarget[1];
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) {
                target[0] = new CDebugTarget(launch, 1, cdiTarget, name, debuggeeProcess, debuggerProcess, file, allowTerminate, allowDisconnect);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(r, null);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e);
            throw new DebugException(e.getStatus());
        }
        ICDIConfiguration config = cdiTarget.getSession().getConfiguration();
        if (config.supportsBreakpoints() && stopInMain) {
            CDebugModel.stopInMain((CDebugTarget)target[0]);
        }
        if (config.supportsResume()) {
            target[0].resume();
        }
        return target[0];
    }

    public static IDebugTarget newAttachDebugTarget(final ILaunch launch, final ICDITarget cdiTarget, final String name, final IProcess debuggerProcess, final IFile file) throws DebugException {
        final IDebugTarget[] target = new IDebugTarget[1];
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) {
                target[0] = new CDebugTarget(launch, 2, cdiTarget, name, null, debuggerProcess, file, false, true);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(r, null);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e);
            throw new DebugException(e.getStatus());
        }
        ((CDebugTarget)target[0]).handleDebugEvent(new ICDISuspendedEvent(){

            public ICDISessionObject getReason() {
                return null;
            }

            public ICDIObject getSource() {
                return cdiTarget;
            }
        });
        return target[0];
    }

    public static IDebugTarget newCoreFileDebugTarget(final ILaunch launch, final ICDITarget cdiTarget, final String name, final IProcess debuggerProcess, final IFile file) throws DebugException {
        final IDebugTarget[] target = new IDebugTarget[1];
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) {
                target[0] = new CDebugTarget(launch, 3, cdiTarget, name, null, debuggerProcess, file, true, false);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(r, null);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e);
            throw new DebugException(e.getStatus());
        }
        ((CDebugTarget)target[0]).handleDebugEvent(new ICDISuspendedEvent(){

            public ICDISessionObject getReason() {
                return null;
            }

            public ICDIObject getSource() {
                return cdiTarget;
            }
        });
        return target[0];
    }

    public static ICLineBreakpoint lineBreakpointExists(String fileName, int lineNumber) throws CoreException {
        String modelId = CDebugModel.getPluginIdentifier();
        String markerType = CLineBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICLineBreakpoint breakpoint;
            if (breakpoints[i] instanceof ICLineBreakpoint && (breakpoint = (ICLineBreakpoint)breakpoints[i]).getMarker().getType().equals(markerType) && breakpoint.getMarker().getResource().getLocation().toOSString().equals(fileName) && breakpoint.getLineNumber() == lineNumber) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static ICLineBreakpoint createLineBreakpoint(IResource resource, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean add) throws DebugException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDebugModel.getPluginIdentifier());
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        return new CLineBreakpoint(resource, attributes, add);
    }

    public static ICAddressBreakpoint addressBreakpointExists(IResource resource, long address) throws CoreException {
        String modelId = CDebugModel.getPluginIdentifier();
        String markerType = CAddressBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICAddressBreakpoint breakpoint;
            if (breakpoints[i] instanceof ICAddressBreakpoint && (breakpoint = (ICAddressBreakpoint)breakpoints[i]).getMarker().getType().equals(markerType) && breakpoint.getMarker().getResource().getLocation().toOSString().equals(resource.getLocation().toOSString())) {
                try {
                    if (Long.parseLong(breakpoint.getAddress()) == address) {
                        return breakpoint;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }

    public static ICAddressBreakpoint createAddressBreakpoint(IResource resource, long address, boolean enabled, int ignoreCount, String condition, boolean add) throws DebugException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDebugModel.getPluginIdentifier());
        attributes.put("charStart", new Integer(0));
        attributes.put("charEnd", new Integer(0));
        attributes.put("lineNumber", new Integer(-1));
        attributes.put("lineNumber", new Integer(-1));
        attributes.put("org.eclipse.cdt.debug.core.address", Long.toString(address));
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        return new CAddressBreakpoint(resource, attributes, add);
    }

    public static ICFunctionBreakpoint functionBreakpointExists(IFunction function) throws CoreException {
        String modelId = CDebugModel.getPluginIdentifier();
        String markerType = CFunctionBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICFunctionBreakpoint breakpoint;
            if (breakpoints[i] instanceof ICFunctionBreakpoint && (breakpoint = (ICFunctionBreakpoint)breakpoints[i]).getMarker().getType().equals(markerType) && breakpoint.getMarker().getResource().equals((Object)CDebugUtils.getFunctionResource(function)) && breakpoint.getFunction() != null && breakpoint.getFunction().equals(CDebugUtils.getFunctionName(function))) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static ICFunctionBreakpoint createFunctionBreakpoint(IFunction function, boolean enabled, int ignoreCount, String condition, boolean add) throws DebugException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDebugModel.getPluginIdentifier());
        int lineNumber = -1;
        int charStart = -1;
        int charEnd = -1;
        try {
            ISourceRange sourceRange = function.getSourceRange();
            if (sourceRange != null && (charEnd = (charStart = sourceRange.getStartPos()) + sourceRange.getLength()) == 0) {
                lineNumber = sourceRange.getStartLine();
            }
        }
        catch (CModelException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.cdt.debug.core.function", CDebugUtils.getFunctionName(function));
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        return new CFunctionBreakpoint(CDebugUtils.getFunctionResource(function), attributes, add);
    }

    public static ICFunctionBreakpoint methodBreakpointExists(IMethod method) throws CoreException {
        String modelId = CDebugModel.getPluginIdentifier();
        String markerType = CFunctionBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICFunctionBreakpoint breakpoint;
            if (breakpoints[i] instanceof ICFunctionBreakpoint && (breakpoint = (ICFunctionBreakpoint)breakpoints[i]).getMarker().getType().equals(markerType) && breakpoint.getMarker().getResource().equals((Object)CDebugUtils.getMethodResource(method)) && breakpoint.getFunction() != null && breakpoint.getFunction().equals(CDebugUtils.getMethodQualifiedName(method))) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static ICFunctionBreakpoint createMethodBreakpoint(IMethod method, boolean enabled, int ignoreCount, String condition, boolean add) throws DebugException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDebugModel.getPluginIdentifier());
        int lineNumber = -1;
        int charStart = -1;
        int charEnd = -1;
        try {
            ISourceRange sourceRange = method.getSourceRange();
            if (sourceRange != null && (charEnd = (charStart = sourceRange.getStartPos()) + sourceRange.getLength()) == 0) {
                lineNumber = sourceRange.getStartLine();
            }
        }
        catch (CModelException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.cdt.debug.core.function", CDebugUtils.getMethodQualifiedName(method));
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        return new CFunctionBreakpoint(CDebugUtils.getMethodResource(method), attributes, add);
    }

    public static ICWatchpoint watchpointExists(IResource resource, boolean write, boolean read, String expression) throws CoreException {
        String modelId = CDebugModel.getPluginIdentifier();
        String markerType = CWatchpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICWatchpoint breakpoint;
            if (breakpoints[i] instanceof ICWatchpoint && (breakpoint = (ICWatchpoint)breakpoints[i]).getMarker().getType().equals(markerType) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.isWriteType() == write && breakpoint.isReadType() == read && breakpoint.getExpression().equals(expression)) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static ICWatchpoint createWatchpoint(IResource resource, boolean writeAccess, boolean readAccess, String expression, boolean enabled, int ignoreCount, String condition, boolean add) throws DebugException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDebugModel.getPluginIdentifier());
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.expression", expression);
        attributes.put("org.eclipse.cdt.debug.core.read", new Boolean(readAccess));
        attributes.put("org.eclipse.cdt.debug.core.write", new Boolean(writeAccess));
        return new CWatchpoint(resource, attributes, add);
    }

    public static IExpression createExpression(IDebugTarget target, String text) throws DebugException {
        if (target != null && target instanceof CDebugTarget) {
            try {
                ICDIExpression cdiExpression = ((CDebugTarget)target).getCDISession().getExpressionManager().createExpression(text);
                return new CExpression((CDebugTarget)target, cdiExpression);
            }
            catch (CDIException e) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, e.getMessage(), null));
            }
        }
        return null;
    }

    public static IFormattedMemoryBlock createFormattedMemoryBlock(IDebugTarget target, String addressExpression, int format, int wordSize, int numberOfRows, int numberOfColumns, char paddingChar) throws DebugException {
        if (target != null && target instanceof CDebugTarget) {
            try {
                ICDIExpression expression = ((CDebugTarget)target).getCDISession().getExpressionManager().createExpression(addressExpression);
                ICDIMemoryBlock cdiMemoryBlock = ((CDebugTarget)target).getCDISession().getMemoryManager().createMemoryBlock(expression.getName(), wordSize * numberOfRows * numberOfColumns);
                return new CFormattedMemoryBlock((CDebugTarget)target, cdiMemoryBlock, expression, format, wordSize, numberOfRows, numberOfColumns, paddingChar);
            }
            catch (CDIException e) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, e.getMessage(), null));
            }
        }
        return null;
    }

    public static IFormattedMemoryBlock createFormattedMemoryBlock(IDebugTarget target, String addressExpression, int format, int wordSize, int numberOfRows, int numberOfColumns) throws DebugException {
        if (target != null && target instanceof CDebugTarget) {
            try {
                ICDIExpression expression = ((CDebugTarget)target).getCDISession().getExpressionManager().createExpression(addressExpression);
                ICDIMemoryBlock cdiMemoryBlock = ((CDebugTarget)target).getCDISession().getMemoryManager().createMemoryBlock(expression.getName(), wordSize * numberOfRows * numberOfColumns);
                return new CFormattedMemoryBlock((CDebugTarget)target, cdiMemoryBlock, expression, format, wordSize, numberOfRows, numberOfColumns);
            }
            catch (CDIException e) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, e.getMessage(), null));
            }
        }
        return null;
    }

    private static void stopInMain(CDebugTarget target) throws DebugException {
        block2: {
            ICDILocation location = target.getCDISession().getBreakpointManager().createLocation("", "main", 0);
            try {
                target.setInternalTemporaryBreakpoint(location);
            }
            catch (DebugException e) {
                String message = MessageFormat.format("Unable to set temporary breakpoint in main.\nReason: {0}\nContinue?", e.getStatus().getMessage());
                Status newStatus = new Status(2, e.getStatus().getPlugin(), 10000, message, null);
                if (CDebugUtils.question((IStatus)newStatus, target)) break block2;
                target.terminate();
                throw new DebugException((IStatus)new Status(0, e.getStatus().getPlugin(), e.getStatus().getCode(), e.getStatus().getMessage(), null));
            }
        }
    }
}

