/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.ICRegisterManager;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterObject;
import org.eclipse.cdt.debug.internal.core.CUpdateManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CRegisterGroup;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;

public class CRegisterManager
extends CUpdateManager
implements ICRegisterManager {
    private List fRegisterGroups;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$ICRegisterManager;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$core$CRegisterManager;

    public CRegisterManager(CDebugTarget target) {
        super(target);
    }

    public Object getAdapter(Class adapter) {
        if ((class$org$eclipse$cdt$debug$core$ICRegisterManager == null ? (class$org$eclipse$cdt$debug$core$ICRegisterManager = CRegisterManager.class$("org.eclipse.cdt.debug.core.ICRegisterManager")) : class$org$eclipse$cdt$debug$core$ICRegisterManager).equals(adapter)) {
            return this;
        }
        if ((class$org$eclipse$cdt$debug$internal$core$CRegisterManager == null ? (class$org$eclipse$cdt$debug$internal$core$CRegisterManager = CRegisterManager.class$("org.eclipse.cdt.debug.internal.core.CRegisterManager")) : class$org$eclipse$cdt$debug$internal$core$CRegisterManager).equals(adapter)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        this.removeAllRegisterGroups();
    }

    public void addRegisterGroup(IRegisterGroup group) {
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return this.fRegisterGroups.toArray(new IRegisterGroup[this.fRegisterGroups.size()]);
    }

    public void initialize() {
        this.fRegisterGroups = new ArrayList(20);
        boolean autoRefresh = CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_REGISTERS_AUTO_REFRESH);
        if (this.getCDIManager() != null) {
            this.getCDIManager().setAutoUpdate(autoRefresh);
        }
        this.createMainRegisterGroup();
    }

    public void removeAllRegisterGroups() {
        Iterator it = this.fRegisterGroups.iterator();
        while (it.hasNext()) {
            ((CRegisterGroup)((Object)it.next())).dispose();
        }
        this.fRegisterGroups.clear();
    }

    public void removeRegisterGroup(IRegisterGroup group) {
        this.fRegisterGroups.remove(group);
    }

    private void createMainRegisterGroup() {
        ICDIRegisterObject[] regObjects = null;
        try {
            regObjects = this.getDebugTarget().getCDISession().getRegisterManager().getRegisterObjects();
        }
        catch (CDIException e) {
            CDebugCorePlugin.log(e);
        }
        if (regObjects != null) {
            this.fRegisterGroups.add(new CRegisterGroup(this.getDebugTarget(), "Main", regObjects));
        }
    }

    public void reset() {
        Iterator it = this.fRegisterGroups.iterator();
        while (it.hasNext()) {
            ((CRegisterGroup)((Object)it.next())).resetChangeFlags();
        }
    }

    protected ICDIManager getCDIManager() {
        if (this.getDebugTarget() != null) {
            return this.getDebugTarget().getCDISession().getRegisterManager();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

