/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.ICSharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIManager;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.internal.core.CUpdateManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CSharedLibrary;
import org.eclipse.debug.core.DebugException;

public class CSharedLibraryManager
extends CUpdateManager
implements ICSharedLibraryManager {
    private ArrayList fSharedLibraries = new ArrayList(5);
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$ICSharedLibraryManager;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$core$CSharedLibraryManager;

    public CSharedLibraryManager(CDebugTarget target) {
        super(target);
        boolean autoRefresh = CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_SHARED_LIBRARIES_AUTO_REFRESH);
        if (this.getCDIManager() != null) {
            this.getCDIManager().setAutoUpdate(autoRefresh);
        }
    }

    public synchronized void sharedLibraryLoaded(ICDISharedLibrary cdiLibrary) {
        CSharedLibrary library = new CSharedLibrary(this.getDebugTarget(), cdiLibrary);
        this.fSharedLibraries.add(library);
        library.fireCreationEvent();
    }

    public synchronized void sharedLibraryUnloaded(ICDISharedLibrary cdiLibrary) {
        CSharedLibrary library = this.find(cdiLibrary);
        if (library != null) {
            ((AbstractCollection)this.fSharedLibraries).remove(library);
            library.dispose();
            library.fireTerminateEvent();
        }
    }

    public void symbolsLoaded(ICDISharedLibrary cdiLibrary) {
        CSharedLibrary library = this.find(cdiLibrary);
        if (library != null) {
            this.getDebugTarget().setRetryBreakpoints(true);
            library.fireChangeEvent(256);
        }
    }

    public ICSharedLibrary[] getSharedLibraries() {
        return this.fSharedLibraries.toArray(new ICSharedLibrary[this.fSharedLibraries.size()]);
    }

    public void dispose() {
        Iterator it = ((AbstractList)this.fSharedLibraries).iterator();
        while (it.hasNext()) {
            ((ICSharedLibrary)it.next()).dispose();
        }
        this.fSharedLibraries.clear();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$cdt$debug$core$ICSharedLibraryManager == null ? (class$org$eclipse$cdt$debug$core$ICSharedLibraryManager = CSharedLibraryManager.class$("org.eclipse.cdt.debug.core.ICSharedLibraryManager")) : class$org$eclipse$cdt$debug$core$ICSharedLibraryManager)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$internal$core$CSharedLibraryManager == null ? (class$org$eclipse$cdt$debug$internal$core$CSharedLibraryManager = CSharedLibraryManager.class$("org.eclipse.cdt.debug.internal.core.CSharedLibraryManager")) : class$org$eclipse$cdt$debug$internal$core$CSharedLibraryManager)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected CSharedLibrary find(ICDISharedLibrary cdiLibrary) {
        Iterator it = ((AbstractList)this.fSharedLibraries).iterator();
        while (it.hasNext()) {
            CSharedLibrary library = (CSharedLibrary)it.next();
            if (!library.getCDISharedLibrary().equals(cdiLibrary)) continue;
            return library;
        }
        return null;
    }

    protected ICDIManager getCDIManager() {
        if (this.getDebugTarget() != null) {
            return this.getDebugTarget().getCDISession().getSharedLibraryManager();
        }
        return null;
    }

    public void loadSymbols(ICSharedLibrary[] libraries) throws DebugException {
        ICDISharedLibraryManager slm = (ICDISharedLibraryManager)this.getCDIManager();
        if (slm != null) {
            ArrayList<ICDISharedLibrary> cdiLibs = new ArrayList<ICDISharedLibrary>(libraries.length);
            int i = 0;
            while (i < libraries.length) {
                cdiLibs.add(((CSharedLibrary)libraries[i]).getCDISharedLibrary());
                ++i;
            }
            try {
                slm.loadSymbols(cdiLibs.toArray(new ICDISharedLibrary[cdiLibs.size()]));
            }
            catch (CDIException e) {
                this.getDebugTarget().targetRequestFailed(e.getMessage(), null);
            }
        }
    }

    public void loadSymbolsForAll() throws DebugException {
        ICDISharedLibraryManager slm = (ICDISharedLibraryManager)this.getCDIManager();
        if (slm != null) {
            try {
                slm.loadSymbols();
            }
            catch (CDIException e) {
                this.getDebugTarget().targetRequestFailed(e.getMessage(), null);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

